---
generated_at: 2026-01-27 13:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-CSS

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/css-language-features/client/src/cssClient.ts` - メインクライアント
- E-02: `extensions/css-language-features/client/src/node/cssClientMain.ts` - Node.jsエントリー
- E-03: `extensions/css-language-features/client/src/customData.ts` - カスタムデータ
- E-04: `extensions/css-language-features/client/src/requests.ts` - リクエスト定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LSP準拠のCSS Language Server | E-01 (LanguageClient) | ○ |
| C-02 | CSS/SCSS/Less対応 | E-01 (documentSelector) | ○ |
| C-03 | CSSFormatSettingsでフォーマット設定 | E-01 | ○ |
| C-04 | 言語別フォーマッタ登録 | E-01 (formatterRegistrations) | ○ |
| C-05 | カスタムデータ拡張 | E-03 (getCustomDataSource) | ○ |
| C-06 | CustomDataChangedNotification | E-01 | ○ |
| C-07 | リージョン補完（#region/#endregion） | E-01 (regionCompletionRegExpr) | ○ |
| C-08 | カラーラベル表示 | E-01 (updateLabel for Color) | ○ |
| C-09 | applyCodeActionコマンド | E-01 | ○ |
| C-10 | startClient関数 | E-01 | ○ |
| C-11 | serveFileSystemRequests | E-01, E-04 | ○ |
| C-12 | 設定変更時のフォーマッタ再登録 | E-01 (onDidChangeConfiguration) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり
- 0: 低リスク - LSP通信パターンは正確
- 0: 低リスク - フォーマット設定は正確

## 6) レビュアーチェックリスト（最小）
- [ ] CSS/SCSS/Lessの言語別設定が正しく記載されているか
- [ ] フォーマットオプションの説明が正確か
- [ ] カスタムデータの読み込み仕様が正確か
