---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：71-Markdown

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値（1秒以内）の根拠不足
  2. **Jupyter Notebook対応**：notebook対応コードの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/markdown-language-features/src/extension.ts` - activate関数
- E-02: `extensions/markdown-language-features/src/markdownEngine.ts` - MarkdownItEngineクラス
- E-03: `extensions/markdown-language-features/src/preview/previewManager.ts` - MarkdownPreviewManagerクラス
- E-04: `extensions/markdown-language-features/src/client/client.ts` - MdLanguageClientクラス
- E-05: `extensions/markdown-language-features/src/slugify.ts` - githubSlugifier
- E-06: `機能一覧.csv` - 71行目、Markdown言語機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | markdown-itライブラリでパース・レンダリング | E-02 (131行目 import) | ○ |
| C-02 | highlight.jsでコードハイライト | E-02 (408行目 import) | ○ |
| C-03 | GitHub互換slugifyで見出しID生成 | E-01 (13行目), E-05 | ○ |
| C-04 | 言語サーバー起動とクライアント連携 | E-01 (24行目), E-04 | ○ |
| C-05 | Webviewでプレビュー表示 | E-03 (90-94行目 registerWebviewPanelSerializer) | ○ |
| C-06 | トークンキャッシュ機能 | E-02 (47-80行目 TokenCacheクラス) | ○ |
| C-07 | 画像URI解決処理 | E-02 (250-270行目 _addImageRenderer) | ○ |
| C-08 | CSPによるセキュリティ制御 | E-03 (227行目 Content-Security-Policy) | ○ |
| C-09 | プレビューの動的/静的切り替え | E-03 (77-78行目 _dynamicPreviews, _staticPreviews) | ○ |
| C-10 | リンク検証・診断機能 | E-04 (30-55行目 各種リクエストメソッド) | ○ |
| C-11 | スクロール同期機能 | E-03 (96-104行目 TopmostLineMonitor) | ○ |
| C-12 | ファイルリネーム時のリンク更新 | E-04 (34-35行目 getEditForFileRenames) | ○ |
| C-13 | Markdown-itプラグイン拡張機能対応 | E-02 (135-141行目 プラグイン適用ループ) | ○ |
| C-14 | Front Matterサポート | E-02 (143-157行目 markdown-it-front-matter) | ○ |
| C-15 | 言語ID判定でMarkdownファイル識別 | E-04 (63行目 markdownLanguageIds) | ○ |
| C-16 | プレビュー設定（breaks, linkify等） | E-02 (44-46行目 MarkdownItConfig) | ○ |
| C-17 | パフォーマンス要件（1秒以内） | **根拠なし** | △ |
| C-18 | Jupyter Notebookのセル対応 | E-04 (88-99行目 notebookFeature) | ○ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の「1秒以内」は明示的な仕様として確認できず
  - 候補：パフォーマンステスト / ドキュメント / 設計仕様書
- debounce処理の具体的なタイミング設定値
  - 候補：previewConfig.ts / settings定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の実装は確認済み
- 1: 中リスク - パフォーマンス要件の検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（1秒以内）の妥当性を確認
- [ ] Jupyter Notebook対応の動作確認
- [ ] セキュリティレベル設定の詳細仕様を確認
