---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：72-PHP

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/php-language-features/src/phpMain.ts` - activate関数
- E-02: `extensions/php-language-features/src/features/completionItemProvider.ts` - PHPCompletionItemProviderクラス
- E-03: `extensions/php-language-features/src/features/phpGlobals.ts` - グローバル定義
- E-04: `extensions/php-language-features/src/features/phpGlobalFunctions.ts` - 関数定義
- E-05: `機能一覧.csv` - 72行目、PHP言語機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CompletionItemProviderの登録 | E-01 (19行目) | ○ |
| C-02 | HoverProviderの登録 | E-01 (20行目) | ○ |
| C-03 | SignatureHelpProviderの登録 | E-01 (21行目) | ○ |
| C-04 | ValidationProviderのアクティベート | E-01 (15-16行目) | ○ |
| C-05 | トリガー文字 '>' と '$' | E-01 (19行目) | ○ |
| C-06 | シグネチャヘルプトリガー '(' と ',' | E-01 (21行目) | ○ |
| C-07 | php.suggest.basic設定の確認 | E-02 (15-18行目) | ○ |
| C-08 | '->'演算子の判定ロジック | E-02 (26-32行目) | ○ |
| C-09 | グローバル変数の補完 | E-02 (66-71行目) | ○ |
| C-10 | グローバル関数の補完 | E-02 (72-77行目) | ○ |
| C-11 | ドキュメント内変数の正規表現抽出 | E-02 (92-102行目) | ○ |
| C-12 | ドキュメント内関数の正規表現抽出 | E-02 (103-111行目) | ○ |
| C-13 | 変数抽出正規表現パターン | E-02 (93行目) | ○ |
| C-14 | 関数抽出正規表現パターン | E-02 (103行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] validationProvider.tsの詳細実装を確認（php -lコマンド実行部分）
- [ ] hoverProvider.tsの詳細実装を確認
- [ ] signatureHelpProvider.tsの詳細実装を確認
