---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：73-Emmet

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/emmet/src/emmetCommon.ts` - activateEmmetExtension関数
- E-02: `extensions/emmet/src/abbreviationActions.ts` - 略語展開処理
- E-03: `extensions/emmet/src/defaultCompletionProvider.ts` - 補完プロバイダー
- E-04: `extensions/emmet/src/util.ts` - ユーティリティ関数
- E-05: `機能一覧.csv` - 73行目、Emmet機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | wrapWithAbbreviationコマンド登録 | E-01 (29-31行目) | ○ |
| C-02 | expandAbbreviationコマンド登録 | E-01 (33-35行目) | ○ |
| C-03 | removeTagコマンド登録 | E-01 (37-39行目) | ○ |
| C-04 | updateTagコマンド登録 | E-01 (41-46行目) | ○ |
| C-05 | matchTagコマンド登録 | E-01 (48-50行目) | ○ |
| C-06 | balanceOut/balanceInコマンド登録 | E-01 (52-58行目) | ○ |
| C-07 | incrementDecrementコマンド登録 | E-01 (92-114行目) | ○ |
| C-08 | 補完プロバイダー登録 | E-01 (163-226行目) | ○ |
| C-09 | インライン補完プロバイダー対応 | E-01 (167-193行目) | ○ |
| C-10 | 空白直後のスキップ処理 | E-02 (272-285行目) | ○ |
| C-11 | excludeLanguages設定対応 | E-02 (291-294行目) | ○ |
| C-12 | fallbackTab処理 | E-02 (420-425行目) | ○ |
| C-13 | isValidLocationForEmmetAbbreviation関数 | E-02 (436-618行目) | ○ |
| C-14 | expandAbbr関数でhelper.expandAbbreviation呼び出し | E-02 (693-694行目) | ○ |
| C-15 | 設定変更時の補完プロバイダー更新 | E-01 (124-131行目) | ○ |
| C-16 | スニペット保存時の拡張パス更新 | E-01 (133-138行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] LANGUAGE_MODES定義の完全性を確認
- [ ] emmet.useInlineCompletions設定の動作確認
- [ ] カスタムスニペット読み込み処理の詳細確認
