---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：74-Git統合

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **debounce既定値5000ms**：設定値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/git/src/main.ts` - activate関数、createModel関数
- E-02: `extensions/git/src/repository.ts` - Resourceクラス、RepositoryState
- E-03: `extensions/git/src/model.ts` - Modelクラス（参照）
- E-04: `extensions/git/src/commands.ts` - CommandCenterクラス（参照）
- E-05: `機能一覧.csv` - 74行目、Git統合の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | findGitでGit実行ファイルを検索 | E-01 (52-64行目) | ○ |
| C-02 | Gitインスタンス作成 | E-01 (86-91行目) | ○ |
| C-03 | Modelインスタンス作成 | E-01 (92行目) | ○ |
| C-04 | GitFileSystemProvider登録 | E-01 (116行目) | ○ |
| C-05 | GitDecorations登録 | E-01 (117行目) | ○ |
| C-06 | GitBlameController登録 | E-01 (118行目) | ○ |
| C-07 | GitTimelineProvider登録 | E-01 (119行目) | ○ |
| C-08 | Gitバージョン警告 | E-01 (264-290行目 checkGitv1) | ○ |
| C-09 | Git未検出時の警告 | E-01 (157-188行目 warnAboutMissingGit) | ○ |
| C-10 | ResourceのgetStatusLetter | E-02 (54-86行目) | ○ |
| C-11 | ResourceのgetStatusText | E-02 (89-111行目) | ○ |
| C-12 | ResourceのgetStatusColor | E-02 (114-147行目) | ○ |
| C-13 | RepositoryState enum定義 | E-02 (40-43行目) | ○ |
| C-14 | ResourceGroupType enum定義 | E-02 (45-50行目) | ○ |
| C-15 | IPCサーバー作成 | E-01 (66-72行目) | ○ |
| C-16 | Askpass初期化 | E-01 (74-75行目) | ○ |
| C-17 | GitEditor初期化 | E-01 (77-78行目) | ○ |
| C-18 | debounce処理5000ms | **根拠なし（要確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- debounce処理の具体的な設定値（5000ms）の根拠
  - 候補：repository.ts / model.ts / settings定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の実装は確認済み
- 1: 中リスク - パフォーマンス設定値の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] debounce設定値の正確な値を確認
- [ ] model.tsの詳細実装を確認
- [ ] commands.tsのコマンド一覧を確認
