---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：78-タスク自動検出（npm）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/npm/src/npmMain.ts` - activate関数
- E-02: `extensions/npm/src/tasks.ts` - NpmTaskProviderクラス
- E-03: `機能一覧.csv` - 78行目、npm自動検出の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | addJSONProviders呼び出し | E-01 (35行目) | ○ |
| C-02 | registerTaskProvider呼び出し | E-01 (36行目) | ○ |
| C-03 | registerExplorer呼び出し | E-01 (38行目) | ○ |
| C-04 | 設定変更時のキャッシュ無効化 | E-01 (40-52行目) | ○ |
| C-05 | registerHoverProvider呼び出し | E-01 (54行目) | ○ |
| C-06 | runSelectedScriptコマンド登録 | E-01 (56行目) | ○ |
| C-07 | runScriptFromFolderコマンド登録 | E-01 (62行目) | ○ |
| C-08 | refreshコマンド登録 | E-01 (63-65行目) | ○ |
| C-09 | NpmScriptLensProvider登録 | E-01 (78行目) | ○ |
| C-10 | ターミナルQuickFixプロバイダー登録 | E-01 (80-102行目) | ○ |
| C-11 | NpmTaskProviderクラス定義 | E-02 (46-87行目) | ○ |
| C-12 | INpmTaskDefinition定義 | E-02 (20-24行目) | ○ |
| C-13 | INSTALL_SCRIPT定数 | E-02 (34行目) | ○ |
| C-14 | buildNames配列 | E-02 (93行目) | ○ |
| C-15 | testNames配列 | E-02 (103行目) | ○ |
| C-16 | getScriptRunner関数 | E-02 (130-138行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] preferred-pm.tsのパッケージマネージャー検出ロジックを確認
- [ ] npmView.tsのツリービュー実装を確認
- [ ] scriptHover.tsのホバー実装を確認
