---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：79-タスク自動検出（Gulp）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/gulp/src/main.ts` - 拡張機能全体のソース
- E-02: `機能一覧.csv` - 79行目、Gulp自動検出の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | activate関数でTaskDetector作成 | E-01 (399-402行目) | ○ |
| C-02 | TaskDetectorクラス定義 | E-01 (271-396行目) | ○ |
| C-03 | FolderDetectorクラス定義 | E-01 (114-269行目) | ○ |
| C-04 | GulpTaskDefinitionインターフェース | E-01 (109-112行目) | ○ |
| C-05 | findGulpCommand関数 | E-01 (89-107行目) | ○ |
| C-06 | hasGulpfileメソッド | E-01 (163-201行目) | ○ |
| C-07 | computeTasksメソッド | E-01 (203-261行目) | ○ |
| C-08 | gulp --tasks-simple --no-colorコマンド | E-01 (214行目) | ○ |
| C-09 | buildNames配列 | E-01 (52行目) | ○ |
| C-10 | testNames配列 | E-01 (62行目) | ○ |
| C-11 | isBuildTask関数 | E-01 (53-60行目) | ○ |
| C-12 | isTestTask関数 | E-01 (63-70行目) | ○ |
| C-13 | isEnabled確認（gulp.autoDetect） | E-01 (128-129行目) | ○ |
| C-14 | ファイル監視パターン | E-01 (133行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Gulp CLIとの互換性確認（Gulp 4.x対応）
- [ ] TypeScript gulpfile（gulpfile.ts）の動作確認
- [ ] エラー表示（getOutputChannel）の確認
