---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：8-コードスニペット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **SnippetParser詳細構文**：根拠不足
  2. **セキュリティサニタイズの詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/editor/contrib/snippet/browser/snippetController2.ts` - SnippetController2
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連情報
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SnippetController2がID 'snippetController2'で登録 | E-01 (53行目) | ○ |
| C-02 | InSnippetModeコンテキストキー | E-01 (59行目) | ○ |
| C-03 | HasNextTabstopコンテキストキー | E-01 (60行目) | ○ |
| C-04 | HasPrevTabstopコンテキストキー | E-01 (61行目) | ○ |
| C-05 | ISnippetInsertOptionsでoverwriteBefore/After等定義 | E-01 (30-39行目) | ○ |
| C-06 | デフォルトオプションで undoStopBefore=true | E-01 (41-49行目) | ○ |
| C-07 | デフォルトオプションで undoStopAfter=true | E-01 (41-49行目) | ○ |
| C-08 | デフォルトオプションで adjustWhitespace=true | E-01 (41-49行目) | ○ |
| C-09 | insert()でテンプレート挿入 | E-01 (109-126行目) | ○ |
| C-10 | apply()でISnippetEdit[]挿入 | E-01 (96-107行目) | ○ |
| C-11 | _doInsert()が挿入処理本体 | E-01 (128-150行目) | ○ |
| C-12 | 挿入時にpushStackElement()でUndo境界作成 | E-01 (140-142行目) | ○ |
| C-13 | SnippetSessionで状態管理 | E-01 (68行目) | ○ |
| C-14 | エラー時にcancel()とログ出力 | E-01 (100-106行目, 119-125行目) | ○ |
| C-15 | テキストエディタが主画面として関連 | E-02 (36行目) | ○ |
| C-16 | 機能の備考にsrc/vs/editor/contrib/snippetが記載 | E-03 (9行目) | ○ |
| C-17 | SnippetParser詳細構文 | **根拠なし** | △ |
| C-18 | セキュリティサニタイズの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SnippetParserの詳細構文はsnippetParser.tsで確認が必要
  - 候補：`src/vs/editor/contrib/snippet/browser/snippetParser.ts`
- セキュリティサニタイズの詳細は変数リゾルバーで確認が必要
  - 候補：`src/vs/editor/contrib/snippet/browser/snippetVariables.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラ構造はコードと一致
- 0: 低リスク - オプションのデフォルト値はコードで確認可能
- 1: 中リスク - セキュリティ対策の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] SnippetController2.IDが正しく登録されているか確認
- [ ] コンテキストキー（InSnippetMode等）の動作を確認
- [ ] ISnippetInsertOptionsの各オプションの効果を確認
- [ ] エラー時のログ出力とキャンセル処理を確認
- [ ] SnippetSessionのライフサイクルを確認
