---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：81-タスク自動検出（Jake）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件のキャッシュ詳細**：実装の詳細確認が必要
  2. **Jake公式サイトURL**：外部リンクの有効性確認
  3. **buildNames/testNamesの網羅性**：実際のユースケースとの整合性

## 2) 参照した情報（Evidence一覧）

- E-01: `extensions/jake/src/main.ts` - メインソースコード
- E-02: `extensions/jake/package.json` - 拡張機能マニフェスト
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JakefileからタスクをVS Codeタスクシステムに統合 | E-01 (270-277行目) | ○ |
| C-02 | jake.autoDetect設定でon/offを制御 | E-02 (39-48行目), E-01 (100行目) | ○ |
| C-03 | ローカルjake優先、なければグローバル使用 | E-01 (67-78行目) | ○ |
| C-04 | build/compile/watchはBuildグループに分類 | E-01 (32-40行目, 173-174行目) | ○ |
| C-05 | testはTestグループに分類 | E-01 (42-50行目, 175-176行目) | ○ |
| C-06 | onTaskType:jakeでアクティベート | E-02 (24-26行目) | ○ |
| C-07 | jake --tasksコマンドでタスク取得 | E-01 (147行目) | ○ |
| C-08 | 正規表現でタスク名を抽出 | E-01 (161-163行目) | ○ |
| C-09 | ファイルウォッチャーでJakefile監視 | E-01 (104-108行目) | ○ |
| C-10 | 信頼されていないワークスペースでサポート | E-02 (29-31行目) | ○ |
| C-11 | 仮想ワークスペースは非サポート | E-02 (28行目) | ○ |
| C-12 | タスク定義にtaskとfileプロパティ | E-02 (51-69行目) | ○ |
| C-13 | エラー時に出力チャンネルに表示 | E-01 (52-58行目, 183-191行目) | ○ |
| C-14 | ShellExecutionでタスク実行 | E-01 (127行目, 170行目) | ○ |
| C-15 | ワークスペースフォルダごとにDetector作成 | E-01 (237-243行目) | ○ |
| C-16 | 設定変更時にDetector再作成 | E-01 (247-265行目) | ○ |
| C-17 | Jakefile.jsもサポート | E-01 (139-144行目) | ○ |
| C-18 | キャッシュによる効率化 | E-01 (113-116行目) promise変数 | △ |

## 4) 不足情報（Unknown / Missing）

- C-18のキャッシュ実装：promiseをキャッシュしているが、詳細な無効化戦略の明示的なドキュメントがない
  - 候補：設計ドキュメント / 開発者コメント / テストケース

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 基本的な機能説明は正確
- 1: 中リスク - パフォーマンス最適化の詳細説明
- 0: 低リスク - エラーハンドリングの説明

## 6) レビュアーチェックリスト（最小）

- [ ] 実際にJakeプロジェクトでタスク検出が動作することを確認
- [ ] jake.autoDetect=offでタスクが表示されないことを確認
- [ ] ビルド/テストグループの分類が期待通りか確認
- [ ] エラー発生時の出力チャンネル表示を確認
