---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：82-デバッグ自動起動

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **実際の動作確認**：各アクションタイプの動作テスト
  2. **killOnServerStopの動作**：子セッション終了の確認
  3. **パターンマッチングの精度**：様々なサーバー出力形式での検証

## 2) 参照した情報（Evidence一覧）

- E-01: `extensions/debug-server-ready/src/extension.ts` - メインソースコード
- E-02: `extensions/debug-server-ready/package.json` - 拡張機能マニフェスト、スキーマ定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトパターン "listening on.* (https?://\\S+\|[0-9]+)" | E-01 (10行目) | ○ |
| C-02 | action種別: openExternally, debugWithChrome, debugWithEdge, startDebugging | E-01 (17行目), E-02 | ○ |
| C-03 | onDebugResolveでアクティベート | E-02 (12-14行目) | ○ |
| C-04 | terminalDataWriteEvent APIを使用 | E-02 (21-23行目), E-01 (101行目) | ○ |
| C-05 | ANSIエスケープコード除去 | E-01 (26-45行目) | ○ |
| C-06 | 一度のみ発火（Triggerクラス） | E-01 (47-57行目, 146行目) | ○ |
| C-07 | URIフォーマット自動判定（数字ならポート） | E-01 (173行目) | ○ |
| C-08 | pwa-chrome/pwa-msedgeデバッガー使用 | E-01 (197, 201行目) | ○ |
| C-09 | killOnServerStop対応 | E-01 (220-223行目, 242-248行目) | ○ |
| C-10 | 親セッションのTrigger共有 | E-01 (127-131行目) | ○ |
| C-11 | uriFormatの%s検証 | E-01 (165-180行目) | ○ |
| C-12 | デバッグアダプタートラッカー登録 | E-01 (356-392行目) | ○ |
| C-13 | console/stderr/stdout出力監視 | E-01 (363-375行目) | ○ |
| C-14 | runInTerminal応答からPID取得 | E-01 (376-387行目) | ○ |
| C-15 | shellProcessIdでターミナル特定 | E-01 (92-97行目, 107-108行目) | ○ |
| C-16 | webRootデフォルト ${workspaceFolder} | E-01 (13行目), E-02 | ○ |
| C-17 | 信頼されていないワークスペースサポート | E-02 (16-19行目) | ○ |
| C-18 | 仮想ワークスペース非サポート | E-02 (16行目) | ○ |
| C-19 | startDebugSession - name/config両対応 | E-01 (268-297行目) | ○ |
| C-20 | セッション終了時のstop処理 | E-01 (83-90行目, 334-336行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし - すべての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 基本機能説明は正確
- 0: 低リスク - エラーハンドリング説明
- 1: 中リスク - 提案API (terminalDataWriteEvent) の将来的な変更可能性

## 6) レビュアーチェックリスト（最小）

- [ ] Node.jsサーバーで "listening on port 3000" 出力時にブラウザが開くことを確認
- [ ] debugWithChromeアクションでChromeデバッガーがアタッチされることを確認
- [ ] killOnServerStop=trueでサーバー停止時に子セッションが終了することを確認
- [ ] カスタムpatternで異なる出力形式に対応できることを確認
