---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：83-デバッグ自動アタッチ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **js-debug拡張機能との連携**：実際の動作確認
  2. **smartモードのパターンマッチ**：除外パターンの動作確認
  3. **信頼されていないワークスペースでの無効化**：セキュリティ動作確認

## 2) 参照した情報（Evidence一覧）

- E-01: `extensions/debug-auto-launch/src/extension.ts` - メインソースコード
- E-02: `extensions/debug-auto-launch/package.json` - 拡張機能マニフェスト
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フィルタモード: disabled, always, smart, onlyWithFlag | E-01 (23-28行目), E-02 | ○ |
| C-02 | onStartupFinishedでアクティベート | E-02 (17行目) | ○ |
| C-03 | ステータスバーにモード表示 | E-01 (63-80行目) | ○ |
| C-04 | toggleAutoAttachコマンド | E-02 (24-29行目), E-01 (30-60行目) | ○ |
| C-05 | 信頼されていないワークスペースでは無効 | E-01 (139行目), E-02 (13-15行目) | ○ |
| C-06 | js-debugのstartSelfHostコマンド呼び出し | E-01 (99-103行目) | ○ |
| C-07 | ターミナル再起動を促す | E-01 (123-130行目) | ○ |
| C-08 | 設定変更時に自動更新 | E-01 (145行目) | ○ |
| C-09 | Stateインターフェースでモード管理 | E-01 (17-21行目) | ○ |
| C-10 | clearCurrentState関数 | E-01 (83-93行目) | ○ |
| C-11 | StatusBarAlignment.Right配置 | E-01 (68行目) | ○ |
| C-12 | 優先度50設定 | E-01 (68行目) | ○ |
| C-13 | クイックピックでモード選択 | E-01 (30-60行目) | ○ |
| C-14 | アクセシビリティ情報付きステータスバー | E-01 (79行目) | ○ |
| C-15 | デバッグ自動アタッチのテキスト表示 | E-01 (71行目) | ○ |
| C-16 | 仮想ワークスペース非サポート | E-02 (12行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし - すべての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 基本機能説明は正確
- 0: 低リスク - ステータスバー表示
- 1: 中リスク - js-debug拡張機能との連携詳細（外部依存）

## 6) レビュアーチェックリスト（最小）

- [ ] ステータスバーのトグル操作でモードが切り替わることを確認
- [ ] alwaysモードでターミナルからNode.js実行時にデバッガーがアタッチされることを確認
- [ ] smartモードでnode_modules内のスクリプトがスキップされることを確認
- [ ] 信頼されていないワークスペースで自動アタッチが無効になることを確認
