---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-拡張機能開発

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **SVG許可リストの動作**：product.jsonとの連携確認
  2. **提案API制限の動作**：enabledApiProposalsの検証確認
  3. **when句検証の精度**：様々なパターンでの検証

## 2) 参照した情報（Evidence一覧）

- E-01: `extensions/extension-editing/src/extensionEditingMain.ts` - エントリーポイント
- E-02: `extensions/extension-editing/src/extensionLinter.ts` - リンティングロジック
- E-03: `extensions/extension-editing/package.json` - マニフェスト
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | onLanguage:json/markdownでアクティベート | E-03 (12-14行目) | ○ |
| C-02 | PackageDocumentHelperで補完 | E-01 (21-26行目) | ○ |
| C-03 | ExtensionLinterでリンティング | E-01 (18行目), E-02 | ○ |
| C-04 | 300msデバウンス | E-02 (106-109行目) | ○ |
| C-05 | アイコンURL検証 | E-02 (132-135行目) | ○ |
| C-06 | バッジURL検証 | E-02 (137-142行目) | ○ |
| C-07 | enabledApiProposals検証 | E-02 (144-160行目) | ○ |
| C-08 | activationEvents検証 | E-02 (161-194行目) | ○ |
| C-09 | when句検証 | E-02 (203-270行目) | ○ |
| C-10 | HTTPS必須エラーメッセージ | E-02 (29行目) | ○ |
| C-11 | SVG無効エラーメッセージ | E-02 (30行目) | ○ |
| C-12 | 信頼されたSVGソース判定 | E-02 (25-27行目) | ○ |
| C-13 | スターアクティベーション警告 | E-02 (37行目, 182-192行目) | ○ |
| C-14 | 冗長アクティベーション警告 | E-02 (16行目, 167-171行目) | ○ |
| C-15 | README.md/CHANGELOG.md対象 | E-02 (94-100行目) | ○ |
| C-16 | markdown-itでパース | E-02 (291-294行目) | ○ |
| C-17 | parse5でHTML解析 | E-02 (340-368行目) | ○ |
| C-18 | ファイルウォッチャー設定 | E-02 (63行目) | ○ |
| C-19 | 暗黙的アクティベーション解析 | E-02 (500-597行目) | ○ |
| C-20 | engines.vsocdeで拡張機能判定 | E-02 (130-131行目, 395-396行目) | ○ |
| C-21 | 信頼されていないワークスペースサポート | E-03 (18-22行目) | ○ |
| C-22 | 仮想ワークスペースサポート | E-03 (18行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし - すべての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - リンティングロジックは明確
- 0: 低リスク - URL検証ロジック
- 1: 中リスク - product.jsonの許可リストへの依存

## 6) レビュアーチェックリスト（最小）

- [ ] 拡張機能のpackage.jsonでcontributes補完が動作することを確認
- [ ] README.mdでHTTP画像URLに警告が表示されることを確認
- [ ] enabledApiProposalsに許可されていないAPIを記載すると警告が出ることを確認
- [ ] "*"アクティベーションに情報レベルの診断が表示されることを確認
