---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-メディアプレビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **各メディア形式の実際表示**：表示品質の確認
  2. **ズーム機能の動作**：UI操作の確認
  3. **SVG切り替え機能**：モード切替の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `extensions/media-preview/src/extension.ts` - エントリーポイント
- E-02: `extensions/media-preview/src/imagePreview/index.ts` - 画像プレビューロジック
- E-03: `extensions/media-preview/package.json` - マニフェスト
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画像拡張子サポート (jpg, png, gif, svg等) | E-03 (51-54行目) | ○ |
| C-02 | 音声拡張子サポート (mp3, wav, ogg) | E-03 (62-65行目) | ○ |
| C-03 | 動画拡張子サポート (mp4, webm) | E-03 (73-75行目) | ○ |
| C-04 | ImagePreviewManager.viewType | E-02 (17行目) | ○ |
| C-05 | registerImagePreviewSupport関数 | E-01 (16行目), E-02 (244-281行目) | ○ |
| C-06 | registerAudioPreviewSupport関数 | E-01 (17行目) | ○ |
| C-07 | registerVideoPreviewSupport関数 | E-01 (18行目) | ○ |
| C-08 | BinarySizeStatusBarEntry | E-01 (13-14行目), E-02 | ○ |
| C-09 | SizeStatusBarEntry | E-02 (247-248行目) | ○ |
| C-10 | ZoomStatusBarEntry | E-02 (250-251行目) | ○ |
| C-11 | zoomIn/zoomOut関数 | E-02 (142-152行目) | ○ |
| C-12 | copyImage関数 | E-02 (154-159行目) | ○ |
| C-13 | SVG切り替えコマンド | E-03 (94-105行目), E-02 (271-278行目) | ○ |
| C-14 | video.autoPlay設定 | E-03 (34-37行目) | ○ |
| C-15 | video.loop設定 | E-03 (39-43行目) | ○ |
| C-16 | 信頼されていないワークスペースサポート | E-03 (25-27行目) | ○ |
| C-17 | 仮想ワークスペースサポート | E-03 (23行目) | ○ |
| C-18 | CSPでコンテンツ制限 | E-02 (204行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし - すべての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - カスタムエディタ定義は明確
- 0: 低リスク - ズーム機能の実装
- 0: 低リスク - ステータスバー表示

## 6) レビュアーチェックリスト（最小）

- [ ] PNG画像が正しくプレビュー表示されることを確認
- [ ] ズームイン/ズームアウトが動作することを確認
- [ ] SVGファイルでプレビュー/テキスト切替が動作することを確認
- [ ] 動画・音声ファイルが再生できることを確認
