---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-シンプルブラウザ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **ローカルホスト表示の動作**：各種localhost形式での動作確認
  2. **統合ブラウザ切り替え**：実験的機能の動作確認
  3. **パネル復元機能**：シリアライズ/デシリアライズの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `extensions/simple-browser/src/extension.ts` - エントリーポイント
- E-02: `extensions/simple-browser/src/simpleBrowserManager.ts` - パネル管理
- E-03: `extensions/simple-browser/package.json` - マニフェスト
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | simpleBrowser.showコマンド | E-03 (38-43行目), E-01 (68行目) | ○ |
| C-02 | simpleBrowser.api.openコマンド | E-01 (15, 85行目) | ○ |
| C-03 | enabledHostsのローカルホスト一覧 | E-01 (20-32行目) | ○ |
| C-04 | SimpleBrowserManagerクラス | E-02 (9-48行目) | ○ |
| C-05 | パネル再利用ロジック | E-02 (24-31行目) | ○ |
| C-06 | WebviewPanelSerializer登録 | E-01 (62-66行目) | ○ |
| C-07 | ExternalUriOpener登録 | E-01 (96-120行目) | ○ |
| C-08 | Web環境でのデフォルト優先度 | E-01 (101-103行目) | ○ |
| C-09 | shouldUseIntegratedBrowser関数 | E-01 (39-48行目) | ○ |
| C-10 | useIntegratedBrowser設定 | E-03 (55-64行目), E-01 (18行目) | ○ |
| C-11 | focusLockIndicator.enabled設定 | E-03 (49-54行目) | ○ |
| C-12 | externalUriOpener API使用 | E-03 (5-7行目) | ○ |
| C-13 | restore()でパネル復元 | E-02 (34-39行目) | ○ |
| C-14 | InputBoxでURL入力 | E-01 (73-78行目) | ○ |
| C-15 | 信頼されていないワークスペースサポート | E-03 (33-35行目) | ○ |
| C-16 | 仮想ワークスペースサポート | E-03 (31行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし - すべての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - コマンド登録は明確
- 1: 中リスク - 提案API (externalUriOpener) の将来変更可能性
- 0: 低リスク - パネル管理ロジック

## 6) レビュアーチェックリスト（最小）

- [ ] simpleBrowser.showでURL入力ダイアログが表示されることを確認
- [ ] localhost:3000等のローカルURLが表示されることを確認
- [ ] パネル復元（VS Code再起動後）が動作することを確認
- [ ] 外部URLからシンプルブラウザで開くオプションが表示されることを確認
