---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：89-マージコンフリクト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **コンフリクト解決アクションの動作**：各アクションの結果確認
  2. **3ウェイマージ対応**：共通祖先マーカーの処理確認
  3. **autoNavigateNextConflict**：自動ナビゲーションの動作確認

## 2) 参照した情報（Evidence一覧）

- E-01: `extensions/merge-conflict/src/mergeConflictMain.ts` - エントリーポイント
- E-02: `extensions/merge-conflict/src/services.ts` - サービス管理
- E-03: `extensions/merge-conflict/src/mergeConflictParser.ts` - パーサー
- E-04: `extensions/merge-conflict/package.json` - マニフェスト
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンフリクトマーカー定義 | E-03 (10-13行目) | ○ |
| C-02 | MergeConflictParser.scanDocument | E-03 (24-86行目) | ○ |
| C-03 | ServiceWrapper.begin | E-02 (27-53行目) | ○ |
| C-04 | DocumentTracker | E-02 (30行目) | ○ |
| C-05 | CommandHandler | E-02 (34行目), E-04 (32-104行目) | ○ |
| C-06 | CodeLensProvider | E-02 (35行目) | ○ |
| C-07 | Decorator | E-02 (37行目) | ○ |
| C-08 | codeLens.enabled設定 | E-04 (135-139行目) | ○ |
| C-09 | decorators.enabled設定 | E-04 (140-144行目) | ○ |
| C-10 | autoNavigateNextConflict.enabled設定 | E-04 (145-149行目) | ○ |
| C-11 | diffViewPosition設定 | E-04 (150-164行目) | ○ |
| C-12 | accept.currentコマンド | E-04 (34-39行目) | ○ |
| C-13 | accept.incomingコマンド | E-04 (40-46行目) | ○ |
| C-14 | accept.bothコマンド | E-04 (47-53行目) | ○ |
| C-15 | next/previousコマンド | E-04 (83-96行目) | ○ |
| C-16 | compareコマンド | E-04 (97-104行目) | ○ |
| C-17 | containsConflict関数 | E-03 (145-152行目) | ○ |
| C-18 | commonAncestorsマーカー対応 | E-03 (11行目, 58-59行目) | ○ |
| C-19 | 信頼されていないワークスペースサポート | E-04 (18-20行目) | ○ |
| C-20 | 仮想ワークスペースサポート | E-04 (16-17行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし - すべての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - パーサーロジックは明確
- 0: 低リスク - コマンド定義
- 0: 低リスク - デコレーション処理

## 6) レビュアーチェックリスト（最小）

- [ ] コンフリクトマーカーがハイライト表示されることを確認
- [ ] CodeLensで「Accept Current」「Accept Incoming」「Accept Both」が表示されることを確認
- [ ] 各解決アクションが正しく動作することを確認
- [ ] 次/前のコンフリクトナビゲーションが動作することを確認
