---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：9-コードアクション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **LSP連携の詳細**：根拠不足
  2. **WorkspaceEdit適用の詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/editor/contrib/codeAction/browser/codeActionController.ts` - CodeActionController
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連情報
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CodeActionControllerがID 'editor.contrib.codeActionController'で登録 | E-01 (53行目) | ○ |
| C-02 | CodeActionModelで状態管理 | E-01 (60行目, 86行目) | ○ |
| C-03 | LightBulbWidgetで電球表示 | E-01 (62行目, 89-95行目) | ○ |
| C-04 | IActionShowOptionsでincludeDisabledActions等定義 | E-01 (43-46行目) | ○ |
| C-05 | showCodeActions()でアクションリスト表示 | E-01 (122-124行目) | ○ |
| C-06 | hideCodeActions()でアクション非表示 | E-01 (126-128行目) | ○ |
| C-07 | manualTriggerAtCurrentPosition()で手動トリガー | E-01 (130-143行目) | ○ |
| C-08 | CodeActionTriggerTypeでAuto/Invokeを区別 | E-01 (142行目) | ○ |
| C-09 | applyCodeAction()でアクション適用 | E-01 (149行目) | ○ |
| C-10 | プログレス表示500ms | E-01 (150行目) | ○ |
| C-11 | AIフィックスがある場合の特別処理 | E-01 (107-118行目) | ○ |
| C-12 | ActionWidgetServiceでメニュー表示 | E-01 (79行目, 99行目, 127行目) | ○ |
| C-13 | CodeActionKeybindingResolverでキーバインド解決 | E-01 (66行目, 97行目) | ○ |
| C-14 | テキストエディタが主画面として関連 | E-02 (37行目) | ○ |
| C-15 | 機能の備考にsrc/vs/editor/contrib/codeActionが記載 | E-03 (10行目) | ○ |
| C-16 | MessageController.closeMessage()でメッセージクローズ | E-01 (140行目) | ○ |
| C-17 | LSP連携の詳細 | **根拠なし** | △ |
| C-18 | WorkspaceEdit適用の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- LSP連携の詳細はLanguageServerクライアントで確認が必要
  - 候補：`src/vs/workbench/api`
- WorkspaceEdit適用の詳細はcodeAction.tsで確認が必要
  - 候補：`src/vs/editor/contrib/codeAction/browser/codeAction.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラ構造はコードと一致
- 0: 低リスク - メソッド定義はコードで確認可能
- 1: 中リスク - 外部連携の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CodeActionController.IDが正しく登録されているか確認
- [ ] CodeActionModelの状態遷移を確認
- [ ] LightBulbWidgetの表示条件を確認
- [ ] manualTriggerAtCurrentPosition()のトリガーロジックを確認
- [ ] applyCodeAction()のエラーハンドリングを確認
