---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-参照ビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **各種階層表示の動作**：Call Hierarchy、Type Hierarchyの動作確認
  2. **履歴機能**：検索履歴からの再実行確認
  3. **ナビゲーション**：F4/Shift+F4のナビゲーション確認

## 2) 参照した情報（Evidence一覧）

- E-01: `extensions/references-view/src/extension.ts` - エントリーポイント
- E-02: `extensions/references-view/src/tree.ts` - ツリー管理
- E-03: `extensions/references-view/package.json` - マニフェスト
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SymbolsTreeクラス | E-02 (13-130行目) | ○ |
| C-02 | references.register呼び出し | E-01 (17行目) | ○ |
| C-03 | calls.register呼び出し | E-01 (18行目) | ○ |
| C-04 | types.register呼び出し | E-01 (19行目) | ○ |
| C-05 | setInput/getInput関数 | E-01 (21-28行目) | ○ |
| C-06 | TreeView作成 | E-02 (30-37行目) | ○ |
| C-07 | setInput()でモデルセット | E-02 (49-117行目) | ○ |
| C-08 | clearInput()で結果クリア | E-02 (119-129行目) | ○ |
| C-09 | TreeInputHistoryクラス | E-02 (240-352行目) | ○ |
| C-10 | findReferencesコマンド | E-03 (68-72行目) | ○ |
| C-11 | findImplementationsコマンド | E-03 (73-77行目) | ○ |
| C-12 | showCallHierarchyコマンド | E-03 (124-128行目) | ○ |
| C-13 | showTypeHierarchyコマンド | E-03 (156-160行目) | ○ |
| C-14 | Shift+Alt+F12キーバインド | E-03 (375-379行目) | ○ |
| C-15 | Shift+Alt+Hキーバインド | E-03 (391-395行目) | ○ |
| C-16 | F4/Shift+F4ナビゲーション | E-03 (380-389行目) | ○ |
| C-17 | references.preferredLocation設定 | E-03 (33-46行目) | ○ |
| C-18 | viewsContainers定義 | E-03 (49-55行目) | ○ |
| C-19 | views定義 | E-03 (56-65行目) | ○ |
| C-20 | contextValue定義 | E-02, E-03 (menus設定) | ○ |
| C-21 | 信頼されていないワークスペースサポート | E-03 (14-16行目) | ○ |
| C-22 | 仮想ワークスペースサポート | E-03 (12-13行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし - すべての主張にソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - ツリー管理ロジックは明確
- 0: 低リスク - コマンド定義
- 0: 低リスク - 履歴管理

## 6) レビュアーチェックリスト（最小）

- [ ] Shift+Alt+F12で参照ビューに結果が表示されることを確認
- [ ] Call Hierarchyで呼び出し元/呼び出し先が表示されることを確認
- [ ] Type Hierarchyでスーパータイプ/サブタイプが表示されることを確認
- [ ] 履歴から再検索が実行できることを確認
