---
generated_at: 2026-01-27 12:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：93-Markdown数式

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（100ms以内）**：具体的な数値の根拠が不明

## 2) 参照した情報（Evidence一覧）

- E-01: `extensions/markdown-math/package.json` - 拡張機能マニフェスト
- E-02: `extensions/markdown-math/src/extension.ts` - メインソースコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | markdown.math.enabledでデフォルト有効 | E-01 (90-94行目), E-02 (12-15行目) | ○ |
| C-02 | markdown.math.macrosでカスタムマクロ定義 | E-01 (95-103行目), E-02 (17-20行目) | ○ |
| C-03 | @vscode/markdown-it-katexを使用 | E-02 (31行目), E-01 (122行目) | ○ |
| C-04 | 設定変更時にreloadPlugins | E-02 (22-26行目) | ○ |
| C-05 | extendMarkdownItでプラグイン登録 | E-02 (28-45行目) | ○ |
| C-06 | enableFencedBlocksオプション有効 | E-02 (34行目) | ○ |
| C-07 | globalGroupオプション有効 | E-02 (35行目) | ○ |
| C-08 | マクロリセットルール登録 | E-02 (38-40行目) | ○ |
| C-09 | インライン数式構文サポート | E-01 (49-59行目) | ○ |
| C-10 | ブロック数式構文サポート | E-01 (39-48行目) | ○ |
| C-11 | フェンスドブロック構文サポート | E-01 (60-69行目) | ○ |
| C-12 | Notebookレンダラー提供 | E-01 (71-80行目) | ○ |
| C-13 | プレビュースタイル提供 | E-01 (82-85行目) | ○ |
| C-14 | untrustedWorkspacesサポート | E-01 (17-22行目) | ○ |
| C-15 | レンダリング100ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値：コード上での明示的な定義なし
  - 候補：パフォーマンス仕様書 / KaTeXベンチマーク / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は明確でコード根拠も十分
- 0: 低リスク - KaTeXライブラリは成熟しており安定
- 1: 中リスク - 大量数式時のパフォーマンス検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件「100ms以内」の妥当性を確認
- [ ] 複雑なLaTeX構文（行列、分数等）のレンダリング確認
- [ ] カスタムマクロの適用範囲確認
- [ ] Notebookセルでの数式レンダリング確認
