---
generated_at: 2026-01-27 11:35:00
metrics:
  claims_total: 53
  claims_with_evidence: 50
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：50 / 53、根拠なし：3
- 優先レビュー（高）
  1. **No.50 ウェルカムバナー**：ディレクトリ存在は確認済みだが詳細実装未検証
  2. **No.52 プロセスエクスプローラー**：contribution.ts存在確認のみ
  3. **No.53 スプラッシュ画面**：ディレクトリ存在は確認済みだが詳細実装未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/browser/workbench.ts`
- E-02: `src/vs/workbench/browser/layout.ts`
- E-03: `src/vs/workbench/browser/parts/titlebar/`
- E-04: `src/vs/workbench/browser/parts/sidebar/sidebarPart.ts`
- E-05: `src/vs/workbench/browser/parts/auxiliarybar/auxiliaryBarPart.ts`
- E-06: `src/vs/workbench/browser/parts/panel/panelPart.ts`
- E-07: `src/vs/workbench/browser/parts/statusbar/statusbarPart.ts`
- E-08: `src/vs/workbench/browser/parts/activitybar/`
- E-09: `src/vs/workbench/browser/parts/banner/bannerPart.ts`
- E-10: `src/vs/workbench/browser/parts/editor/editorGroupView.ts`
- E-11: `src/vs/workbench/browser/parts/editor/editorPane.ts`
- E-12: `src/vs/workbench/browser/parts/editor/textEditor.ts`
- E-13: `src/vs/workbench/browser/parts/editor/textDiffEditor.ts`
- E-14: `src/vs/workbench/contrib/notebook/browser/notebookEditor.ts`
- E-15: `src/vs/workbench/contrib/preferences/browser/settingsEditor2.ts`
- E-16: `src/vs/workbench/contrib/preferences/browser/keybindingsEditor.ts`
- E-17: `src/vs/workbench/contrib/extensions/browser/extensionEditor.ts`
- E-18: `src/vs/workbench/contrib/welcomeGettingStarted/browser/gettingStarted.ts`
- E-19: `src/vs/workbench/contrib/update/browser/releaseNotesEditor.ts`
- E-20: `src/vs/workbench/contrib/userDataProfile/browser/userDataProfilesEditor.ts`
- E-21: `src/vs/workbench/contrib/files/browser/explorerViewlet.ts`
- E-22: `src/vs/workbench/contrib/search/browser/searchView.ts`
- E-23: `src/vs/workbench/contrib/scm/browser/scmViewPane.ts`
- E-24: `src/vs/workbench/contrib/debug/browser/debugViewlet.ts`
- E-25: `src/vs/workbench/contrib/extensions/browser/extensionsViewlet.ts`
- E-26: `src/vs/workbench/contrib/testing/browser/testingExplorerView.ts`
- E-27: `src/vs/workbench/contrib/timeline/browser/timelinePane.ts`
- E-28: `src/vs/workbench/contrib/outline/browser/outline.contribution.ts`
- E-29: `src/vs/workbench/contrib/terminal/browser/terminalView.ts`
- E-30: `src/vs/workbench/contrib/output/browser/outputView.ts`
- E-31: `src/vs/workbench/contrib/markers/browser/markersView.ts`
- E-32: `src/vs/workbench/contrib/debug/browser/repl.ts`
- E-33: `src/vs/workbench/contrib/comments/browser/commentsView.ts`
- E-34: `src/vs/workbench/contrib/testing/browser/testResultsView/`
- E-35: `src/vs/workbench/contrib/debug/browser/variablesView.ts`
- E-36: `src/vs/workbench/contrib/debug/browser/watchExpressionsView.ts`
- E-37: `src/vs/workbench/contrib/debug/browser/callStackView.ts`
- E-38: `src/vs/workbench/contrib/debug/browser/breakpointsView.ts`
- E-39: `src/vs/workbench/contrib/debug/browser/loadedScriptsView.ts`
- E-40: `src/vs/workbench/contrib/debug/browser/debugToolBar.ts`
- E-41: `src/vs/workbench/contrib/debug/browser/disassemblyView.ts`
- E-42: `src/vs/workbench/contrib/scm/browser/scmRepositoriesViewPane.ts`
- E-43: `src/vs/workbench/contrib/scm/browser/scmHistoryViewPane.ts`
- E-44: `src/vs/workbench/contrib/chat/browser/`
- E-45: `src/vs/workbench/contrib/inlineChat/browser/inlineChat.contribution.ts`
- E-46: `src/vs/workbench/browser/parts/notifications/`
- E-47: `src/vs/workbench/browser/parts/dialogs/`
- E-48: `src/vs/workbench/browser/quickaccess.ts`
- E-49: `src/vs/workbench/contrib/quickaccess/browser/quickAccess.contribution.ts`
- E-50: `src/vs/workbench/contrib/search/browser/symbolsQuickAccess.ts`
- E-51: `src/vs/workbench/workbench.common.main.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ワークベンチ：VSCodeのメインワークベンチ画面 | E-01, E-02 | ○ |
| C-02 | タイトルバー：アプリケーションのタイトルバー | E-03 | ○ |
| C-03 | サイドバー：左側のサイドバーパネル | E-04 | ○ |
| C-04 | 補助サイドバー：右側の補助サイドバー | E-05 | ○ |
| C-05 | パネル：下部パネル | E-06 | ○ |
| C-06 | ステータスバー：ウィンドウ下部のステータスバー | E-07 | ○ |
| C-07 | アクティビティバー：サイドバーのビュー切り替えアイコン | E-08 | ○ |
| C-08 | バナー：ワークベンチ上部の情報バナー | E-09 | ○ |
| C-09 | エディタグループ：エディタタブグループ | E-10 | ○ |
| C-10 | エディタペイン：個々のエディタコンテンツを表示 | E-11 | ○ |
| C-11 | テキストエディタ：標準テキストファイルエディタ | E-12 | ○ |
| C-12 | 差分エディタ：2ファイルの差分を表示 | E-13 | ○ |
| C-13 | ノートブックエディタ：Jupyter Notebook形式 | E-14 | ○ |
| C-14 | 設定エディタ：GUI形式の設定画面 | E-15 | ○ |
| C-15 | キーバインド設定エディタ：キーボードショートカット設定 | E-16 | ○ |
| C-16 | 拡張機能エディタ：拡張機能の詳細情報表示 | E-17 | ○ |
| C-17 | ウェルカムエディタ：Getting Started画面 | E-18 | ○ |
| C-18 | リリースノートエディタ：リリースノート表示 | E-19 | ○ |
| C-19 | プロファイルエディタ：ユーザープロファイル管理 | E-20 | ○ |
| C-20 | エクスプローラービュー：ファイルエクスプローラー | E-21 | ○ |
| C-21 | 検索ビュー：ワークスペース全体のテキスト検索 | E-22 | ○ |
| C-22 | ソース管理ビュー：Git等のソース管理 | E-23 | ○ |
| C-23 | 実行とデバッグビュー：デバッグセッション管理 | E-24 | ○ |
| C-24 | 拡張機能ビュー：拡張機能の検索・インストール | E-25 | ○ |
| C-25 | テストビュー：テストエクスプローラー | E-26 | ○ |
| C-26 | タイムラインビュー：ファイルの履歴タイムライン | E-27 | ○ |
| C-27 | アウトラインビュー：ファイル構造のアウトライン | E-28 | ○ |
| C-28 | ターミナルビュー：統合ターミナル | E-29 | ○ |
| C-29 | 出力ビュー：拡張機能やビルドの出力ログ | E-30 | ○ |
| C-30 | 問題ビュー：コードの問題一覧 | E-31 | ○ |
| C-31 | デバッグコンソール：デバッグ時のREPL | E-32 | ○ |
| C-32 | コメントビュー：コードコメントの一覧 | E-33 | ○ |
| C-33 | テスト結果ビュー：テスト実行結果の詳細 | E-34 | ○ |
| C-34 | 変数ビュー：デバッグ時の変数値表示 | E-35 | ○ |
| C-35 | ウォッチ式ビュー：監視式の登録・評価 | E-36 | ○ |
| C-36 | コールスタックビュー：コールスタックとスレッド | E-37 | ○ |
| C-37 | ブレークポイントビュー：ブレークポイント一覧管理 | E-38 | ○ |
| C-38 | ロードされたスクリプトビュー：ロードされたスクリプト一覧 | E-39 | ○ |
| C-39 | デバッグツールバー：デバッグ操作用フローティングツールバー | E-40 | ○ |
| C-40 | 逆アセンブリビュー：低レベルデバッグ用 | E-41 | ○ |
| C-41 | SCMリポジトリビュー：複数リポジトリ管理 | E-42 | ○ |
| C-42 | SCM履歴ビュー：Gitコミット履歴 | E-43 | ○ |
| C-43 | チャットビュー：AIチャット機能 | E-44 | ○ |
| C-44 | インラインチャット：エディタ内でのAIチャット | E-45 | ○ |
| C-45 | 通知センター：通知メッセージの表示領域 | E-46 | ○ |
| C-46 | ダイアログ：モーダルダイアログ | E-47 | ○ |
| C-47 | コマンドパレット：コマンドの検索・実行 | E-48 | ○ |
| C-48 | クイックオープン：ファイルの素早い検索 | E-49 | ○ |
| C-49 | シンボル検索：ワークスペース内シンボルの検索 | E-50 | ○ |
| C-50 | ウェルカムバナー：エディタ領域のウェルカムバナー | **根拠不足** | △ |
| C-51 | ウォークスルー：インタラクティブチュートリアル | E-51（contribution参照のみ） | ○ |
| C-52 | プロセスエクスプローラー：VSCodeプロセスのリソース使用状況 | **根拠不足** | △ |
| C-53 | スプラッシュ画面：起動時のスプラッシュスクリーン | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **ウェルカムバナー (No.50)**：`src/vs/workbench/contrib/welcomeBanner/` ディレクトリは存在するが、詳細な画面実装の検証が不十分
  - 候補：welcomeBanner.ts / welcomeBanner.contribution.ts を確認
- **プロセスエクスプローラー (No.52)**：別ウィンドウで表示される画面のため、通常のワークベンチ構造とは異なる実装
  - 候補：Electron main process側の実装を確認
- **スプラッシュ画面 (No.53)**：`src/vs/workbench/contrib/splash/browser/` ディレクトリは存在するが、詳細実装の検証が不十分
  - 候補：splash.ts / splash.contribution.ts を確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：メインレイアウト (No.1-8) - 主要ファイルが明確に特定され、実装が確認済み
- **0（低リスク）**：エディタビュー (No.9-19) - TypeScriptファイルが存在し、クラス定義が確認可能
- **0（低リスク）**：サイドバービュー (No.20-27) - contribution.tsとView実装が対応
- **0（低リスク）**：パネルビュー (No.28-33) - View実装ファイルが存在
- **0（低リスク）**：デバッグビュー (No.34-40) - debugディレクトリ内に全View実装が存在
- **0（低リスク）**：Git/SCM (No.41-42) - scmディレクトリ内にViewPane実装が存在
- **0（低リスク）**：AI/チャット (No.43-44) - chatディレクトリとinlineChatが存在
- **0（低リスク）**：通知/ダイアログ (No.45-46) - partsディレクトリ内に実装存在
- **0（低リスク）**：クイック入力 (No.47-49) - quickaccess関連ファイルが存在
- **1（中リスク）**：その他 (No.50-53) - 一部ファイルの詳細検証が不十分

## 6) レビュアーチェックリスト（最小）
- [ ] メインレイアウト構成（タイトルバー、サイドバー、パネル、ステータスバー）が正しく識別されているか
- [ ] エディタ種別（テキスト、差分、ノートブック、設定等）が網羅されているか
- [ ] サイドバービュー（エクスプローラー、検索、Git、デバッグ、拡張機能）が正確か
- [ ] パネルビュー（ターミナル、出力、問題、デバッグコンソール）が正確か
- [ ] デバッグ関連ビュー（変数、ウォッチ、コールスタック、ブレークポイント）が網羅されているか
- [ ] 画面遷移図のフローが実際の操作と一致しているか
- [ ] テンプレートファイルパスが実際のプロジェクト構造と一致しているか
- [ ] 根拠不足（△）の項目について追加検証が必要か判断
