# VSCode 画面遷移図

## 概要

Visual Studio Codeのメイン画面構成と画面間の遷移関係を示します。

## メインレイアウト構成

```mermaid
graph TB
    subgraph Workbench["ワークベンチ (Workbench)"]
        TitleBar["タイトルバー"]
        Banner["バナー"]

        subgraph MainArea["メインエリア"]
            ActivityBar["アクティビティバー"]
            Sidebar["サイドバー"]
            EditorArea["エディタエリア"]
            AuxiliaryBar["補助サイドバー"]
        end

        Panel["パネル"]
        StatusBar["ステータスバー"]
    end

    TitleBar --> Banner
    Banner --> MainArea
    MainArea --> Panel
    Panel --> StatusBar
```

## 画面遷移図（全体）

```mermaid
flowchart TB
    subgraph Layout["メインレイアウト"]
        Workbench["ワークベンチ"]
        TitleBar["タイトルバー"]
        StatusBar["ステータスバー"]
        ActivityBar["アクティビティバー"]
    end

    subgraph Sidebar["サイドバービュー"]
        Explorer["エクスプローラー"]
        Search["検索"]
        SCM["ソース管理"]
        Debug["実行とデバッグ"]
        Extensions["拡張機能"]
        Testing["テスト"]
    end

    subgraph EditorViews["エディタビュー"]
        TextEditor["テキストエディタ"]
        DiffEditor["差分エディタ"]
        NotebookEditor["ノートブックエディタ"]
        SettingsEditor["設定エディタ"]
        KeybindingsEditor["キーバインドエディタ"]
        ExtensionEditor["拡張機能エディタ"]
        WelcomeEditor["ウェルカムエディタ"]
        ProfileEditor["プロファイルエディタ"]
    end

    subgraph PanelViews["パネルビュー"]
        Terminal["ターミナル"]
        Output["出力"]
        Problems["問題"]
        DebugConsole["デバッグコンソール"]
        Comments["コメント"]
    end

    subgraph QuickInput["クイック入力"]
        CommandPalette["コマンドパレット"]
        QuickOpen["クイックオープン"]
        SymbolSearch["シンボル検索"]
    end

    subgraph Chat["AI/チャット"]
        ChatView["チャットビュー"]
        InlineChat["インラインチャット"]
    end

    %% Activity Bar -> Sidebar transitions
    ActivityBar -->|"クリック"| Explorer
    ActivityBar -->|"クリック"| Search
    ActivityBar -->|"クリック"| SCM
    ActivityBar -->|"クリック"| Debug
    ActivityBar -->|"クリック"| Extensions
    ActivityBar -->|"クリック"| Testing
    ActivityBar -->|"クリック"| ChatView

    %% Explorer -> Editor transitions
    Explorer -->|"ファイル選択"| TextEditor
    Explorer -->|"ファイル比較"| DiffEditor

    %% Search transitions
    Search -->|"結果選択"| TextEditor

    %% SCM transitions
    SCM -->|"ファイル選択"| DiffEditor
    SCM -->|"コミット履歴"| TextEditor

    %% Debug transitions
    Debug -->|"デバッグ開始"| DebugConsole
    Debug -->|"ブレークポイント"| TextEditor

    %% Extensions transitions
    Extensions -->|"拡張機能選択"| ExtensionEditor

    %% Panel access
    Workbench -->|"Ctrl+`"| Terminal
    Workbench -->|"Ctrl+Shift+U"| Output
    Workbench -->|"Ctrl+Shift+M"| Problems

    %% Quick Input
    Workbench -->|"Ctrl+Shift+P"| CommandPalette
    Workbench -->|"Ctrl+P"| QuickOpen
    Workbench -->|"Ctrl+T"| SymbolSearch

    %% Command Palette transitions
    CommandPalette -->|"設定を開く"| SettingsEditor
    CommandPalette -->|"キーバインドを開く"| KeybindingsEditor
    CommandPalette -->|"ようこそ"| WelcomeEditor
    CommandPalette -->|"プロファイル"| ProfileEditor

    %% Quick Open transitions
    QuickOpen -->|"ファイル選択"| TextEditor
    SymbolSearch -->|"シンボル選択"| TextEditor

    %% Settings transitions
    SettingsEditor -->|"JSON編集"| TextEditor

    %% Chat transitions
    ChatView -->|"コード挿入"| TextEditor
    InlineChat -->|"インライン生成"| TextEditor
    TextEditor -->|"Ctrl+I"| InlineChat
```

## サイドバー詳細遷移

```mermaid
flowchart LR
    subgraph ActivityBar["アクティビティバー"]
        ExplorerIcon["エクスプローラーアイコン"]
        SearchIcon["検索アイコン"]
        SCMIcon["ソース管理アイコン"]
        DebugIcon["デバッグアイコン"]
        ExtIcon["拡張機能アイコン"]
        TestIcon["テストアイコン"]
    end

    subgraph Sidebar["サイドバー"]
        ExplorerView["エクスプローラービュー"]
        SearchView["検索ビュー"]
        SCMView["ソース管理ビュー"]
        DebugView["デバッグビュー"]
        ExtView["拡張機能ビュー"]
        TestView["テストビュー"]
    end

    subgraph ExplorerContent["エクスプローラー内容"]
        FileTree["ファイルツリー"]
        OpenEditors["開いているエディタ"]
        Timeline["タイムライン"]
        Outline["アウトライン"]
    end

    subgraph DebugContent["デバッグ内容"]
        Variables["変数"]
        Watch["ウォッチ"]
        CallStack["コールスタック"]
        Breakpoints["ブレークポイント"]
    end

    ExplorerIcon --> ExplorerView
    SearchIcon --> SearchView
    SCMIcon --> SCMView
    DebugIcon --> DebugView
    ExtIcon --> ExtView
    TestIcon --> TestView

    ExplorerView --> FileTree
    ExplorerView --> OpenEditors
    ExplorerView --> Timeline
    ExplorerView --> Outline

    DebugView --> Variables
    DebugView --> Watch
    DebugView --> CallStack
    DebugView --> Breakpoints
```

## エディタ遷移

```mermaid
flowchart TB
    subgraph EditorGroup["エディタグループ"]
        Tab1["タブ1"]
        Tab2["タブ2"]
        Tab3["タブ3"]
    end

    subgraph EditorTypes["エディタ種別"]
        TextEditor["テキストエディタ"]
        DiffEditor["差分エディタ"]
        NotebookEditor["ノートブックエディタ"]
        SettingsEditor["設定エディタ"]
        CustomEditor["カスタムエディタ"]
    end

    subgraph EditorFeatures["エディタ機能"]
        Breadcrumbs["パンくずリスト"]
        Minimap["ミニマップ"]
        LineNumbers["行番号"]
        IntelliSense["IntelliSense"]
    end

    Tab1 -->|"選択"| TextEditor
    Tab2 -->|"選択"| DiffEditor
    Tab3 -->|"選択"| NotebookEditor

    TextEditor --> Breadcrumbs
    TextEditor --> Minimap
    TextEditor --> LineNumbers
    TextEditor --> IntelliSense

    TextEditor -->|"右クリック→比較"| DiffEditor
    TextEditor -->|"F12"| TextEditor
    TextEditor -->|"Ctrl+クリック"| TextEditor
```

## パネル遷移

```mermaid
flowchart LR
    subgraph PanelTabs["パネルタブ"]
        TerminalTab["ターミナル"]
        OutputTab["出力"]
        ProblemsTab["問題"]
        DebugConsoleTab["デバッグコンソール"]
        CommentsTab["コメント"]
    end

    subgraph TerminalContent["ターミナル内容"]
        TerminalInstance["ターミナルインスタンス"]
        TerminalTabs["ターミナルタブ"]
        TerminalSplit["分割ターミナル"]
    end

    subgraph OutputContent["出力内容"]
        OutputChannel["出力チャンネル"]
        OutputFilter["フィルタ"]
    end

    subgraph ProblemsContent["問題内容"]
        Errors["エラー"]
        Warnings["警告"]
        Info["情報"]
    end

    TerminalTab --> TerminalInstance
    TerminalTab --> TerminalTabs
    TerminalTab --> TerminalSplit

    OutputTab --> OutputChannel
    OutputTab --> OutputFilter

    ProblemsTab --> Errors
    ProblemsTab --> Warnings
    ProblemsTab --> Info

    Errors -->|"クリック"| TextEditor["テキストエディタ"]
    Warnings -->|"クリック"| TextEditor
```

## デバッグフロー

```mermaid
flowchart TB
    Start["デバッグ開始"] --> DebugSession["デバッグセッション"]

    DebugSession --> DebugToolbar["デバッグツールバー"]
    DebugSession --> DebugViews["デバッグビュー"]

    subgraph DebugViews["デバッグビュー"]
        Variables["変数ビュー"]
        Watch["ウォッチビュー"]
        CallStack["コールスタックビュー"]
        Breakpoints["ブレークポイントビュー"]
        LoadedScripts["ロードされたスクリプト"]
    end

    subgraph DebugToolbar["ツールバー操作"]
        Continue["続行"]
        StepOver["ステップオーバー"]
        StepInto["ステップイン"]
        StepOut["ステップアウト"]
        Restart["再起動"]
        Stop["停止"]
    end

    DebugSession --> DebugConsole["デバッグコンソール"]
    DebugSession --> Editor["エディタ（ブレークポイント表示）"]

    Continue --> DebugSession
    StepOver --> DebugSession
    StepInto --> DebugSession
    StepOut --> DebugSession
    Restart --> Start
    Stop --> End["デバッグ終了"]
```

## クイック入力フロー

```mermaid
flowchart TB
    subgraph Triggers["トリガー"]
        CmdP["Ctrl+P"]
        CmdShiftP["Ctrl+Shift+P"]
        CmdT["Ctrl+T"]
        CmdG["Ctrl+G"]
    end

    subgraph QuickInput["クイック入力"]
        QuickOpen["クイックオープン"]
        CommandPalette["コマンドパレット"]
        SymbolSearch["シンボル検索"]
        GoToLine["行へ移動"]
    end

    subgraph Results["結果アクション"]
        OpenFile["ファイルを開く"]
        ExecuteCommand["コマンド実行"]
        GoToSymbol["シンボルへ移動"]
        JumpToLine["行へジャンプ"]
    end

    CmdP --> QuickOpen
    CmdShiftP --> CommandPalette
    CmdT --> SymbolSearch
    CmdG --> GoToLine

    QuickOpen -->|"ファイル選択"| OpenFile
    QuickOpen -->|">入力"| CommandPalette
    QuickOpen -->|"@入力"| SymbolSearch
    QuickOpen -->|":入力"| GoToLine

    CommandPalette -->|"コマンド選択"| ExecuteCommand
    SymbolSearch -->|"シンボル選択"| GoToSymbol
    GoToLine -->|"行番号入力"| JumpToLine

    OpenFile --> TextEditor["テキストエディタ"]
    GoToSymbol --> TextEditor
    JumpToLine --> TextEditor
```

## 設定画面フロー

```mermaid
flowchart TB
    subgraph Access["アクセス方法"]
        CmdComma["Ctrl+,"]
        FileMenu["ファイル→基本設定→設定"]
        CommandPalette["コマンドパレット"]
    end

    subgraph SettingsEditor["設定エディタ"]
        SearchSettings["設定検索"]
        Categories["カテゴリ"]
        SettingsList["設定一覧"]
    end

    subgraph SettingsTypes["設定種別"]
        UserSettings["ユーザー設定"]
        WorkspaceSettings["ワークスペース設定"]
        FolderSettings["フォルダ設定"]
    end

    subgraph JSONEdit["JSON編集"]
        SettingsJSON["settings.json"]
    end

    CmdComma --> SettingsEditor
    FileMenu --> SettingsEditor
    CommandPalette -->|"設定を開く"| SettingsEditor

    SettingsEditor --> SearchSettings
    SettingsEditor --> Categories
    Categories --> SettingsList

    SettingsEditor -->|"タブ切り替え"| UserSettings
    SettingsEditor -->|"タブ切り替え"| WorkspaceSettings
    SettingsEditor -->|"タブ切り替え"| FolderSettings

    SettingsEditor -->|"JSONで編集"| SettingsJSON
    SettingsJSON -->|"GUI表示"| SettingsEditor
```
