---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 95
  claims_with_evidence: 89
  claims_without_evidence: 6
confidence_derived: 0.94
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された画面機能マッピングの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：89 / 95、根拠なし：6
- 優先レビュー（高）
  1. **バナー画面と通知機能のマッピング**：banner.contribution.ts の詳細実装確認が必要
  2. **ウェルカムバナーと通知機能のマッピング**：welcomeBanner ディレクトリの実装確認が必要
  3. **スプラッシュ画面とウィンドウ管理機能のマッピング**：splash ディレクトリの実装確認が必要
  4. **プロセスエクスプローラーとプロセス機能のマッピング**：別ウィンドウでの実装のため詳細確認が必要
  5. **ウォークスルーとエクスプローラー機能のマッピング**：遷移先の動作確認が必要
  6. **リリースノートエディタと更新管理機能のマッピング**：更新サービスとの連携確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `src/vs/workbench/browser/workbench.ts`
- E-04: `src/vs/workbench/contrib/files/browser/explorerViewlet.ts`
- E-05: `src/vs/workbench/contrib/debug/browser/debugViewlet.ts`
- E-06: `src/vs/workbench/contrib/terminal/browser/terminalView.ts`
- E-07: `src/vs/workbench/contrib/extensions/browser/extensionsViewlet.ts`
- E-08: `src/vs/workbench/contrib/search/browser/searchView.ts`
- E-09: `src/vs/workbench/contrib/scm/browser/scmViewPane.ts`
- E-10: `src/vs/workbench/contrib/preferences/browser/settingsEditor2.ts`
- E-11: `src/vs/workbench/contrib/preferences/browser/keybindingsEditor.ts`
- E-12: `src/vs/workbench/contrib/notebook/browser/notebookEditor.ts`
- E-13: `src/vs/workbench/contrib/testing/browser/testingExplorerView.ts`
- E-14: `src/vs/workbench/contrib/timeline/browser/timelinePane.ts`
- E-15: `src/vs/workbench/contrib/outline/browser/outline.contribution.ts`
- E-16: `src/vs/workbench/contrib/output/browser/outputView.ts`
- E-17: `src/vs/workbench/contrib/markers/browser/markersView.ts`
- E-18: `src/vs/workbench/contrib/debug/browser/repl.ts`
- E-19: `src/vs/workbench/contrib/comments/browser/commentsView.ts`
- E-20: `src/vs/workbench/contrib/chat/browser/`
- E-21: `src/vs/workbench/contrib/inlineChat/browser/inlineChat.contribution.ts`
- E-22: `src/vs/workbench/browser/parts/notifications/`
- E-23: `src/vs/workbench/browser/parts/dialogs/`
- E-24: `src/vs/workbench/browser/quickaccess.ts`
- E-25: `src/vs/workbench/contrib/quickaccess/browser/quickAccess.contribution.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ワークベンチ画面は設定管理機能を使用 | E-03 (configurationService参照) | ○ |
| C-02 | ワークベンチ画面はウィンドウ管理機能を使用 | E-03 (Layout継承, IWorkbenchLayoutService) | ○ |
| C-03 | ワークベンチ画面は通知機能を使用 | E-03 (NotificationsCenter, NotificationsToasts) | ○ |
| C-04 | ワークベンチ画面はストレージ機能を使用 | E-03 (storageService, storeFontInfo) | ○ |
| C-05 | サイドバーはエクスプローラー機能と連動 | E-04 (ExplorerViewPaneContainer) | ○ |
| C-06 | サイドバーは検索機能と連動 | E-08 (searchView.ts) | ○ |
| C-07 | サイドバーはソース管理機能と連動 | E-09 (scmViewPane.ts) | ○ |
| C-08 | サイドバーはデバッグ機能と連動 | E-05 (DebugViewPaneContainer) | ○ |
| C-09 | サイドバーは拡張機能と連動 | E-07 (ExtensionsViewPaneContainer) | ○ |
| C-10 | エクスプローラービューはファイルシステムAPI使用 | E-04 (IWorkspaceContextService) | ○ |
| C-11 | デバッグビューはデバッグサービス使用 | E-05 (IDebugService) | ○ |
| C-12 | ターミナルビューはターミナルサービス使用 | E-06 (ITerminalService, ITerminalGroupService) | ○ |
| C-13 | 拡張機能ビューはExtensionsWorkbenchService使用 | E-07 (IExtensionsWorkbenchService) | ○ |
| C-14 | テキストエディタはコード編集機能を使用 | E-02 (機能一覧No.1) | ○ |
| C-15 | テキストエディタはシンタックスハイライト使用 | E-02 (機能一覧No.2) | ○ |
| C-16 | テキストエディタはIntelliSense使用 | E-02 (機能一覧No.3) | ○ |
| C-17 | 設定エディタは設定管理機能使用 | E-10 (settingsEditor2.ts) | ○ |
| C-18 | キーバインド設定はキーバインディング機能使用 | E-11 (keybindingsEditor.ts) | ○ |
| C-19 | ノートブックエディタはノートブック機能使用 | E-12 (notebookEditor.ts) | ○ |
| C-20 | テストビューはテスト機能使用 | E-13 (testingExplorerView.ts) | ○ |
| C-21 | タイムラインビューはタイムライン機能使用 | E-14 (timelinePane.ts) | ○ |
| C-22 | アウトラインビューはアウトライン機能使用 | E-15 (outline.contribution.ts) | ○ |
| C-23 | 出力ビューは出力パネル機能使用 | E-16 (outputView.ts) | ○ |
| C-24 | 問題ビューは問題パネル機能使用 | E-17 (markersView.ts) | ○ |
| C-25 | デバッグコンソールはデバッグ機能使用 | E-18 (repl.ts) | ○ |
| C-26 | コメントビューはコメント機能使用 | E-19 (commentsView.ts) | ○ |
| C-27 | チャットビューはチャット機能使用 | E-20 (chatディレクトリ) | ○ |
| C-28 | インラインチャットはインラインチャット機能使用 | E-21 (inlineChat.contribution.ts) | ○ |
| C-29 | 通知センターは通知機能使用 | E-22 (notificationsディレクトリ) | ○ |
| C-30 | ダイアログはダイアログ機能使用 | E-23 (dialogsディレクトリ) | ○ |
| C-31 | コマンドパレットはクイック入力機能使用 | E-24 (quickaccess.ts) | ○ |
| C-32 | クイックオープンはクイック入力機能使用 | E-25 (quickAccess.contribution.ts) | ○ |
| C-33 | バナー画面は通知機能使用 | **根拠不足** | △ |
| C-34 | ウェルカムバナーは通知機能使用 | **根拠不足** | △ |
| C-35 | スプラッシュ画面はウィンドウ管理機能使用 | **根拠不足** | △ |
| C-36 | プロセスエクスプローラーはプロセス機能使用 | **根拠不足** | △ |
| C-37 | ウォークスルーはエクスプローラーへの遷移機能 | **根拠不足** | △ |
| C-38 | リリースノートエディタは更新管理機能使用 | **根拠不足** | △ |

※ 残りの57件のClaimは全て根拠あり（○）

## 4) 不足情報（Unknown / Missing）
- バナー、ウェルカムバナー、スプラッシュ画面の実装詳細が未確認
  - 候補：`src/vs/workbench/contrib/welcomeBanner/` / `src/vs/workbench/contrib/splash/browser/` / `src/vs/workbench/browser/parts/banner/`
- プロセスエクスプローラーは別ウィンドウで動作するため、メインプロセスとの連携確認が必要
  - 候補：`src/vs/workbench/contrib/processExplorer/browser/`
- ウォークスルーからの画面遷移フローの詳細確認が必要
  - 候補：`src/vs/workbench/contrib/welcomeWalkthrough/browser/`
- リリースノートエディタと更新サービスの連携確認が必要
  - 候補：`src/vs/workbench/contrib/update/browser/releaseNotesEditor.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のマッピングはソースコード解析により確認済み
- 1: 中リスク - 画面一覧.csv と機能一覧.csv の整合性に依存
- 1: 中リスク - 一部の補助機能・遷移先機能のマッピングは推測を含む
- 2: 高リスク - バナー系画面、スプラッシュ画面のマッピングは実装確認が不十分

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧.csv の全画面No（1-53）がマッピングに含まれているか確認
- [ ] 機能一覧.csv の主要機能（1-66）がマッピングに含まれているか確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か確認
- [ ] △ 印の6件について、ソースコードを確認して根拠を補強
- [ ] 1つの画面に複数機能がマッピングされている場合の優先度（主機能vs補助機能）が適切か確認
