# 画面設計書: ワークベンチ

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 1 |
| 画面名 | ワークベンチ |
| 画面パス | `src/vs/workbench/browser/workbench.ts` |
| 概要 | VS Codeのメインウィンドウを構成するルートコンテナ。全てのUI部品（タイトルバー、サイドバー、エディタ、パネル等）を統合管理する中核画面 |

## 2. 画面構成

### 2.1 レイアウト概要

```
+------------------------------------------------------------------+
|                        タイトルバー                               |
+------------------------------------------------------------------+
|                          バナー                                   |
+--------+------------------------------------------+---------------+
|        |                                          |               |
|アクティ|              エディタグループ             |   補助        |
|ビティ  |                                          |   サイドバー  |
|バー    +------------------------------------------+               |
|        |              パネル                      |               |
|サイド  |                                          |               |
|バー    |                                          |               |
+--------+------------------------------------------+---------------+
|                        ステータスバー                             |
+------------------------------------------------------------------+
```

### 2.2 構成要素

| 要素名 | 説明 | 必須 | 可視性 |
|--------|------|------|--------|
| タイトルバー | ウィンドウタイトル、メニュー、ウィンドウ制御 | はい | 設定により表示/非表示 |
| バナー | 通知バナー表示エリア | いいえ | 条件付き表示 |
| アクティビティバー | ビューコンテナ切り替えアイコン | はい | 設定により表示/非表示 |
| サイドバー | エクスプローラ等のビュー表示 | はい | 設定により表示/非表示 |
| エディタグループ | ファイル編集エリア | はい | 常時表示 |
| パネル | ターミナル、出力等の補助機能 | はい | 設定により表示/非表示 |
| 補助サイドバー | 追加のビュー表示エリア | いいえ | 設定により表示/非表示 |
| ステータスバー | 状態表示、クイック操作 | はい | 設定により表示/非表示 |

## 3. 機能仕様

### 3.1 レイアウト管理

- **SerializableGrid**: 各パーツを配置するグリッドシステム
- **パーツの表示/非表示制御**: 各パーツの可視性を動的に切り替え
- **サイズ変更**: ドラッグによるパーツサイズの変更（Sash使用）
- **レイアウト状態の永続化**: ワークスペースごとにレイアウトを保存

### 3.2 ウィンドウ制御

- **フルスクリーンモード**: 全画面表示の切り替え
- **最大化/復元**: ウィンドウの最大化と復元
- **Zenモード**: 集中モードによる簡素化表示
- **マルチウィンドウ対応**: 補助ウィンドウの管理

### 3.3 状態管理

| 状態 | 説明 | 保存先 |
|------|------|--------|
| レイアウト状態 | パーツの表示/非表示、サイズ | StorageService |
| ビューコンテナ状態 | どのビューが表示されているか | StorageService |
| Zenモード状態 | Zenモードの有効/無効 | ランタイム |
| フルスクリーン状態 | フルスクリーンの有効/無効 | ランタイム |

## 4. データフロー

```
[ConfigurationService] --> [Layout State Model] --> [Workbench Grid]
                                                          |
                                                          v
                                                    [各 Part]
                                                          |
                                                          v
                                                    [DOM 更新]
```

## 5. イベント

| イベント名 | トリガー | 処理内容 |
|------------|----------|----------|
| onDidChangeZenMode | Zenモード切り替え | UI簡素化の適用/解除 |
| onDidChangePartVisibility | パーツ表示変更 | グリッドの再レイアウト |
| onDidLayoutMainContainer | メインコンテナサイズ変更 | 子パーツへのサイズ伝播 |
| onDidChangeWindowMaximized | ウィンドウ最大化変更 | 最大化状態の更新 |
| onDidChangePanelPosition | パネル位置変更 | パネルの配置更新 |

## 6. 関連設定

| 設定キー | 説明 | デフォルト値 |
|----------|------|--------------|
| `workbench.activityBar.location` | アクティビティバーの位置 | `default` |
| `workbench.sideBar.location` | サイドバーの位置 | `left` |
| `workbench.panel.defaultLocation` | パネルのデフォルト位置 | `bottom` |
| `workbench.statusBar.visible` | ステータスバーの表示 | `true` |
| `window.titleBarStyle` | タイトルバーのスタイル | プラットフォーム依存 |

## 7. コードリーディングガイド

### 7.1 読解の流れ

1. **エントリーポイント**: `src/vs/workbench/browser/workbench.ts` の `Workbench` クラス
2. **レイアウト管理**: `src/vs/workbench/browser/layout.ts` の `Layout` クラス
3. **各パーツの初期化**: `createPart()` メソッドで各パーツを生成

### 7.2 プログラム呼び出し階層図

```
Workbench
  |
  +-- Layout (extends)
  |     |
  |     +-- initLayout()
  |     +-- createWorkbenchLayout()
  |     +-- layout()
  |
  +-- registerPart()
        |
        +-- TitlebarPart
        +-- BannerPart
        +-- ActivitybarPart
        +-- SidebarPart
        +-- EditorPart
        +-- PanelPart
        +-- AuxiliaryBarPart
        +-- StatusbarPart
```

### 7.3 データフロー図

```
[User Action / Config Change]
         |
         v
[ConfigurationService.onDidChangeConfiguration]
         |
         v
[Layout.doUpdateLayoutConfiguration]
         |
         v
[LayoutStateModel.setRuntimeValue]
         |
         v
[SerializableGrid.layout]
         |
         v
[Part.layout() for each part]
```

### 7.4 関連ファイル一覧

| ファイルパス | 説明 |
|--------------|------|
| `src/vs/workbench/browser/workbench.ts` | メインのWorkbenchクラス（行1-500程度） |
| `src/vs/workbench/browser/layout.ts` | レイアウト管理の基底クラス（行1-400程度） |
| `src/vs/workbench/browser/part.ts` | 各Partの基底クラス |
| `src/vs/workbench/services/layout/browser/layoutService.ts` | レイアウトサービスインターフェース |
| `src/vs/base/browser/ui/grid/grid.ts` | グリッドレイアウトの実装 |

### 7.5 重要なコードスニペット

**Workbenchクラスの起動（workbench.ts）**
```typescript
export class Workbench extends Layout {
  startup(): IInstantiationService {
    // サービスの初期化
    // パーツの登録
    // レイアウトの復元
  }
}
```

**レイアウト初期化（layout.ts 行307-337）**
```typescript
protected initLayout(accessor: ServicesAccessor): void {
  // サービスの取得
  this.configurationService = accessor.get(IConfigurationService);
  // ...
  // リスナーの登録
  this.registerLayoutListeners();
  // 状態の初期化
  this.initLayoutState(...)
}
```

## 8. 画面遷移

### 8.1 遷移元

| 遷移元 | 条件 | 説明 |
|--------|------|------|
| アプリケーション起動 | - | VS Code起動時に生成 |

### 8.2 遷移先

| 遷移先 | 条件 | 説明 |
|--------|------|------|
| 各パーツ画面 | ユーザー操作 | サイドバー、パネル等への遷移 |

## 9. エラーハンドリング

| エラー種別 | 発生条件 | 対処方法 |
|------------|----------|----------|
| レイアウト復元失敗 | 保存されたレイアウト情報が不正 | デフォルトレイアウトへフォールバック |
| パーツ初期化失敗 | サービス依存関係のエラー | エラーログ出力、代替UIの表示 |

## 10. パフォーマンス考慮事項

- **遅延初期化**: 不要なパーツは表示時まで初期化を遅延
- **レイアウト計算の最適化**: 連続したレイアウト変更はバッチ処理
- **イベントのデバウンス**: ウィンドウリサイズイベントのデバウンス処理

## 11. アクセシビリティ

- **キーボードナビゲーション**: F6キーでパーツ間を移動
- **スクリーンリーダー対応**: 各パーツにARIAロール設定
- **ハイコントラストテーマ**: システムのハイコントラスト設定に対応
