# 画面設計書 11-テキストエディタ

## 概要

本ドキュメントは、Visual Studio Codeのテキストエディタ画面の設計を記載したものである。テキストエディタはVSCodeの中核機能であり、Monaco Editorを基盤として構築されている。

### 本画面の処理概要

テキストエディタは、ソースコードやテキストファイルを編集するためのメインエディタ画面である。シンタックスハイライト、IntelliSense（コード補完）、コードフォールディング、マルチカーソル編集など、高度なテキスト編集機能を提供する。

**業務上の目的・背景**：
開発者が効率的にソースコードを編集できる環境を提供することが主目的である。単純なテキスト編集だけでなく、プログラミング言語に特化した支援機能（補完、定義ジャンプ、リファクタリング等）を統合することで、開発生産性を大幅に向上させる。エディタは拡張機能からのLanguage Server Protocol（LSP）を通じた言語サポートを受け入れ、様々なプログラミング言語に対応する。

**画面へのアクセス方法**：
- エクスプローラーでファイルをクリック/ダブルクリック
- クイックオープン（Ctrl+P）でファイルを選択
- 検索結果から該当箇所をクリック
- 定義へ移動（F12）や参照検索（Shift+F12）から遷移
- コマンドパレットからファイルを開く

**主要な操作・処理内容**：
1. テキストの入力・編集（カット、コピー、ペースト、Undo/Redo）
2. シンタックスハイライトによるコードの視覚的識別
3. IntelliSenseによるコード補完候補の表示と選択
4. コードフォールディング（折りたたみ/展開）
5. 検索・置換機能（Ctrl+F、Ctrl+H）
6. マルチカーソル編集（Alt+クリック、Ctrl+Alt+上下）
7. 括弧マッチング・自動インデント
8. 定義へ移動、参照検索、リネーム
9. ホバー情報の表示
10. コードアクション（クイックフィックス）の実行

**画面遷移**：
- 入力元: エクスプローラービュー、検索ビュー、クイックオープン、他のエディタ
- 出力先: 差分エディタ（比較時）、定義先ファイル、参照先ファイル

**権限による表示制御**：
- 読み取り専用ファイルの場合は編集が無効化される
- ワークスペース信頼設定により特定の機能が制限される場合がある

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | コード編集 | 主機能 | テキストファイルの編集（カット、コピー、ペースト、Undo/Redo） |
| 2 | シンタックスハイライト | 主機能 | プログラミング言語の構文に基づいた色分け |
| 3 | コード補完（IntelliSense） | 主機能 | 入力中のコードに対する補完候補の提示 |
| 4 | 括弧マッチング | 補助機能 | 対応する括弧のハイライト表示 |
| 5 | コードフォールディング | 補助機能 | コードブロックの折りたたみ・展開 |
| 6 | 検索・置換 | 補助機能 | ファイル内のテキスト検索と置換 |
| 7 | マルチカーソル | 補助機能 | 複数箇所の同時編集 |
| 8 | コードスニペット | 補助機能 | 定型コードの挿入 |
| 9 | コードアクション | 補助機能 | クイックフィックスやリファクタリングの提案 |
| 10 | ホバー情報 | 補助機能 | カーソル位置のシンボル情報表示 |
| 11 | 定義へ移動 | 遷移先機能 | シンボルの定義箇所へのジャンプ |
| 12 | 参照検索 | 遷移先機能 | シンボルの参照箇所の検索 |
| 13 | リネーム | 補助機能 | シンボル名の一括変更 |
| 14 | コードレンズ | 補助機能 | コード上部に参照数などの情報表示 |
| 15 | インレイヒント | 補助機能 | コード内にパラメータ名や型のヒント表示 |
| 17 | インデントガイド | 補助機能 | インデントレベルの視覚的表示 |
| 18 | 行番号表示 | 補助機能 | エディタ左側に行番号を表示 |
| 19 | ミニマップ | 補助機能 | コード全体の縮小表示 |
| 20 | スティッキースクロール | 補助機能 | スコープヘッダーの固定表示 |

## 画面種別

編集画面

## URL/ルーティング

内部ルーティング: エディタタブシステムによる管理
識別子: `workbench.editor.textEditor`

## 入出力項目

| 項目名 | 型 | 必須 | 入力/出力 | 説明 |
|--------|-----|------|----------|------|
| resource | URI | 必須 | 入力 | 編集対象ファイルのURI |
| options | ITextEditorOptions | 任意 | 入力 | エディタオプション（選択範囲、スクロール位置等） |
| selection | Selection | 任意 | 入力/出力 | カーソル位置・選択範囲 |
| viewState | IEditorViewState | 任意 | 入力/出力 | エディタの表示状態（スクロール位置等） |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| 行番号 | エディタ左側に表示される行番号 | エディタモデル |
| ミニマップ | コード全体の縮小表示（右側） | エディタモデル |
| パンくずリスト | 現在位置のシンボル階層 | Language Server |
| ステータスバー情報 | 行列番号、言語モード、エンコーディング等 | エディタ状態 |
| コードレンズ | 参照数等のインライン情報 | Language Server |
| インデントガイド | インデントレベルを示す縦線 | エディタモデル |

## イベント仕様

### 1-テキスト入力

キーボード入力時にテキストがエディタモデルに反映される。

- トリガー: キーボード入力
- 処理: テキストモデルへの文字挿入/削除
- 結果: シンタックスハイライトの再計算、Undo履歴への追加

### 2-コード補完

入力中にIntelliSense補完ウィジェットが表示される。

- トリガー: 文字入力、Ctrl+Space
- 処理: Language Serverへの補完リクエスト
- 結果: 補完候補リストの表示

### 3-定義へ移動

シンボルの定義箇所へジャンプする。

- トリガー: F12、Ctrl+クリック
- 処理: Language Serverへの定義位置リクエスト
- 結果: 定義ファイルを開き該当箇所へ移動

### 4-検索・置換

ファイル内テキスト検索を実行する。

- トリガー: Ctrl+F（検索）、Ctrl+H（置換）
- 処理: 検索ウィジェットの表示、マッチング処理
- 結果: マッチ箇所のハイライト、ナビゲーション

### 5-コードアクション

クイックフィックスやリファクタリングを実行する。

- トリガー: Ctrl+.、電球アイコンクリック
- 処理: Language Serverへのコードアクションリクエスト
- 結果: アクションリストの表示、選択したアクションの適用

## データベース更新仕様

VSCodeはファイルベースのエディタのため、データベースへの直接的な更新は行わない。ただし、以下のストレージへの書き込みが発生する。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ファイル保存 | ファイルシステム | UPDATE | 編集内容をファイルに保存 |
| ビューステート保存 | StorageService | UPDATE | エディタの表示状態を永続化 |
| 編集履歴保存 | LocalHistory | INSERT | ローカル履歴への保存 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|---------|
| MSG001 | 情報 | "editor" | 入力がない場合のARIAラベル |
| MSG002 | エラー | "Control has not yet been initialized" | エディタ未初期化時のスクロール操作 |

## 例外処理

| 例外 | 条件 | 対応 |
|------|------|------|
| 読み取り専用エラー | 読み取り専用ファイルの編集試行 | 編集をブロック、メッセージ表示 |
| ファイル未検出 | 開こうとしたファイルが存在しない | エラーメッセージ表示 |
| エンコーディングエラー | ファイルエンコーディングの問題 | エンコーディング選択ダイアログ表示 |

## 備考

- Monaco Editorを基盤として構築されている
- Language Server Protocolを通じて言語固有の機能を提供
- 拡張機能によりカスタムエディタ機能を追加可能
- エディタの設定は`editor.*`設定項目で細かくカスタマイズ可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エディタで扱われるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | editorCommon.ts | `src/vs/editor/common/editorCommon.ts` | IEditorViewStateなどエディタの状態を表すインターフェースを確認 |
| 1-2 | selection.ts | `src/vs/editor/common/core/selection.ts` | 選択範囲を表すSelectionクラスの構造を理解 |

**読解のコツ**: TypeScriptのインターフェース定義に注目し、どのようなプロパティが管理されているかを把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | textEditor.ts | `src/vs/workbench/browser/parts/editor/textEditor.ts` | AbstractTextEditorクラスがテキストエディタの基底クラス |

**主要処理フロー**:
1. **49行目**: AbstractTextEditorクラス定義 - IEditorPaneWithSelection, IEditorPaneWithScrollingを実装
2. **66-78行目**: コンストラクタ - 各種サービスの注入と初期化
3. **175-183行目**: createEditor - エディタコントロールの作成
4. **240-253行目**: setInput - エディタ入力の設定

#### Step 3: エディタコントロールの作成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | editorWithViewState.ts | `src/vs/workbench/browser/parts/editor/editorWithViewState.ts` | ビューステート管理の基底クラス |
| 3-2 | editorBrowser.ts | `src/vs/editor/browser/editorBrowser.ts` | ICodeEditorインターフェースの定義 |

**主要処理フロー**:
- **175行目**: createEditorメソッドでエディタコンテナを作成
- **179行目**: createEditorControlを呼び出しMonaco Editorを生成

#### Step 4: イベントハンドリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | textEditor.ts | `src/vs/workbench/browser/parts/editor/textEditor.ts` | registerCodeEditorListenersメソッド |

**主要処理フロー**:
- **185-193行目**: エディタイベントのリスナー登録
- **190行目**: カーソル位置変更イベントの処理
- **191行目**: モデルコンテンツ変更イベントの処理

### プログラム呼び出し階層図

```
AbstractTextEditor (textEditor.ts)
    │
    ├─ createEditor()
    │      └─ createEditorControl() [抽象メソッド]
    │             └─ Monaco ICodeEditor生成
    │
    ├─ setInput()
    │      ├─ super.setInput()
    │      └─ updateEditorConfiguration()
    │
    ├─ registerCodeEditorListeners()
    │      ├─ onDidChangeModelLanguage
    │      ├─ onDidChangeModel
    │      ├─ onDidChangeCursorPosition
    │      └─ onDidChangeModelContent
    │
    └─ getSelection()
           └─ TextEditorPaneSelection
```

### データフロー図

```
[入力]                    [処理]                         [出力]

EditorInput ────────────▶ setInput() ──────────────────▶ エディタ表示
  (URI, options)               │
                              ▼
                    updateEditorConfiguration()
                              │
                              ▼
                    createEditorControl()
                              │
                              ▼
                    ICodeEditor (Monaco)
                              │
キーボード入力 ─────────────▶ │
                              ▼
                    TextModel更新 ──────────────────────▶ 画面描画更新
                              │
                              ▼
                    onDidChangeSelection ──────────────▶ ステータスバー更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| textEditor.ts | `src/vs/workbench/browser/parts/editor/textEditor.ts` | ソース | テキストエディタの基底クラス |
| editorPane.ts | `src/vs/workbench/browser/parts/editor/editorPane.ts` | ソース | エディタペインの基底クラス |
| editorWithViewState.ts | `src/vs/workbench/browser/parts/editor/editorWithViewState.ts` | ソース | ビューステート管理 |
| editorBrowser.ts | `src/vs/editor/browser/editorBrowser.ts` | ソース | Monaco Editorのブラウザインターフェース |
| editorCommon.ts | `src/vs/editor/common/editorCommon.ts` | ソース | エディタ共通定義 |
| selection.ts | `src/vs/editor/common/core/selection.ts` | ソース | 選択範囲クラス |
| editorInput.ts | `src/vs/workbench/common/editor/editorInput.ts` | ソース | エディタ入力の基底クラス |
