# 画面設計書 13-ノートブックエディタ

## 概要

本ドキュメントは、Visual Studio Codeのノートブックエディタ画面の設計を記載したものである。ノートブックエディタはJupyter Notebookなどの対話型ドキュメントを編集・実行するための専用エディタである。

### 本画面の処理概要

ノートブックエディタは、コードセルとマークダウンセルを組み合わせた対話型ドキュメント（.ipynbファイルなど）を編集・実行する画面である。各セルは独立して編集・実行可能で、コードセルの実行結果（テキスト、画像、グラフなど）がセル下部に表示される。

**業務上の目的・背景**：
データサイエンティストや研究者が対話的にコードを実行し、結果を確認しながら分析を進めるためのワークフローを提供する。実行結果をドキュメント内に保持できるため、再現性のある分析レポートの作成が可能。Jupyter NotebookとのネイティブなやりとりをVSCode内で実現する。

**画面へのアクセス方法**：
- エクスプローラーで.ipynbファイルをクリック
- コマンドパレット「新しいJupyterノートブックを作成」
- ファイル→新規ファイル→Jupyter Notebook
- クイックオープンでノートブックファイルを選択

**主要な操作・処理内容**：
1. セルの作成（コードセル/マークダウンセル）
2. セルの編集（コード入力/マークダウン記述）
3. セルの実行（単一セル/すべてのセル/選択範囲）
4. 実行結果の表示（テキスト、画像、HTML、グラフ等）
5. セルの移動・並べ替え
6. カーネルの選択・管理
7. 変数エクスプローラーとの連携
8. ノートブックのエクスポート（HTML、PDF等）

**画面遷移**：
- 入力元: エクスプローラービュー、クイックオープン、新規ファイル作成
- 出力先: テキストエディタ（セルをスクリプトとして開く）、ターミナル

**権限による表示制御**：
- カーネルが利用できない場合は実行機能が無効化
- ワークスペース信頼設定によりコード実行が制限される場合がある

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | セル編集 | 主機能 | コードセル/マークダウンセルの編集 |
| 2 | セル実行 | 主機能 | コードセルの実行と結果表示 |
| 3 | カーネル管理 | 主機能 | Python等のカーネルの選択と管理 |
| 4 | 実行結果表示 | 主機能 | テキスト、画像、グラフ等の出力表示 |
| 5 | セル操作 | 補助機能 | セルの追加、削除、移動、コピー |
| 6 | マークダウンプレビュー | 補助機能 | マークダウンセルのレンダリング |
| 7 | 変数エクスプローラー | 連携機能 | 実行中の変数一覧表示 |
| 8 | IntelliSense | 補助機能 | コードセル内での補完機能 |
| 9 | デバッグ | 連携機能 | ノートブックコードのデバッグ |
| 10 | エクスポート | 補助機能 | HTML、PDF等へのエクスポート |

## 画面種別

編集画面（対話型）

## URL/ルーティング

内部ルーティング: エディタタブシステムによる管理
識別子: `workbench.editor.notebookEditor`

## 入出力項目

| 項目名 | 型 | 必須 | 入力/出力 | 説明 |
|--------|-----|------|----------|------|
| resource | URI | 必須 | 入力 | ノートブックファイルのURI |
| viewType | string | 必須 | 入力 | ノートブックタイプ（jupyter-notebook等） |
| options | INotebookEditorOptions | 任意 | 入力 | エディタオプション |
| kernel | IKernelSpec | 任意 | 入力/出力 | 使用するカーネル情報 |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| セルリスト | ノートブック内のセル一覧 | NotebookModel |
| セルエディタ | 各セルのコード/マークダウン編集領域 | CellEditorPart |
| 実行結果 | コードセル実行後の出力 | CellOutputPart |
| カーネルステータス | 選択中のカーネルと実行状態 | KernelService |
| セルツールバー | セル操作ボタン（実行、削除等） | UI |
| グローバルツールバー | ノートブック全体の操作ボタン | UI |

## イベント仕様

### 1-セル実行

選択中のセルを実行する。

- トリガー: Shift+Enter、実行ボタンクリック
- 処理: カーネルへのコード送信、実行結果の受信
- 結果: セル下部に実行結果を表示

### 2-セル追加

新しいセルを追加する。

- トリガー: ツールバーボタン、キーボードショートカット
- 処理: NotebookModelへのセル挿入
- 結果: 新しいセルの表示、フォーカス移動

### 3-セル種別変更

セルタイプを変更する（コード⇔マークダウン）。

- トリガー: ツールバー、コマンドパレット
- 処理: セルのkind属性変更
- 結果: エディタモードの変更

### 4-カーネル選択

使用するカーネルを選択する。

- トリガー: カーネルピッカークリック
- 処理: カーネル一覧取得、選択、接続
- 結果: カーネルの切り替え

### 5-すべて実行

ノートブック内のすべてのセルを順次実行する。

- トリガー: ツールバー「すべて実行」ボタン
- 処理: 各セルの順次実行
- 結果: すべてのセルの実行結果更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ノートブック保存 | ファイルシステム | UPDATE | ノートブックをipynb形式で保存 |
| 実行結果保存 | NotebookModel | UPDATE | 実行結果をノートブックモデルに保存 |
| カーネル状態保存 | StorageService | UPDATE | 選択カーネル情報の永続化 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|---------|
| MSG001 | 情報 | "Select a kernel to enable code execution" | カーネル未選択時 |
| MSG002 | 警告 | "Kernel disconnected" | カーネル切断時 |
| MSG003 | 情報 | "Running..." | セル実行中 |
| MSG004 | エラー | "Execution failed" | 実行エラー発生時 |

## 例外処理

| 例外 | 条件 | 対応 |
|------|------|------|
| カーネル未検出 | 対応するカーネルが見つからない | カーネルインストール案内 |
| 実行タイムアウト | セル実行が時間切れ | 実行中断オプション表示 |
| メモリ不足 | 出力データが大きすぎる | 出力の切り詰めと警告 |
| ファイル形式エラー | ipynbファイルの解析失敗 | エラーメッセージ表示 |

## 備考

- Jupyter拡張機能との連携でフル機能を提供
- カスタムノートブックレンダラーによりリッチな出力表示が可能
- 複数のノートブックプロバイダーをサポート
- セルの折りたたみ機能をサポート

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notebookCommon.ts | `src/vs/workbench/contrib/notebook/common/notebookCommon.ts` | INotebookCellなどセルのインターフェース |
| 1-2 | notebookEditorInput.ts | `src/vs/workbench/contrib/notebook/common/notebookEditorInput.ts` | ノートブック入力の構造 |

**読解のコツ**: セル（INotebookCell）とノートブックドキュメント（INotebookDocument）の関係を把握する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notebookEditor.ts | `src/vs/workbench/contrib/notebook/browser/notebookEditor.ts` | NotebookEditorクラスがメインクラス |

**主要処理フロー**:
1. **40行目**: NotebookEditorクラス定義 - EditorPaneを継承
2. **85-130行目**: createEditor - NotebookEditorWidgetの生成
3. **180-230行目**: setInput - ノートブック入力の設定

#### Step 3: ウィジェットを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notebookEditorWidget.ts | `src/vs/workbench/contrib/notebook/browser/notebookEditorWidget.ts` | ノートブックの表示ウィジェット |

**主要処理フロー**:
- **100-150行目**: セルリストの構築
- **200-250行目**: セル実行ハンドラ
- **300-350行目**: カーネル管理

#### Step 4: セル表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cellParts.ts | `src/vs/workbench/contrib/notebook/browser/view/cellParts/cellParts.ts` | セルパーツの構成 |
| 4-2 | cellExecution.ts | `src/vs/workbench/contrib/notebook/browser/view/cellParts/cellExecution.ts` | セル実行UI |

**主要処理フロー**:
- CellEditorPart: コード編集部分
- CellOutputPart: 実行結果表示部分
- CellStatusPart: ステータス表示部分

### プログラム呼び出し階層図

```
NotebookEditor (notebookEditor.ts)
    │
    ├─ createEditor()
    │      └─ NotebookEditorWidget
    │             ├─ NotebookCellList (セル一覧)
    │             ├─ CellEditorPart (エディタ)
    │             └─ CellOutputPart (出力)
    │
    ├─ setInput()
    │      ├─ resolveNotebookInput()
    │      └─ NotebookViewModel作成
    │
    └─ 実行処理
           └─ INotebookExecutionService
                  └─ INotebookKernelService
                         └─ カーネル呼び出し
```

### データフロー図

```
[入力]                    [処理]                         [出力]

NotebookEditorInput ────▶ setInput() ──────────────────▶ ノートブック表示
  (URI, viewType)              │
                              ▼
                    resolveNotebookModel()
                              │
                              ▼
                    NotebookViewModel
                              │
                              ▼
                    NotebookCellList
                              │
セル実行トリガー ─────────────▶ │
                              ▼
                    INotebookKernelService
                              │
                              ▼
                    カーネル実行 ──────────────────────▶ 実行結果表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notebookEditor.ts | `src/vs/workbench/contrib/notebook/browser/notebookEditor.ts` | ソース | ノートブックエディタのメインクラス |
| notebookEditorWidget.ts | `src/vs/workbench/contrib/notebook/browser/notebookEditorWidget.ts` | ソース | ノートブック表示ウィジェット |
| notebookEditorInput.ts | `src/vs/workbench/contrib/notebook/common/notebookEditorInput.ts` | ソース | ノートブック入力 |
| notebookCommon.ts | `src/vs/workbench/contrib/notebook/common/notebookCommon.ts` | ソース | 共通インターフェース定義 |
| notebookKernelService.ts | `src/vs/workbench/contrib/notebook/browser/services/notebookKernelService.ts` | ソース | カーネル管理サービス |
| cellParts.ts | `src/vs/workbench/contrib/notebook/browser/view/cellParts/cellParts.ts` | ソース | セル表示パーツ |
| cellExecution.ts | `src/vs/workbench/contrib/notebook/browser/view/cellParts/cellExecution.ts` | ソース | セル実行UI |
