# 画面設計書 14-設定エディタ

## 概要

本ドキュメントは、Visual Studio Codeの設定エディタ画面の設計を記載したものである。設定エディタはVSCodeの各種設定をGUIで管理するための画面である。

### 本画面の処理概要

設定エディタ（Settings Editor）は、VSCodeの設定をグラフィカルに閲覧・編集するための画面である。左側に目次（Table of Contents）、右側に設定項目リストを表示する2ペイン構成となっている。設定は検索、フィルタリング、カテゴリ別ナビゲーションが可能。

**業務上の目的・背景**：
ユーザーがVSCodeの動作を細かくカスタマイズできるようにする。JSON形式の設定ファイルを直接編集する代わりに、GUIでわかりやすく設定を変更できる。設定は「ユーザー設定」「ワークスペース設定」「フォルダー設定」の3つのスコープで管理される。

**画面へのアクセス方法**：
- Ctrl+,（Cmd+,）ショートカット
- ファイル→基本設定→設定
- コマンドパレット「設定を開く」
- アクティビティバーの歯車アイコン→設定

**主要な操作・処理内容**：
1. 設定項目の検索（自然言語、AI検索対応）
2. カテゴリ別の設定閲覧
3. 設定値の変更（チェックボックス、ドロップダウン、テキスト入力等）
4. 設定のリセット（デフォルト値に戻す）
5. 設定スコープの切り替え（ユーザー/ワークスペース）
6. JSON設定ファイルへの直接アクセス
7. 同期設定の管理
8. 拡張機能別の設定フィルタリング

**画面遷移**：
- 入力元: メニュー、コマンドパレット、アクティビティバー
- 出力先: JSON設定エディタ、キーバインド設定、拡張機能エディタ

**権限による表示制御**：
- ポリシー設定項目はシステム管理者によりロックされる場合がある
- ワークスペース信頼設定により一部の設定が制限される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | 設定検索 | 主機能 | キーワードによる設定項目の検索 |
| 2 | カテゴリナビゲーション | 主機能 | 目次による設定カテゴリの選択 |
| 3 | 設定値編集 | 主機能 | 各種入力コントロールによる設定変更 |
| 4 | 設定リセット | 補助機能 | デフォルト値への復元 |
| 5 | スコープ切り替え | 主機能 | ユーザー/ワークスペース/フォルダーの選択 |
| 6 | 同期設定管理 | 連携機能 | Settings Syncとの連携 |
| 7 | JSON編集 | 連携機能 | settings.jsonの直接編集 |
| 8 | 拡張機能フィルター | 補助機能 | @ext:で拡張機能別にフィルタ |
| 9 | タグフィルター | 補助機能 | @tag:で特定タグの設定をフィルタ |
| 10 | AI検索 | 補助機能 | 自然言語による設定検索 |

## 画面種別

設定画面

## URL/ルーティング

内部ルーティング: エディタタブシステムによる管理
識別子: `workbench.editor.settings2`

## 入出力項目

| 項目名 | 型 | 必須 | 入力/出力 | 説明 |
|--------|-----|------|----------|------|
| query | string | 任意 | 入力 | 検索クエリ |
| focusedSettingId | string | 任意 | 入力 | フォーカスする設定ID |
| target | ConfigurationTarget | 任意 | 入力 | 設定スコープ |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| 目次（TOC） | 設定カテゴリのツリー | IConfigurationRegistry |
| 設定リスト | 設定項目の一覧 | Settings2EditorModel |
| 検索バー | 検索入力フィールド | UI |
| スコープタブ | ユーザー/ワークスペース切り替え | SettingsTargetsWidget |
| 設定コントロール | 各設定の編集UI | SettingRenderer |
| 検索結果数 | マッチした設定数 | SearchResultModel |

## イベント仕様

### 1-設定検索

検索クエリに基づいて設定をフィルタリングする。

- トリガー: 検索入力（200msのデバウンス付き）
- 処理: parseQuery→検索プロバイダーへのリクエスト
- 結果: 検索結果の表示、該当設定のハイライト

### 2-設定値変更

設定値を変更する。

- トリガー: 入力コントロールの操作
- 処理: IConfigurationService.updateValue呼び出し
- 結果: settings.jsonへの書き込み、UI更新

### 3-TOCナビゲーション

目次をクリックして該当カテゴリへスクロールする。

- トリガー: TOCアイテムクリック
- 処理: SettingsTreeのスクロール
- 結果: 該当カテゴリの表示

### 4-スコープ切り替え

設定スコープを変更する。

- トリガー: スコープタブの選択
- 処理: viewState.settingsTargetの更新
- 結果: 該当スコープの設定値表示

### 5-設定リセット

設定をデフォルト値に戻す。

- トリガー: リセットボタンクリック
- 処理: ConfigurationService.updateValue(undefined)
- 結果: デフォルト値の復元

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定変更 | settings.json | UPDATE | 設定ファイルへの書き込み |
| ワークスペース設定変更 | .vscode/settings.json | UPDATE | ワークスペース設定の書き込み |
| エディタ状態保存 | StorageService | UPDATE | 検索クエリ等の状態保存 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|---------|
| MSG001 | 情報 | "No Settings Found" | 検索結果が0件の場合 |
| MSG002 | 情報 | "{0} Settings Found" | 検索結果の件数表示 |
| MSG003 | 警告 | "This setting is managed by your organization" | ポリシー制御設定 |
| MSG004 | 情報 | "Modified" | 変更された設定の表示 |

## 例外処理

| 例外 | 条件 | 対応 |
|------|------|------|
| 設定書き込みエラー | ファイル書き込み権限なし | エラーメッセージ表示 |
| スキーマエラー | 無効な設定値 | バリデーションエラー表示 |
| 検索タイムアウト | 検索処理が長時間 | タイムアウトエラー |

## 備考

- 設定はsettings.json（JSON形式）に保存される
- 拡張機能は独自の設定項目を登録できる
- AI検索機能は設定で有効/無効を切り替え可能
- 一部の設定は再起動が必要

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | preferences.ts | `src/vs/workbench/services/preferences/common/preferences.ts` | ISetting, ISettingsGroupなどの定義 |
| 1-2 | settingsTreeModels.ts | `src/vs/workbench/contrib/preferences/browser/settingsTreeModels.ts` | SettingsTreeElement等のモデル |

**読解のコツ**: 設定項目（ISetting）の構造と、それがUIにどうマッピングされるかを把握する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | settingsEditor2.ts | `src/vs/workbench/contrib/preferences/browser/settingsEditor2.ts` | SettingsEditor2クラスがメインクラス |

**主要処理フロー**:
1. **108行目**: SettingsEditor2クラス定義 - EditorPaneを継承
2. **246-271行目**: コンストラクタ - 各種サービス注入と初期化
3. **76-92行目**: SettingsFocusContext - フォーカス状態管理
4. **273-300行目**: onDidChangeConfiguration - 設定変更時の処理

#### Step 3: 検索機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | settingsTreeModels.ts | `src/vs/workbench/contrib/preferences/browser/settingsTreeModels.ts` | SearchResultModel |

**主要処理フロー**:
- **parseQuery**: 検索クエリの解析
- **SearchResultModel**: 検索結果の管理
- **SEARCH_DEBOUNCE**: 200msのデバウンス

#### Step 4: 設定レンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | settingsTree.ts | `src/vs/workbench/contrib/preferences/browser/settingsTree.ts` | SettingsTree, SettingTreeRenderers |

**主要処理フロー**:
- AbstractSettingRenderer: 設定項目のレンダリング基底クラス
- 各種レンダラー（Boolean, Enum, Number, String等）
- SettingsTree: 設定ツリービュー

### プログラム呼び出し階層図

```
SettingsEditor2 (settingsEditor2.ts)
    │
    ├─ createEditor()
    │      ├─ createHeader() - 検索バー
    │      ├─ createBody()
    │      │      ├─ createTOC() - 目次
    │      │      └─ createSettingsTree() - 設定リスト
    │      └─ SettingsTargetsWidget - スコープ切替
    │
    ├─ setInput()
    │      └─ render()
    │             ├─ resolveSettings()
    │             └─ updateTree()
    │
    └─ 検索処理
           ├─ parseQuery()
           ├─ SearchResultModel
           └─ triggerSearch()
                  └─ IPreferencesSearchService
```

### データフロー図

```
[入力]                    [処理]                         [出力]

SettingsEditor2Input ───▶ setInput() ──────────────────▶ 設定エディタ表示
                              │
                              ▼
                    resolveSettings()
                              │
                              ▼
                    Settings2EditorModel
                              │
                              ▼
                    SettingsTreeModel
                              │
検索入力 ─────────────────────▶ │
                              ▼
                    parseQuery() / SearchResultModel
                              │
                              ▼
                    triggerSearch() ─────────────────────▶ 検索結果表示
                              │
設定値変更 ───────────────────▶ │
                              ▼
                    IConfigurationService.updateValue()
                              │
                              ▼
                    settings.json更新 ─────────────────▶ UI更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| settingsEditor2.ts | `src/vs/workbench/contrib/preferences/browser/settingsEditor2.ts` | ソース | 設定エディタのメインクラス |
| settingsTree.ts | `src/vs/workbench/contrib/preferences/browser/settingsTree.ts` | ソース | 設定ツリービュー |
| settingsTreeModels.ts | `src/vs/workbench/contrib/preferences/browser/settingsTreeModels.ts` | ソース | 設定ツリーモデル |
| settingsLayout.ts | `src/vs/workbench/contrib/preferences/browser/settingsLayout.ts` | ソース | 設定レイアウト/TOC定義 |
| tocTree.ts | `src/vs/workbench/contrib/preferences/browser/tocTree.ts` | ソース | 目次ツリー |
| preferences.ts | `src/vs/workbench/services/preferences/common/preferences.ts` | ソース | 設定サービスインターフェース |
| preferencesModels.ts | `src/vs/workbench/services/preferences/common/preferencesModels.ts` | ソース | 設定モデル |
| settingsEditor2.css | `src/vs/workbench/contrib/preferences/browser/media/settingsEditor2.css` | スタイル | 設定エディタスタイル |
