# 画面設計書 15-キーバインド設定エディタ

## 概要

本ドキュメントは、Visual Studio Codeのキーバインド設定エディタ画面の設計を記載したものである。キーバインド設定エディタはキーボードショートカットをGUIで管理するための画面である。

### 本画面の処理概要

キーバインド設定エディタ（Keybindings Editor）は、VSCodeのキーボードショートカットを閲覧・編集するための画面である。すべてのコマンドとその割り当てられたキーバインドを一覧表示し、検索、変更、削除、リセットなどの操作が可能。

**業務上の目的・背景**：
ユーザーが自身の作業スタイルに合わせてキーボードショートカットをカスタマイズできるようにする。コマンドごとのキーバインドの確認、競合の検出、新規キーバインドの設定をGUIで行えるため、keybindings.jsonを直接編集する必要がない。

**画面へのアクセス方法**：
- Ctrl+K Ctrl+S（Cmd+K Cmd+S）ショートカット
- ファイル→基本設定→キーボードショートカット
- コマンドパレット「キーボードショートカットを開く」
- 設定エディタからのリンク

**主要な操作・処理内容**：
1. コマンド/キーバインドの検索
2. キーバインドの変更（新しいキーコンビネーションの記録）
3. キーバインドの削除
4. デフォルトへのリセット
5. 競合するキーバインドの確認
6. When条件の設定
7. keybindings.jsonへの直接アクセス
8. 拡張機能別キーバインドのフィルタリング

**画面遷移**：
- 入力元: メニュー、コマンドパレット、設定エディタ
- 出力先: keybindings.json（JSON編集）

**権限による表示制御**：
- システムキーバインドは変更できない場合がある
- 拡張機能が提供するキーバインドは拡張機能有効時のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | キーバインド検索 | 主機能 | コマンドまたはキーによる検索 |
| 2 | キーバインド変更 | 主機能 | キーコンビネーションの記録と割り当て |
| 3 | キーバインド削除 | 主機能 | 割り当ての解除 |
| 4 | キーバインドリセット | 補助機能 | デフォルト値への復元 |
| 5 | 競合検出 | 補助機能 | 同一キーの重複割り当て検出 |
| 6 | When条件編集 | 補助機能 | キーバインドの有効条件設定 |
| 7 | キー記録モード | 補助機能 | キー入力をリアルタイムで記録 |
| 8 | ソース別フィルター | 補助機能 | デフォルト/ユーザー/拡張機能別表示 |

## 画面種別

設定画面

## URL/ルーティング

内部ルーティング: エディタタブシステムによる管理
識別子: `workbench.editor.keybindings`

## 入出力項目

| 項目名 | 型 | 必須 | 入力/出力 | 説明 |
|--------|-----|------|----------|------|
| searchValue | string | 任意 | 入力 | 検索クエリ |
| recordKeys | boolean | 任意 | 入力 | キー記録モードフラグ |
| selectedKeybinding | IKeybindingItemEntry | 任意 | 出力 | 選択中のキーバインド |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| 検索バー | 検索入力とキー記録切り替え | UI |
| キーバインドリスト | コマンドとキーの一覧 | KeybindingsEditorModel |
| コマンド列 | コマンドIDと説明 | IKeybindingItemEntry |
| キーバインド列 | 割り当てられたキー | IKeybindingItemEntry |
| When条件列 | キーバインドの有効条件 | IKeybindingItemEntry |
| ソース列 | デフォルト/ユーザー/拡張機能 | IKeybindingItemEntry |

## イベント仕様

### 1-キーバインド検索

検索クエリでフィルタリングする。

- トリガー: 検索入力、キー記録
- 処理: KeybindingsEditorModel.search()
- 結果: マッチするキーバインドの表示

### 2-キーバインド変更

新しいキーを割り当てる。

- トリガー: 編集アイコンクリック、Enter押下後のキー記録
- 処理: DefineKeybindingWidget表示、キー入力記録
- 結果: keybindings.jsonへの書き込み

### 3-キーバインド削除

キーバインドを解除する。

- トリガー: 削除アイコンクリック、Deleteキー
- 処理: コマンドに-プレフィックスを付けて保存
- 結果: キーバインドの無効化

### 4-キーバインドリセット

デフォルトに戻す。

- トリガー: リセットアイコンクリック
- 処理: ユーザー設定からエントリを削除
- 結果: デフォルトキーバインドの復元

### 5-When条件編集

キーバインドの有効条件を設定する。

- トリガー: When列のダブルクリック
- 処理: 条件入力ダイアログ表示
- 結果: When条件の更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| キーバインド変更 | keybindings.json | UPDATE | キーバインド設定の書き込み |
| キーバインド削除 | keybindings.json | UPDATE | 無効化エントリの追加 |
| キーバインドリセット | keybindings.json | DELETE | ユーザー設定エントリの削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|---------|
| MSG001 | 情報 | "No results found" | 検索結果が0件 |
| MSG002 | 情報 | "Press desired key combination and then press ENTER" | キー記録時 |
| MSG003 | 警告 | "Key combination conflicts with {0}" | 競合検出時 |
| MSG004 | 情報 | "Recording keys..." | キー記録モード中 |

## 例外処理

| 例外 | 条件 | 対応 |
|------|------|------|
| 無効なキーコンビネーション | 使用できないキーの組み合わせ | エラー表示 |
| JSON書き込みエラー | ファイル書き込み権限なし | エラーメッセージ表示 |
| 予約済みキー | OSレベルで予約されたキー | 警告表示 |

## 備考

- キーバインドはkeybindings.json（JSON形式）に保存される
- 競合するキーバインドは同一エントリにグループ化される
- When条件はコンテキストキーの論理式で記述
- 拡張機能は独自のキーバインドを提供できる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | keybindingsEditorModel.ts | `src/vs/workbench/contrib/preferences/browser/keybindingsEditorModel.ts` | IKeybindingItemEntryなどの定義 |
| 1-2 | keybinding.ts | `src/vs/base/common/keybinding.ts` | Keybindingクラスの構造 |

**読解のコツ**: キーバインドエントリ（IKeybindingItemEntry）の構造を把握し、コマンド、キー、条件の関係を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | keybindingsEditor.ts | `src/vs/workbench/contrib/preferences/browser/keybindingsEditor.ts` | KeybindingsEditorクラスがメインクラス |

**主要処理フロー**:
1. **82行目**: KeybindingsEditorクラス定義 - EditorPaneを継承
2. **130-180行目**: createEditor - UIの構築
3. **200-250行目**: layoutKeybindingsEditor - レイアウト処理
4. **300-350行目**: renderKeybindingsEntries - リスト描画

#### Step 3: キー記録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | keybindingWidgets.ts | `src/vs/workbench/contrib/preferences/browser/keybindingWidgets.ts` | DefineKeybindingWidget |

**主要処理フロー**:
- DefineKeybindingWidget: キー入力ダイアログ
- RecordingKeybindingWidget: キー記録UI
- キーイベントのキャプチャと解析

#### Step 4: リスト表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | keybindingsEditor.ts | `src/vs/workbench/contrib/preferences/browser/keybindingsEditor.ts` | KeybindingItemRenderer |

**主要処理フロー**:
- KeybindingsTable: キーバインドテーブル
- KeybindingItemRenderer: 各行のレンダリング
- ActionsColumn: 編集/削除アクション

### プログラム呼び出し階層図

```
KeybindingsEditor (keybindingsEditor.ts)
    │
    ├─ createEditor()
    │      ├─ createHeader() - 検索バー
    │      │      └─ KeybindingsSearchWidget
    │      └─ createBody()
    │             └─ KeybindingsTable
    │                    └─ KeybindingItemRenderer
    │
    ├─ setInput()
    │      └─ render()
    │             ├─ KeybindingsEditorModel.resolve()
    │             └─ renderKeybindingsEntries()
    │
    └─ キーバインド編集
           └─ DefineKeybindingWidget
                  └─ RecordingKeybindingWidget
```

### データフロー図

```
[入力]                    [処理]                         [出力]

KeybindingsEditorInput ─▶ setInput() ──────────────────▶ キーバインドエディタ表示
                              │
                              ▼
                    KeybindingsEditorModel.resolve()
                              │
                              ▼
                    IKeybindingItemEntry[]
                              │
                              ▼
                    KeybindingsTable
                              │
検索入力 ─────────────────────▶ │
                              ▼
                    search() ──────────────────────────▶ フィルター結果表示
                              │
キー記録 ─────────────────────▶ │
                              ▼
                    DefineKeybindingWidget
                              │
                              ▼
                    IKeybindingService.resolveKeybinding()
                              │
                              ▼
                    keybindings.json更新 ──────────────▶ リスト更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| keybindingsEditor.ts | `src/vs/workbench/contrib/preferences/browser/keybindingsEditor.ts` | ソース | キーバインドエディタのメインクラス |
| keybindingsEditorModel.ts | `src/vs/workbench/contrib/preferences/browser/keybindingsEditorModel.ts` | ソース | キーバインドデータモデル |
| keybindingWidgets.ts | `src/vs/workbench/contrib/preferences/browser/keybindingWidgets.ts` | ソース | キー記録ウィジェット |
| keybindingsEditorInput.ts | `src/vs/workbench/services/preferences/browser/keybindingsEditorInput.ts` | ソース | エディタ入力 |
| keybinding.ts | `src/vs/base/common/keybinding.ts` | ソース | キーバインド基底クラス |
| keybindingService.ts | `src/vs/platform/keybinding/common/keybindingService.ts` | ソース | キーバインドサービス |
| keybindingsEditor.css | `src/vs/workbench/contrib/preferences/browser/media/keybindingsEditor.css` | スタイル | エディタスタイル |
