# 画面設計書 16-拡張機能エディタ

## 概要

本ドキュメントは、Visual Studio Codeの拡張機能エディタ画面の設計を記載したものである。拡張機能エディタは個別の拡張機能の詳細情報を表示・管理するための画面である。

### 本画面の処理概要

拡張機能エディタ（Extension Editor）は、拡張機能の詳細情報を表示する画面である。README、CHANGELOG、機能一覧、依存関係などの情報をタブ形式で表示し、インストール、アンインストール、有効化/無効化などの操作が可能。

**業務上の目的・背景**：
ユーザーが拡張機能の詳細を確認し、インストール判断やバージョン管理を行うための画面。Marketplaceからの情報取得、ローカル拡張機能の情報表示の両方に対応。拡張機能の安全性評価やレビュー確認も可能。

**画面へのアクセス方法**：
- 拡張機能サイドバーで拡張機能をクリック
- Marketplace検索結果から拡張機能を選択
- コマンドパレット「拡張機能を表示」実行

**主要な操作・処理内容**：
1. 拡張機能のREADME表示
2. CHANGELOG（変更履歴）表示
3. 機能一覧（Contributions）表示
4. 依存関係と拡張パックの表示
5. インストール/アンインストール操作
6. 有効化/無効化操作
7. バージョン選択とインストール
8. 設定への移動
9. レーティングとレビューの確認

**画面遷移**：
- 入力元: 拡張機能サイドバー、Marketplace検索、コマンドパレット
- 出力先: 設定エディタ（拡張機能設定）、外部Webページ（Marketplace）

**権限による表示制御**：
- ワークスペース信頼設定により一部の拡張機能操作が制限される
- 組織ポリシーにより許可された拡張機能のみ表示される場合がある

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | README表示 | 主機能 | 拡張機能のドキュメント表示 |
| 2 | CHANGELOG表示 | 主機能 | バージョン変更履歴の表示 |
| 3 | 機能一覧表示 | 主機能 | 提供機能（コマンド、設定等）の一覧 |
| 4 | インストール | 主機能 | 拡張機能のインストール |
| 5 | アンインストール | 主機能 | 拡張機能の削除 |
| 6 | 有効化/無効化 | 主機能 | 拡張機能のオン/オフ切り替え |
| 7 | バージョン管理 | 補助機能 | 特定バージョンのインストール |
| 8 | 依存関係表示 | 補助機能 | 依存する拡張機能の表示 |
| 9 | 拡張パック展開 | 補助機能 | パック内拡張機能の一覧表示 |
| 10 | 設定アクセス | 連携機能 | 拡張機能設定画面への遷移 |

## 画面種別

詳細表示画面

## URL/ルーティング

内部ルーティング: エディタタブシステムによる管理
識別子: `workbench.editor.extension`

## 入出力項目

| 項目名 | 型 | 必須 | 入力/出力 | 説明 |
|--------|-----|------|----------|------|
| extension | IExtension | 必須 | 入力 | 表示する拡張機能 |
| activeTab | ExtensionEditorTab | 任意 | 入力 | 初期表示タブ |
| showPreReleaseVersion | boolean | 任意 | 入力 | プレリリース版表示フラグ |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| ヘッダー | アイコン、名前、バージョン、発行者 | IExtension |
| アクションバー | インストール/アンインストール等のボタン | ExtensionActions |
| ナビゲーションバー | タブ切り替え（README/CHANGELOG等） | NavBar |
| コンテンツ領域 | 選択タブの内容 | 各種コンテンツプロバイダー |
| 統計情報 | インストール数、評価 | IGalleryExtension |
| プレビューバッジ | プレビュー版の表示 | IExtension |

## イベント仕様

### 1-タブ切り替え

表示コンテンツを切り替える。

- トリガー: タブクリック
- 処理: NavBar.onChangeイベント→openTab
- 結果: 該当コンテンツの表示

### 2-インストール

拡張機能をインストールする。

- トリガー: インストールボタンクリック
- 処理: IExtensionManagementService.install()
- 結果: 拡張機能のダウンロード・インストール

### 3-アンインストール

拡張機能を削除する。

- トリガー: アンインストールボタンクリック
- 処理: IExtensionManagementService.uninstall()
- 結果: 拡張機能の削除

### 4-有効化/無効化

拡張機能の有効状態を切り替える。

- トリガー: 有効化/無効化ボタンクリック
- 処理: IExtensionEnablementService.setEnablement()
- 結果: 拡張機能状態の変更

### 5-バージョン変更

別バージョンをインストールする。

- トリガー: バージョン選択
- 処理: 指定バージョンのダウンロード・インストール
- 結果: バージョンの切り替え

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| インストール | extensions フォルダ | INSERT | 拡張機能ファイルの配置 |
| アンインストール | extensions フォルダ | DELETE | 拡張機能ファイルの削除 |
| 有効/無効切替 | StorageService | UPDATE | 有効状態の永続化 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|---------|
| MSG001 | 情報 | "Extension is being installed..." | インストール中 |
| MSG002 | 情報 | "Reload Required" | 再読み込みが必要 |
| MSG003 | 警告 | "This extension is deprecated" | 非推奨拡張機能 |
| MSG004 | 情報 | "Preview" | プレビュー版 |
| MSG005 | 情報 | "Built-in" | ビルトイン拡張機能 |

## 例外処理

| 例外 | 条件 | 対応 |
|------|------|------|
| ネットワークエラー | Marketplace接続失敗 | オフライン表示切替 |
| インストールエラー | ダウンロード/展開失敗 | エラーメッセージ表示 |
| 互換性エラー | VSCodeバージョン不一致 | 互換性警告表示 |

## 備考

- WebViewを使用してREADME/CHANGELOGをレンダリング
- Marketplaceからのメタデータは非同期に取得
- 拡張機能のContributionsはJSONスキーマから解析
- プレリリース版とリリース版の切り替えに対応

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | extensions.ts | `src/vs/workbench/contrib/extensions/common/extensions.ts` | IExtension, ExtensionStateなど |
| 1-2 | extensionsInput.ts | `src/vs/workbench/contrib/extensions/common/extensionsInput.ts` | ExtensionsInputクラス |

**読解のコツ**: IExtensionインターフェースとExtensionState列挙型の関係を把握する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extensionEditor.ts | `src/vs/workbench/contrib/extensions/browser/extensionEditor.ts` | ExtensionEditorクラスがメインクラス |

**主要処理フロー**:
1. **209行目**: ExtensionEditorクラス定義 - EditorPaneを継承
2. **262-457行目**: createEditor - ヘッダー、アクションバー、コンテンツの構築
3. **459-465行目**: setInput - 拡張機能入力の設定
4. **491-500行目**: openTab - タブ切り替え

#### Step 3: コンテンツ描画を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | extensionEditor.ts | `src/vs/workbench/contrib/extensions/browser/extensionEditor.ts` | renderBody内の各タブ描画 |

**主要処理フロー**:
- openReadme: READMEタブの表示
- openChangelog: CHANGELOGタブの表示
- openContributions: 機能一覧タブの表示
- openExtensionDependencies: 依存関係タブの表示

#### Step 4: アクションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | extensionsActions.ts | `src/vs/workbench/contrib/extensions/browser/extensionsActions.ts` | 各種アクションクラス |

**主要処理フロー**:
- InstallDropdownAction: インストールアクション
- UninstallAction: アンインストールアクション
- EnableDropDownAction: 有効化アクション
- DisableDropDownAction: 無効化アクション

### プログラム呼び出し階層図

```
ExtensionEditor (extensionEditor.ts)
    │
    ├─ createEditor()
    │      ├─ ヘッダー構築
    │      │      ├─ ExtensionIconWidget
    │      │      ├─ PublisherWidget
    │      │      └─ RatingsWidget
    │      ├─ ActionBar構築
    │      │      └─ 各種ExtensionActions
    │      └─ NavBar構築
    │             └─ タブボタン
    │
    ├─ setInput()
    │      └─ render()
    │             ├─ updateHeader()
    │             └─ openTab()
    │
    └─ openTab()
           ├─ openReadme()
           │      └─ WebView表示
           ├─ openChangelog()
           │      └─ WebView表示
           ├─ openContributions()
           │      └─ ExtensionFeaturesTab
           └─ openExtensionDependencies()
                  └─ 依存一覧表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ExtensionsInput ─────────▶ setInput() ──────────────────▶ 拡張機能エディタ表示
  (IExtension)                 │
                              ▼
                    render()
                              │
                              ▼
                    updateHeader() - ヘッダー更新
                              │
                              ▼
                    openTab(activeTab)
                              │
                    ┌─────────┼─────────┐
                    ▼         ▼         ▼
              openReadme() openChangelog() openContributions()
                    │         │         │
                    ▼         ▼         ▼
              [WebView]   [WebView]  [ExtensionFeaturesTab]
                              │
ユーザー操作 ─────────────────▶ │
                              ▼
                    ExtensionActions
                              │
                              ▼
                    IExtensionManagementService ────────▶ 拡張機能管理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extensionEditor.ts | `src/vs/workbench/contrib/extensions/browser/extensionEditor.ts` | ソース | 拡張機能エディタのメインクラス |
| extensionsInput.ts | `src/vs/workbench/contrib/extensions/common/extensionsInput.ts` | ソース | エディタ入力 |
| extensions.ts | `src/vs/workbench/contrib/extensions/common/extensions.ts` | ソース | 拡張機能インターフェース |
| extensionsActions.ts | `src/vs/workbench/contrib/extensions/browser/extensionsActions.ts` | ソース | 拡張機能アクション |
| extensionsWidgets.ts | `src/vs/workbench/contrib/extensions/browser/extensionsWidgets.ts` | ソース | 表示ウィジェット |
| extensionFeaturesTab.ts | `src/vs/workbench/contrib/extensions/browser/extensionFeaturesTab.ts` | ソース | 機能タブ |
| extensionEditor.css | `src/vs/workbench/contrib/extensions/browser/media/extensionEditor.css` | スタイル | エディタスタイル |
