# 画面設計書 17-ウェルカムエディタ

## 概要

本ドキュメントは、Visual Studio Codeのウェルカムエディタ画面の設計を記載したものである。ウェルカムエディタはVSCode起動時の開始ページであり、チュートリアルやクイックアクセス機能を提供する。

### 本画面の処理概要

ウェルカムエディタ（Getting Started / Welcome Page）は、VSCodeの初回起動時や新しいウィンドウ開始時に表示されるスタートページである。最近開いたフォルダー/ファイルへのアクセス、ウォークスルー（チュートリアル）、クイックアクションなどを提供する。

**業務上の目的・背景**：
新規ユーザーや既存ユーザーに対して、VSCodeの機能を効率的に紹介し、よく使う操作へのショートカットを提供する。ウォークスルーを通じてVSCodeの基本操作を学習でき、拡張機能が独自のウォークスルーを追加することも可能。

**画面へのアクセス方法**：
- VSCodeの初回起動時（自動表示）
- コマンドパレット「ウェルカムを表示」
- ヘルプ→ウェルカム
- 新しいウィンドウ起動時（設定による）

**主要な操作・処理内容**：
1. 最近開いたフォルダー/ファイルの一覧表示とアクセス
2. ウォークスルー（チュートリアル）の実行
3. ウォークスルーステップの完了マーク
4. フォルダーを開く/ファイルを開くアクション
5. 拡張機能提供のウォークスルーへのアクセス
6. ウォークスルーの非表示設定

**画面遷移**：
- 入力元: 起動時自動表示、コマンドパレット、ヘルプメニュー
- 出力先: エクスプローラービュー、テキストエディタ、設定エディタ、拡張機能ビュー

**権限による表示制御**：
- ワークスペースに応じて表示されるウォークスルーが異なる
- 拡張機能固有のウォークスルーは該当拡張機能インストール時のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | 最近使用項目表示 | 主機能 | 最近開いたフォルダー/ファイルの一覧 |
| 2 | ウォークスルー表示 | 主機能 | チュートリアルカードの表示 |
| 3 | ウォークスルー実行 | 主機能 | チュートリアルステップの実行 |
| 4 | ステップ完了マーク | 補助機能 | 完了したステップのチェック |
| 5 | フォルダーを開く | 連携機能 | エクスプローラーへの遷移 |
| 6 | クイックアクション | 補助機能 | よく使う操作へのショートカット |
| 7 | ウォークスルー非表示 | 補助機能 | 完了したウォークスルーの非表示 |
| 8 | 設定変更 | 連携機能 | スタートアップ設定への遷移 |

## 画面種別

案内画面

## URL/ルーティング

内部ルーティング: エディタタブシステムによる管理
識別子: `gettingStartedPage`

## 入出力項目

| 項目名 | 型 | 必須 | 入力/出力 | 説明 |
|--------|-----|------|----------|------|
| selectedCategory | string | 任意 | 入力 | 初期表示するウォークスルーID |
| selectedStep | string | 任意 | 入力 | 初期表示するステップID |
| showTelemetryNotice | boolean | 任意 | 入力 | テレメトリ通知の表示フラグ |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| ウォークスルーリスト | チュートリアルカードの一覧 | IWalkthroughsService |
| 最近使用項目 | 最近開いたフォルダー/ファイル | IWorkspacesService |
| スタートアクション | 新規作成、フォルダーを開く等 | startEntries |
| ステップリスト | ウォークスルー内のステップ | IResolvedWalkthrough |
| 進捗インジケーター | ウォークスルーの完了状況 | getWalkthroughCompletionStats |

## イベント仕様

### 1-ウォークスルー選択

ウォークスルーカードを選択して詳細を表示する。

- トリガー: カードクリック、キーボード選択
- 処理: scrollToCategory→カテゴリスライド表示
- 結果: ウォークスルーステップの表示

### 2-ステップ実行

ウォークスルーのステップを実行する。

- トリガー: ステップクリック、キーボード選択
- 処理: runStepCommand→コマンド実行
- 結果: 該当機能の実行、ステップの完了マーク

### 3-フォルダーを開く

フォルダー選択ダイアログを表示する。

- トリガー: 「フォルダーを開く」クリック
- 処理: OpenFolderAction実行
- 結果: フォルダー選択ダイアログ表示

### 4-最近使用項目選択

最近開いたフォルダー/ファイルを開く。

- トリガー: 項目クリック
- 処理: IWindowOpenable→ホストサービス
- 結果: 該当フォルダー/ファイルを開く

### 5-ウォークスルー非表示

完了したウォークスルーを非表示にする。

- トリガー: 非表示ボタンクリック
- 処理: hideCategory→設定更新
- 結果: ウォークスルーの非表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ステップ完了 | StorageService | UPDATE | 完了状態の永続化 |
| ウォークスルー非表示 | ConfigurationService | UPDATE | 非表示設定の保存 |
| 表示状態保存 | StorageService | UPDATE | 最後に表示した状態の保存 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|---------|
| MSG001 | 情報 | "Step {0} completed" | ステップ完了時 |
| MSG002 | 情報 | "Welcome to Visual Studio Code" | 初回表示時 |
| MSG003 | 情報 | "Get Started" | スタートセクションタイトル |
| MSG004 | 情報 | "Recent" | 最近使用項目セクションタイトル |

## 例外処理

| 例外 | 条件 | 対応 |
|------|------|------|
| ウォークスルー未検出 | 指定IDのウォークスルーが存在しない | フォールバック表示 |
| コマンド実行エラー | ステップコマンドの実行失敗 | エラーログ出力 |
| リソース読み込みエラー | ウォークスルーリソースの読み込み失敗 | スキップ |

## 備考

- ウォークスルーは拡張機能から追加可能
- ステップの完了状態はストレージに永続化される
- 設定「workbench.startupEditor」で起動時の表示を制御可能
- アニメーション設定で動作をカスタマイズ可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gettingStartedService.ts | `src/vs/workbench/contrib/welcomeGettingStarted/browser/gettingStartedService.ts` | IResolvedWalkthrough, IResolvedWalkthroughStepなど |
| 1-2 | gettingStartedInput.ts | `src/vs/workbench/contrib/welcomeGettingStarted/browser/gettingStartedInput.ts` | GettingStartedInput |

**読解のコツ**: ウォークスルー（IResolvedWalkthrough）とステップ（IResolvedWalkthroughStep）の関係を把握する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | gettingStarted.ts | `src/vs/workbench/contrib/welcomeGettingStarted/browser/gettingStarted.ts` | GettingStartedPageクラスがメインクラス |

**主要処理フロー**:
1. **120行目**: GettingStartedPageクラス定義 - EditorPaneを継承
2. **171-331行目**: コンストラクタ - サービス注入と初期化
3. **352-357行目**: setInput - 入力設定とレンダリング
4. **373-386行目**: applyInput - 入力適用

#### Step 3: スライド構築を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gettingStarted.ts | `src/vs/workbench/contrib/welcomeGettingStarted/browser/gettingStarted.ts` | buildCategoriesSlide, buildDetailsSlide |

**主要処理フロー**:
- buildCategoriesSlide: ウォークスルーカテゴリ一覧の構築
- buildDetailsSlide: 選択したウォークスルーの詳細表示
- scrollToCategory: カテゴリへのスクロール

#### Step 4: イベントハンドリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | gettingStarted.ts | `src/vs/workbench/contrib/welcomeGettingStarted/browser/gettingStarted.ts` | runDispatchCommand |

**主要処理フロー**:
- runDispatchCommand: ディスパッチコマンドの実行
- scrollPrev/selectCategory/selectTask等のコマンド処理

### プログラム呼び出し階層図

```
GettingStartedPage (gettingStarted.ts)
    │
    ├─ constructor()
    │      ├─ IWalkthroughsService.getWalkthroughs()
    │      └─ IWorkspacesService.getRecentlyOpened()
    │
    ├─ setInput()
    │      └─ applyInput()
    │             └─ buildCategoriesSlide()
    │                    ├─ GettingStartedIndexList (最近使用)
    │                    ├─ GettingStartedIndexList (スタートアクション)
    │                    └─ GettingStartedIndexList (ウォークスルー)
    │
    └─ runDispatchCommand()
           ├─ scrollPrev()
           ├─ selectCategory()
           │      └─ scrollToCategory()
           │             └─ buildDetailsSlide()
           ├─ selectTask()
           │      └─ selectStep()
           └─ toggleStepCompletion()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GettingStartedInput ────▶ setInput() ──────────────────▶ ウェルカムページ表示
  (selectedCategory,          │
   selectedStep)              ▼
                    applyInput()
                              │
                              ▼
                    buildCategoriesSlide()
                              │
                    ┌─────────┼─────────┐
                    ▼         ▼         ▼
              最近使用   スタート   ウォークスルー
              リスト     アクション   リスト
                              │
ユーザー選択 ─────────────────▶ │
                              ▼
                    runDispatchCommand()
                              │
                    ┌─────────┼─────────┐
                    ▼         ▼         ▼
              selectCategory selectTask openFolder
                    │         │
                    ▼         ▼
              scrollToCategory runStepCommand
                    │         │
                    ▼         ▼
              詳細表示    コマンド実行 ─────────────▶ 機能遷移
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| gettingStarted.ts | `src/vs/workbench/contrib/welcomeGettingStarted/browser/gettingStarted.ts` | ソース | ウェルカムページのメインクラス |
| gettingStartedInput.ts | `src/vs/workbench/contrib/welcomeGettingStarted/browser/gettingStartedInput.ts` | ソース | エディタ入力 |
| gettingStartedService.ts | `src/vs/workbench/contrib/welcomeGettingStarted/browser/gettingStartedService.ts` | ソース | ウォークスルーサービス |
| gettingStartedList.ts | `src/vs/workbench/contrib/welcomeGettingStarted/browser/gettingStartedList.ts` | ソース | リストウィジェット |
| gettingStartedDetailsRenderer.ts | `src/vs/workbench/contrib/welcomeGettingStarted/browser/gettingStartedDetailsRenderer.ts` | ソース | 詳細レンダラー |
| gettingStartedContent.ts | `src/vs/workbench/contrib/welcomeGettingStarted/common/gettingStartedContent.ts` | ソース | コンテンツ定義 |
| gettingStarted.css | `src/vs/workbench/contrib/welcomeGettingStarted/browser/media/gettingStarted.css` | スタイル | スタイル定義 |
