# 画面設計書 18-リリースノートエディタ

## 概要

本ドキュメントは、Visual Studio Codeのリリースノートエディタ画面の設計を記載したものである。リリースノートエディタはVSCodeの新バージョンにおける変更点や新機能を表示するための画面である。

### 本画面の処理概要

リリースノートエディタ（Release Notes Editor）は、VSCodeのバージョンアップ時に新機能や変更点を紹介する画面である。WebViewを使用してMarkdown形式のリリースノートをレンダリングし、キーバインドや設定へのリンクをインタラクティブに表示する。

**業務上の目的・背景**：
ユーザーに対してVSCodeの新しいバージョンで追加された機能、改善点、バグ修正などの情報を提供する。リリースノートを通じてユーザーが新機能を認知し、活用できるようにすることが目的。設定項目へのショートカットリンクにより、新機能をすぐに試すことができる。

**画面へのアクセス方法**：
- VSCode更新後の初回起動時（自動表示、設定による）
- コマンドパレット「リリースノートを表示」
- ヘルプ→リリースノート
- 設定「update.showReleaseNotes」がtrueの場合

**主要な操作・処理内容**：
1. リリースノートのMarkdown表示
2. キーバインドのリアルタイム表示（ユーザー設定を反映）
3. 設定項目へのインタラクティブリンク
4. 外部リンクへのナビゲーション
5. 目次（TOC）によるセクション移動
6. スクロールトップボタン

**画面遷移**：
- 入力元: 更新後自動表示、コマンドパレット、ヘルプメニュー
- 出力先: 設定エディタ、外部Webページ、関連ドキュメント

**権限による表示制御**：
- 特になし（全ユーザーに表示可能）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Markdownレンダリング | 主機能 | リリースノートの表示 |
| 2 | キーバインド表示 | 補助機能 | kb()マクロの解決と表示 |
| 3 | 設定リンク | 連携機能 | 設定項目へのインタラクティブリンク |
| 4 | 外部リンク | 連携機能 | 外部ドキュメントへのリンク |
| 5 | 目次ナビゲーション | 補助機能 | セクション間の移動 |
| 6 | トップスクロール | 補助機能 | ページ先頭への移動 |

## 画面種別

情報表示画面

## URL/ルーティング

内部ルーティング: WebViewパネルシステムによる管理
識別子: `releaseNotes`

## 入出力項目

| 項目名 | 型 | 必須 | 入力/出力 | 説明 |
|--------|-----|------|----------|------|
| version | string | 必須 | 入力 | 表示するバージョン番号 |
| useCurrentFile | boolean | 任意 | 入力 | 現在のファイルを使用するフラグ |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| リリースノート本文 | Markdown形式のコンテンツ | code.visualstudio.com/raw |
| 目次（TOC） | セクションへのリンク一覧 | Markdownヘッダーから生成 |
| キーバインド | kb()マクロを実際のキーに解決 | IKeybindingService |
| 設定リンク | 設定項目へのリンク | SimpleSettingRenderer |
| スクロールトップボタン | ページ先頭への移動ボタン | UI |

## イベント仕様

### 1-リリースノート読み込み

指定バージョンのリリースノートを取得して表示する。

- トリガー: show()メソッド呼び出し
- 処理: loadReleaseNotes→Markdownフェッチ→renderBody
- 結果: WebViewへのHTML出力

### 2-リンククリック

ドキュメント内のリンクをクリックする。

- トリガー: リンククリック
- 処理: onDidClickLink→IOpenerService
- 結果: 外部ブラウザまたは内部機能への遷移

### 3-設定リンククリック

設定項目へのリンクをクリックする。

- トリガー: 設定リンククリック
- 処理: SimpleSettingRenderer.updateSetting
- 結果: 設定の変更または設定エディタへの遷移

### 4-目次ナビゲーション

目次からセクションへ移動する。

- トリガー: TOCリンククリック
- 処理: 該当セクションへのスクロール
- 結果: ページ内スクロール

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定変更（リンク経由） | settings.json | UPDATE | 設定値の変更 |
| リリースノート表示設定 | ConfigurationService | UPDATE | 表示設定の更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|---------|
| MSG001 | 情報 | "Release Notes: {0}" | タイトル表示 |
| MSG002 | エラー | "Failed to fetch release notes" | 取得失敗時 |
| MSG003 | エラー | "Invalid release notes" | 形式エラー時 |

## 例外処理

| 例外 | 条件 | 対応 |
|------|------|------|
| ネットワークエラー | リリースノート取得失敗 | エラーメッセージ表示 |
| バージョン未検出 | 指定バージョンが存在しない | エラーメッセージ表示 |
| Markdown解析エラー | 不正な形式 | エラー処理 |

## 備考

- リリースノートはcode.visualstudio.com/rawから取得
- WebViewを使用したリッチな表示
- kb()マクロによりユーザーのキーバインド設定を反映
- テレメトリ情報を追加したリンク（GA パラメータ）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | releaseNotesEditor.ts | `src/vs/workbench/contrib/update/browser/releaseNotesEditor.ts` | ReleaseNotesManagerクラスの構造 |

**読解のコツ**: WebViewとの連携方法、Markdown処理の流れを把握する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | releaseNotesEditor.ts | `src/vs/workbench/contrib/update/browser/releaseNotesEditor.ts` | ReleaseNotesManagerクラスがメインクラス |

**主要処理フロー**:
1. **40行目**: ReleaseNotesManagerクラス定義 - Disposableを継承
2. **47-71行目**: コンストラクタ - サービス注入と初期化
3. **93-148行目**: show - リリースノートの表示
4. **150-245行目**: loadReleaseNotes - Markdownの読み込み

#### Step 3: レンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | releaseNotesEditor.ts | `src/vs/workbench/contrib/update/browser/releaseNotesEditor.ts` | renderBody, patchKeybindings |

**主要処理フロー**:
- loadReleaseNotes: リリースノート取得
- patchKeybindings: kb()マクロの解決
- renderBody: HTMLの生成

#### Step 4: イベントハンドリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | releaseNotesEditor.ts | `src/vs/workbench/contrib/update/browser/releaseNotesEditor.ts` | onDidClickLink, onMessage |

**主要処理フロー**:
- onDidClickLink: リンククリックの処理
- onMessage: WebViewからのメッセージ処理
- addGAParameters: テレメトリパラメータの追加

### プログラム呼び出し階層図

```
ReleaseNotesManager (releaseNotesEditor.ts)
    │
    ├─ constructor()
    │      ├─ TokenizationRegistry.onDidChange
    │      └─ SimpleSettingRenderer
    │
    ├─ show(version, useCurrentFile)
    │      ├─ loadReleaseNotes()
    │      │      └─ patchKeybindings()
    │      ├─ getBase()
    │      ├─ renderBody()
    │      │      └─ renderReleaseNotesMarkdown()
    │      └─ IWebviewWorkbenchService.openWebview()
    │             ├─ onDidClickLink()
    │             └─ onMessage()
    │
    └─ updateHtml()
           └─ renderBody()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

show(version) ───────────▶ loadReleaseNotes() ──────────▶ Markdownテキスト
                              │
                              ▼
                    patchKeybindings()
                              │
                              ▼
                    renderBody()
                              │
                              ▼
                    renderReleaseNotesMarkdown()
                              │
                              ▼
                    HTML生成 ────────────────────────────▶ WebView表示
                              │
リンククリック ───────────────▶ │
                              ▼
                    onDidClickLink()
                              │
                    ┌─────────┴─────────┐
                    ▼                   ▼
              設定リンク処理      外部リンク処理
                    │                   │
                    ▼                   ▼
              SimpleSettingRenderer  IOpenerService
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| releaseNotesEditor.ts | `src/vs/workbench/contrib/update/browser/releaseNotesEditor.ts` | ソース | リリースノートマネージャー |
| update.ts | `src/vs/workbench/contrib/update/common/update.ts` | ソース | 更新関連の共通定義 |
| markdownDocumentRenderer.ts | `src/vs/workbench/contrib/markdown/browser/markdownDocumentRenderer.ts` | ソース | Markdownレンダラー |
| markdownSettingRenderer.ts | `src/vs/workbench/contrib/markdown/browser/markdownSettingRenderer.ts` | ソース | 設定リンクレンダラー |
| webviewEditorInput.ts | `src/vs/workbench/contrib/webviewPanel/browser/webviewEditorInput.ts` | ソース | WebView入力 |
| webviewWorkbenchService.ts | `src/vs/workbench/contrib/webviewPanel/browser/webviewWorkbenchService.ts` | ソース | WebViewサービス |
| releasenoteseditor.css | `src/vs/workbench/contrib/update/browser/media/releasenoteseditor.css` | スタイル | スタイル定義 |
