# 画面設計書 19-プロファイルエディタ

## 概要

本ドキュメントは、Visual Studio Codeのプロファイルエディタ画面の設計を記載したものである。プロファイルエディタはVSCodeのユーザープロファイルを管理するための画面である。

### 本画面の処理概要

プロファイルエディタ（User Data Profiles Editor）は、VSCodeのユーザープロファイルを作成、編集、管理するための画面である。左側にプロファイル一覧、右側にプロファイル詳細を表示する2ペイン構成となっている。プロファイルには設定、キーバインド、拡張機能、UIステートなどを含めることができる。

**業務上の目的・背景**：
異なる作業環境（開発言語、プロジェクト、ユースケース）に応じたVSCode設定を切り替えられるようにする。例えば、Python開発用プロファイル、Web開発用プロファイル、文書作成用プロファイルなど、用途に応じた環境を素早く切り替え可能。プロファイルのエクスポート/インポートにより、設定の共有も容易。

**画面へのアクセス方法**：
- コマンドパレット「プロファイル: プロファイルを開く (UI)」
- ファイル→基本設定→プロファイル→プロファイルを開く
- 歯車アイコン→プロファイル→プロファイルを管理

**主要な操作・処理内容**：
1. 新規プロファイルの作成
2. プロファイルの編集（名前、アイコン変更）
3. プロファイル内容の選択（設定、拡張機能等の包含/除外）
4. プロファイルのエクスポート
5. プロファイルのインポート
6. プロファイルの切り替え
7. プロファイルの削除
8. テンプレートからのプロファイル作成

**画面遷移**：
- 入力元: コマンドパレット、メニュー、アクティビティバー
- 出力先: 設定エディタ、拡張機能ビュー

**権限による表示制御**：
- デフォルトプロファイルは削除・変更に制限がある
- 一部の操作はプロファイルの種類により制限される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | プロファイル作成 | 主機能 | 新規プロファイルの作成 |
| 2 | プロファイル編集 | 主機能 | 名前、アイコンの変更 |
| 3 | リソース選択 | 主機能 | 含めるリソース（設定、拡張機能等）の選択 |
| 4 | プロファイルエクスポート | 主機能 | ファイルまたはURLへのエクスポート |
| 5 | プロファイルインポート | 主機能 | ファイルまたはURLからのインポート |
| 6 | プロファイル切替 | 主機能 | アクティブプロファイルの変更 |
| 7 | プロファイル削除 | 主機能 | プロファイルの削除 |
| 8 | テンプレート使用 | 補助機能 | テンプレートからの作成 |

## 画面種別

管理画面

## URL/ルーティング

内部ルーティング: エディタタブシステムによる管理
識別子: `workbench.editor.userDataProfiles`

## 入出力項目

| 項目名 | 型 | 必須 | 入力/出力 | 説明 |
|--------|-----|------|----------|------|
| profile | IUserDataProfile | 任意 | 入力 | 選択するプロファイル |
| copyFrom | URI/IUserDataProfile | 任意 | 入力 | コピー元（インポート時） |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| プロファイルリスト | 左側のプロファイル一覧 | IUserDataProfilesService |
| プロファイル詳細 | 右側の詳細パネル | ProfileWidget |
| 新規プロファイルボタン | 作成ボタン | UI |
| リソースツリー | 含めるリソースの選択 | ProfileResourceTree |
| アクションバー | プロファイル操作ボタン | WorkbenchToolBar |

## イベント仕様

### 1-プロファイル作成

新しいプロファイルを作成する。

- トリガー: 新規プロファイルボタンクリック
- 処理: createNewProfile→NewProfileElement作成
- 結果: プロファイル編集画面の表示

### 2-プロファイル選択

プロファイルをリストから選択する。

- トリガー: リストアイテムクリック
- 処理: onDidChangeSelection→ProfileWidget.render
- 結果: プロファイル詳細の表示

### 3-プロファイルエクスポート

プロファイルをエクスポートする。

- トリガー: エクスポートアクションクリック
- 処理: IUserDataProfileImportExportService.exportProfile
- 結果: ファイル保存ダイアログまたはURL生成

### 4-プロファイルインポート

プロファイルをインポートする。

- トリガー: インポートボタンクリック
- 処理: importProfile→URLまたはファイル選択
- 結果: 新規プロファイルの作成

### 5-プロファイル切替

アクティブプロファイルを変更する。

- トリガー: プロファイルのアクティベート
- 処理: IUserDataProfileService.switchProfile
- 結果: VSCodeの設定切替

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| プロファイル作成 | profiles フォルダ | INSERT | プロファイルデータの作成 |
| プロファイル編集 | profiles フォルダ | UPDATE | プロファイルデータの更新 |
| プロファイル削除 | profiles フォルダ | DELETE | プロファイルデータの削除 |
| プロファイル切替 | StorageService | UPDATE | アクティブプロファイルの変更 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|---------|
| MSG001 | 情報 | "New Profile" | 新規作成時 |
| MSG002 | 情報 | "Active" | アクティブプロファイルの表示 |
| MSG003 | 情報 | "Profiles" | リストヘッダー |
| MSG004 | 警告 | "Profile Template URL" | インポート入力時 |

## 例外処理

| 例外 | 条件 | 対応 |
|------|------|------|
| インポートエラー | URLまたはファイル読み込み失敗 | エラーメッセージ表示 |
| 重複名エラー | 同名プロファイルが存在 | バリデーションエラー |
| 削除エラー | デフォルトプロファイルの削除試行 | 操作ブロック |

## 備考

- プロファイルは個別のフォルダーに保存される
- テンプレートURLからのインポートに対応
- Settings Syncとの連携でクラウド同期可能
- プロファイルアイコンのカスタマイズが可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | userDataProfile.ts | `src/vs/platform/userDataProfile/common/userDataProfile.ts` | IUserDataProfile, ProfileResourceTypeなど |
| 1-2 | userDataProfilesEditorModel.ts | `src/vs/workbench/contrib/userDataProfile/browser/userDataProfilesEditorModel.ts` | UserDataProfileElement, NewProfileElementなど |

**読解のコツ**: プロファイル（IUserDataProfile）とリソースタイプ（ProfileResourceType）の関係を把握する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | userDataProfilesEditor.ts | `src/vs/workbench/contrib/userDataProfile/browser/userDataProfilesEditor.ts` | UserDataProfilesEditorクラスがメインクラス |

**主要処理フロー**:
1. **98行目**: UserDataProfilesEditorクラス定義 - EditorPaneを継承
2. **110-121行目**: コンストラクタ - サービス注入
3. **131-176行目**: createEditor - 2ペインレイアウト構築
4. **183-217行目**: renderSidebar - プロファイルリスト描画

#### Step 3: プロファイルウィジェットを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | userDataProfilesEditor.ts | `src/vs/workbench/contrib/userDataProfile/browser/userDataProfilesEditor.ts` | ProfileWidgetクラス |

**主要処理フロー**:
- ProfileWidget: プロファイル詳細表示
- render: プロファイル情報のレンダリング
- リソースツリーの構築

#### Step 4: モデルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | userDataProfilesEditorModel.ts | `src/vs/workbench/contrib/userDataProfile/browser/userDataProfilesEditorModel.ts` | UserDataProfilesEditorModel |

**主要処理フロー**:
- UserDataProfilesEditorModel: プロファイルリストの管理
- AbstractUserDataProfileElement: プロファイル要素の基底クラス
- createNewProfile: 新規作成処理

### プログラム呼び出し階層図

```
UserDataProfilesEditor (userDataProfilesEditor.ts)
    │
    ├─ createEditor()
    │      ├─ renderSidebar()
    │      │      ├─ renderNewProfileButton()
    │      │      └─ WorkbenchList (profilesList)
    │      └─ ProfileWidget
    │             └─ render()
    │
    ├─ setInput()
    │      └─ UserDataProfilesEditorModel.resolve()
    │             └─ updateProfilesList()
    │
    └─ プロファイル操作
           ├─ createNewProfile()
           │      └─ model.createNewProfile()
           ├─ importProfile()
           │      └─ IUserDataProfileImportExportService
           └─ selectProfile()
                  └─ profilesList.setSelection()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

UserDataProfilesEditorInput ▶ setInput() ──────────────▶ プロファイルエディタ表示
                              │
                              ▼
                    model.resolve()
                              │
                              ▼
                    UserDataProfilesEditorModel.profiles
                              │
                    ┌─────────┴─────────┐
                    ▼                   ▼
              WorkbenchList        ProfileWidget
              (プロファイルリスト)  (詳細パネル)
                              │
ユーザー選択 ─────────────────▶ │
                              ▼
                    onDidChangeSelection()
                              │
                              ▼
                    ProfileWidget.render()
                              │
操作トリガー ─────────────────▶ │
                              ▼
                    IUserDataProfileManagementService
                              │
                              ▼
                    プロファイル更新 ──────────────────▶ リスト更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| userDataProfilesEditor.ts | `src/vs/workbench/contrib/userDataProfile/browser/userDataProfilesEditor.ts` | ソース | プロファイルエディタのメインクラス |
| userDataProfilesEditorModel.ts | `src/vs/workbench/contrib/userDataProfile/browser/userDataProfilesEditorModel.ts` | ソース | エディタモデル |
| userDataProfile.ts | `src/vs/platform/userDataProfile/common/userDataProfile.ts` | ソース | プロファイルインターフェース |
| userDataProfile.ts | `src/vs/workbench/contrib/userDataProfile/common/userDataProfile.ts` | ソース | ワークベンチプロファイル |
| userDataProfileIcons.ts | `src/vs/workbench/services/userDataProfile/common/userDataProfileIcons.ts` | ソース | プロファイルアイコン |
| iconSelectBox.ts | `src/vs/workbench/services/userDataProfile/browser/iconSelectBox.ts` | ソース | アイコン選択UI |
| userDataProfilesEditor.css | `src/vs/workbench/contrib/userDataProfile/browser/media/userDataProfilesEditor.css` | スタイル | スタイル定義 |
