# 画面設計書 20-エクスプローラービュー

## 概要

本ドキュメントは、Visual Studio Codeのエクスプローラービュー画面の設計を記載したものである。エクスプローラービューはワークスペース内のファイル・フォルダーを階層的に表示・操作するためのメインビューである。

### 本画面の処理概要

エクスプローラービュー（Explorer View）は、サイドバーに表示されるファイルツリービューである。ワークスペースのフォルダー構造を階層的に表示し、ファイルの選択、作成、削除、リネーム、移動などのファイル操作を提供する。

**業務上の目的・背景**：
開発者がプロジェクトのファイル構造を視覚的に把握し、ファイルに素早くアクセスするための中核機能。ファイル操作、検索、Gitステータスの確認などを統合的に行える。「開いているエディター」ビューも含まれており、現在開いているファイルの管理も可能。

**画面へのアクセス方法**：
- Ctrl+Shift+E（Cmd+Shift+E）ショートカット
- アクティビティバーのエクスプローラーアイコンクリック
- 表示→エクスプローラー
- コマンドパレット「エクスプローラーを表示」

**主要な操作・処理内容**：
1. フォルダー/ファイルのツリー表示
2. ファイルのダブルクリックでエディタを開く
3. 新規ファイル/フォルダーの作成
4. ファイル/フォルダーの削除
5. ファイル/フォルダーのリネーム
6. ドラッグ&ドロップによるファイル移動
7. コピー&ペースト
8. 開いているエディター一覧の表示
9. ファイルのフィルタリング

**画面遷移**：
- 入力元: アクティビティバー、メニュー、コマンドパレット
- 出力先: テキストエディタ、差分エディタ、他のビュー

**権限による表示制御**：
- ワークスペース信頼設定により一部の操作が制限される
- 読み取り専用ファイルシステムでは編集操作が無効

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | ファイルツリー表示 | 主機能 | フォルダー/ファイルの階層表示 |
| 2 | ファイルを開く | 主機能 | クリック/ダブルクリックでエディタを開く |
| 3 | 新規作成 | 主機能 | ファイル/フォルダーの新規作成 |
| 4 | 削除 | 主機能 | ファイル/フォルダーの削除 |
| 5 | リネーム | 主機能 | ファイル/フォルダー名の変更 |
| 6 | 移動（D&D） | 主機能 | ドラッグ&ドロップによる移動 |
| 7 | コピー&ペースト | 主機能 | ファイルの複製 |
| 8 | 開いているエディター | 補助機能 | 開いているファイル一覧 |
| 9 | フィルター | 補助機能 | ファイル名でのフィルタリング |
| 10 | Gitステータス表示 | 連携機能 | 変更状態のアイコン表示 |
| 11 | ファイル比較 | 連携機能 | 選択ファイルの比較 |

## 画面種別

ナビゲーションビュー

## URL/ルーティング

内部ルーティング: サイドバービューシステムによる管理
識別子: `workbench.view.explorer`

## 入出力項目

| 項目名 | 型 | 必須 | 入力/出力 | 説明 |
|--------|-----|------|----------|------|
| workspaceFolder | IWorkspaceFolder[] | 必須 | 入力 | ワークスペースフォルダー |
| selection | URI[] | 任意 | 入力/出力 | 選択中のファイル/フォルダー |
| expanded | URI[] | 任意 | 出力 | 展開中のフォルダー |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| ファイルツリー | フォルダー/ファイルの階層 | IExplorerService |
| 開いているエディター | 開いているファイル一覧 | OpenEditorsView |
| アイコン | ファイル/フォルダーのアイコン | IFileIconTheme |
| 修飾子 | Gitステータス等のバッジ | IDecorationsService |
| アクションバー | ビューアクションボタン | ViewPane |

## イベント仕様

### 1-ファイルを開く

ファイルをエディタで開く。

- トリガー: ファイルのダブルクリック、Enter押下
- 処理: IEditorService.openEditor
- 結果: ファイルがエディタで開かれる

### 2-新規ファイル作成

新しいファイルを作成する。

- トリガー: 新規ファイルボタン、右クリックメニュー
- 処理: インライン入力→IFileService.createFile
- 結果: 新規ファイルの作成とエディタで開く

### 3-新規フォルダー作成

新しいフォルダーを作成する。

- トリガー: 新規フォルダーボタン、右クリックメニュー
- 処理: インライン入力→IFileService.createFolder
- 結果: 新規フォルダーの作成

### 4-削除

ファイル/フォルダーを削除する。

- トリガー: Deleteキー、右クリックメニュー
- 処理: 確認ダイアログ→IFileService.del
- 結果: ファイル/フォルダーの削除

### 5-リネーム

ファイル/フォルダー名を変更する。

- トリガー: F2キー、右クリックメニュー
- 処理: インライン編集→IFileService.move
- 結果: 名前の変更

### 6-ドラッグ&ドロップ

ファイル/フォルダーを移動する。

- トリガー: ドラッグ&ドロップ操作
- 処理: IFileService.move/copy
- 結果: ファイル/フォルダーの移動またはコピー

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ファイル作成 | ファイルシステム | INSERT | 新規ファイルの作成 |
| フォルダー作成 | ファイルシステム | INSERT | 新規フォルダーの作成 |
| ファイル削除 | ファイルシステム | DELETE | ファイルの削除 |
| リネーム | ファイルシステム | UPDATE | ファイル名の変更 |
| 移動 | ファイルシステム | UPDATE | ファイル位置の変更 |
| 展開状態保存 | StorageService | UPDATE | ツリーの展開状態保存 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|---------|
| MSG001 | 情報 | "You have not yet opened a folder" | フォルダー未オープン時 |
| MSG002 | 確認 | "Are you sure you want to permanently delete?" | ファイル削除時 |
| MSG003 | 情報 | "Folders" | フォルダービューのタイトル |
| MSG004 | 情報 | "Explorer" | ビューコンテナタイトル |

## 例外処理

| 例外 | 条件 | 対応 |
|------|------|------|
| ファイル作成エラー | 権限不足または名前重複 | エラーメッセージ表示 |
| 削除エラー | ファイルがロック中 | エラーメッセージ表示 |
| 移動エラー | 移動先に同名ファイル | 上書き確認ダイアログ |

## 備考

- ワークスペースが開かれていない場合は空ビュー（EmptyView）を表示
- Gitステータスはデコレーションサービス経由で表示
- ファイルアイコンは現在のアイコンテーマに依存
- 大規模フォルダーは遅延読み込みで対応

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | files.ts | `src/vs/workbench/contrib/files/common/files.ts` | ExplorerRootContext, VIEW_IDなど |
| 1-2 | explorerModel.ts | `src/vs/workbench/contrib/files/common/explorerModel.ts` | ExplorerItem, ExplorerModelなど |

**読解のコツ**: ExplorerItem（ファイル/フォルダーを表すノード）の構造を把握する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | explorerViewlet.ts | `src/vs/workbench/contrib/files/browser/explorerViewlet.ts` | ExplorerViewPaneContainerがメインクラス |

**主要処理フロー**:
1. **45行目**: ExplorerViewletViewsContribution - ビュー登録
2. **155行目**: ExplorerViewPaneContainer - ビューコンテナ
3. **180-183行目**: create - コンテナの作成
4. **185-224行目**: createView - ビューの作成

#### Step 3: ファイルツリービューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | explorerView.ts | `src/vs/workbench/contrib/files/browser/views/explorerView.ts` | ExplorerViewクラス |

**主要処理フロー**:
- ExplorerView: ファイルツリーの実装
- renderBody: ツリーのレンダリング
- tree: AsyncDataTreeの使用

#### Step 4: 開いているエディターを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | openEditorsView.ts | `src/vs/workbench/contrib/files/browser/views/openEditorsView.ts` | OpenEditorsViewクラス |

**主要処理フロー**:
- OpenEditorsView: 開いているエディター一覧
- リスト表示とエディタ操作

### プログラム呼び出し階層図

```
ExplorerViewPaneContainer (explorerViewlet.ts)
    │
    ├─ create()
    │      └─ explorer-viewlet CSSクラス追加
    │
    ├─ createView()
    │      ├─ ExplorerView (VIEW_ID)
    │      │      └─ AsyncDataTree
    │      │             └─ ExplorerItem[]
    │      └─ OpenEditorsView
    │             └─ WorkbenchList
    │
    ├─ getExplorerView()
    │      └─ ExplorerView取得
    │
    └─ getOpenEditorsView()
           └─ OpenEditorsView取得
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ワークスペースフォルダー ───▶ ExplorerModel ───────────▶ ExplorerView表示
                              │
                              ▼
                    ExplorerItem[]（ツリーノード）
                              │
                              ▼
                    AsyncDataTree
                              │
                    ┌─────────┼─────────┐
                    ▼         ▼         ▼
              ファイル    フォルダー   デコレーション
              アイコン    展開/折畳   （Gitステータス等）
                              │
ユーザー操作 ─────────────────▶ │
                              ▼
                    IFileService / IExplorerService
                              │
                              ▼
                    ファイルシステム操作 ─────────────▶ ツリー更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| explorerViewlet.ts | `src/vs/workbench/contrib/files/browser/explorerViewlet.ts` | ソース | エクスプローラービューコンテナ |
| explorerView.ts | `src/vs/workbench/contrib/files/browser/views/explorerView.ts` | ソース | ファイルツリービュー |
| openEditorsView.ts | `src/vs/workbench/contrib/files/browser/views/openEditorsView.ts` | ソース | 開いているエディタービュー |
| emptyView.ts | `src/vs/workbench/contrib/files/browser/views/emptyView.ts` | ソース | 空ビュー（フォルダー未オープン時） |
| explorerModel.ts | `src/vs/workbench/contrib/files/common/explorerModel.ts` | ソース | エクスプローラーモデル |
| files.ts | `src/vs/workbench/contrib/files/common/files.ts` | ソース | 共通定義 |
| explorerService.ts | `src/vs/workbench/contrib/files/browser/explorerService.ts` | ソース | エクスプローラーサービス |
| explorerviewlet.css | `src/vs/workbench/contrib/files/browser/media/explorerviewlet.css` | スタイル | スタイル定義 |
