# 画面設計書 21-検索ビュー

## 概要

本ドキュメントは、Visual Studio Codeの検索ビュー（Search View）の画面設計を記載したものである。検索ビューは、ワークスペース全体でのテキスト検索と置換機能を提供するサイドバービューである。

### 本画面の処理概要

検索ビューは、プロジェクト全体を対象としたテキスト検索機能を提供し、開発者が効率的にコード内の文字列を検索・置換できるようにする画面である。

**業務上の目的・背景**：大規模なコードベースにおいて、特定の文字列やパターンを効率的に検索することは開発作業の生産性向上に不可欠である。ファイル単位の検索では対応できない、プロジェクト横断的な検索ニーズに応えるために本画面が存在する。正規表現、大文字小文字の区別、単語単位のマッチングなど、高度な検索オプションにより、精度の高い検索結果を得ることができる。

**画面へのアクセス方法**：
- アクティビティバーの検索アイコンをクリック
- キーボードショートカット `Ctrl+Shift+F`（Windows/Linux）または `Cmd+Shift+F`（macOS）
- コマンドパレットから「検索: ファイル内を検索」を実行

**主要な操作・処理内容**：
1. 検索テキストの入力と検索実行
2. 正規表現、大文字小文字区別、単語単位マッチングのオプション設定
3. 検索結果のツリー表示・リスト表示切り替え
4. 検索結果から該当ファイル・行への遷移
5. 一括置換機能の実行
6. 検索対象ファイルの絞り込み（包含・除外パターン設定）
7. 検索結果のコピー・エクスポート

**画面遷移**：
- 検索結果クリック → テキストエディタ（該当ファイルの該当行へ移動）
- 検索結果右クリック → 差分エディタ（置換プレビュー表示）
- 検索対象絞り込み → エクスプローラービュー（フォルダ選択時）

**権限による表示制御**：特になし。すべてのユーザーが同一機能を利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | 検索 | 主機能 | ワークスペース全体のテキスト検索 |
| 6 | 検索・置換 | 補助機能 | 検索結果から置換機能の実行 |

## 画面種別

一覧（検索結果一覧）

## URL/ルーティング

- View ID: `workbench.view.search`
- Viewlet ID: `workbench.view.search`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| 検索パターン | contentPattern | 入力 | string | 必須 | 検索する文字列またはパターン |
| 置換テキスト | replaceText | 入力 | string | 任意 | 置換後の文字列 |
| 正規表現フラグ | regex | 入力 | boolean | 任意 | 正規表現を使用するか |
| 大文字小文字区別 | caseSensitive | 入力 | boolean | 任意 | 大文字小文字を区別するか |
| 単語単位マッチ | wholeWords | 入力 | boolean | 任意 | 単語単位でマッチするか |
| 包含ファイルパターン | filePatterns | 入力 | string | 任意 | 検索対象に含めるファイルのglobパターン |
| 除外ファイルパターン | folderExclusions | 入力 | string | 任意 | 検索対象から除外するファイル/フォルダのglobパターン |
| 開いているエディタのみ | onlyOpenEditors | 入力 | boolean | 任意 | 開いているエディタのみを対象とするか |

## 表示項目

| 項目名 | 説明 | 形式 |
|--------|------|------|
| 検索結果件数 | 検索にマッチした総件数 | 数値 |
| ファイル名 | 検索結果が含まれるファイル名 | テキスト + アイコン |
| マッチ行番号 | マッチした行の番号 | 数値 |
| マッチコンテキスト | マッチした行の内容（ハイライト付き） | テキスト |
| 置換プレビュー | 置換後の内容プレビュー | テキスト |

## イベント仕様

### 1-検索実行

- トリガー: 検索入力欄でEnterキー押下、または検索ボタンクリック
- 処理:
  1. 入力された検索パターンを検証
  2. QueryBuilder経由でテキスト検索クエリを構築
  3. 検索サービスに検索リクエストを送信
  4. 検索結果をツリー構造で表示
  5. ステータスバーに検索件数を表示

### 2-置換実行

- トリガー: 置換ボタンまたは全置換ボタンクリック
- 処理:
  1. 置換テキストの検証
  2. ReplaceService経由で置換処理を実行
  3. 対象ファイルへの変更をワークスペース編集として適用
  4. 検索結果の更新

### 3-検索結果選択

- トリガー: 検索結果ツリー内の項目をクリック
- 処理:
  1. 対象ファイルをエディタで開く
  2. 該当行へカーソルを移動
  3. マッチ箇所をハイライト表示

### 4-検索詳細オプション展開

- トリガー: 「...」ボタンクリック
- 処理:
  1. 包含/除外パターン入力欄を表示
  2. 追加フィルタオプションを表示

## データベース更新仕様

### 操作別データベース影響一覧

検索ビューはデータベースへの直接的な更新は行わない。ファイル操作は以下の通り。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|-----|---------|------|
| 置換実行 | ワークスペースファイル | UPDATE | テキストファイル内の文字列置換 |

### テーブル別更新項目詳細

データベーステーブルは使用しない。代わりにファイルシステムへの書き込みを行う。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG001 | 情報 | {n}件の検索結果 | 検索完了時 |
| MSG002 | 警告 | 検索がキャンセルされました | 検索中断時 |
| MSG003 | 情報 | フォルダが開かれていません | ワークスペースが空の場合 |
| MSG004 | エラー | 無効な正規表現パターン | 正規表現構文エラー時 |

## 例外処理

| 例外状態 | 処理内容 | 表示 |
|---------|---------|------|
| ワークスペース未オープン | 検索機能を制限し、フォルダを開くよう促すメッセージを表示 | 「フォルダを開く」ボタン付きメッセージ |
| 正規表現エラー | 検索を中止し、入力欄にエラー表示 | 入力欄の枠を赤くハイライト |
| 検索タイムアウト | 部分結果を表示し、継続/中止を選択可能に | 通知バナー |
| ファイルアクセス権限エラー | 該当ファイルをスキップして検索継続 | 結果にエラー表示 |

## 備考

- 検索履歴はワークスペースストレージに保存され、セッション間で維持される
- AIによるセマンティック検索機能が実験的に利用可能（設定による有効化が必要）
- ノートブックファイル内の検索もサポート（セル単位での検索）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

検索機能のコアとなるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | searchTreeCommon.ts | `src/vs/workbench/contrib/search/browser/searchTreeModel/searchTreeCommon.ts` | ISearchResult、ISearchTreeMatch等の検索結果データ構造 |
| 1-2 | search.ts | `src/vs/workbench/services/search/common/search.ts` | ITextQuery、ISearchConfiguration等の検索クエリ構造 |

**読解のコツ**: TypeScriptのインターフェース定義を追い、各プロパティの役割を理解する。

#### Step 2: エントリーポイントを理解する

検索ビューの起点となるクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | searchView.ts | `src/vs/workbench/contrib/search/browser/searchView.ts` | SearchViewクラス - ViewPaneを継承した検索ビューの本体 |
| 2-2 | search.contribution.ts | `src/vs/workbench/contrib/search/browser/search.contribution.ts` | 検索ビューの登録処理、設定項目の定義 |

**主要処理フロー**:
1. **127行目**: `SearchView` クラス定義開始
2. **209-240行目**: コンストラクタでの依存サービス注入
3. **456行目**: `renderBody` メソッドで検索ウィジェット生成

#### Step 3: 検索ウィジェットを理解する

ユーザー入力を受け付けるウィジェット層の実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | searchWidget.ts | `src/vs/workbench/contrib/search/browser/searchWidget.ts` | 検索入力欄、置換入力欄のUIコンポーネント |
| 3-2 | patternInputWidget.ts | `src/vs/workbench/contrib/search/browser/patternInputWidget.ts` | 包含/除外パターン入力ウィジェット |

**主要処理フロー**:
- **115行目**: `SearchWidget` クラス - 検索UIの中核
- **249行目**: `focus` メソッド - フォーカス管理

#### Step 4: 検索結果表示を理解する

検索結果のレンダリング処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | searchResultsView.ts | `src/vs/workbench/contrib/search/browser/searchResultsView.ts` | 検索結果ツリーのレンダラー |
| 4-2 | searchModel.ts | `src/vs/workbench/contrib/search/browser/searchTreeModel/searchModel.ts` | 検索結果のデータモデル |

### プログラム呼び出し階層図

```
SearchView (searchView.ts)
    │
    ├─ SearchWidget (searchWidget.ts)
    │      ├─ SearchFindInput (searchFindInput.ts)
    │      └─ ReplaceInput
    │
    ├─ QueryBuilder (queryBuilder.ts)
    │      └─ ITextQuery構築
    │
    ├─ SearchViewModelWorkbenchService (searchViewModelWorkbenchService.ts)
    │      └─ SearchModel (searchModel.ts)
    │             ├─ SearchResult
    │             ├─ FolderMatch
    │             └─ FileMatch
    │
    └─ WorkbenchCompressibleAsyncDataTree
           └─ FileMatchRenderer / MatchRenderer
```

### データフロー図

```
[入力]                    [処理]                         [出力]

検索パターン入力 ───▶ SearchWidget.onSearchSubmit
                            │
                            ▼
                      QueryBuilder.text()
                            │
                            ▼
                      ISearchService.textSearch()
                            │
                            ▼
                      SearchResult.add()
                            │
                            ▼
                      ───▶ WorkbenchCompressibleAsyncDataTree ───▶ 検索結果ツリー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| searchView.ts | `src/vs/workbench/contrib/search/browser/searchView.ts` | ソース | 検索ビューの本体実装 |
| searchWidget.ts | `src/vs/workbench/contrib/search/browser/searchWidget.ts` | ソース | 検索入力ウィジェット |
| searchResultsView.ts | `src/vs/workbench/contrib/search/browser/searchResultsView.ts` | ソース | 検索結果レンダラー |
| searchModel.ts | `src/vs/workbench/contrib/search/browser/searchTreeModel/searchModel.ts` | ソース | 検索結果データモデル |
| search.contribution.ts | `src/vs/workbench/contrib/search/browser/search.contribution.ts` | ソース | 検索機能の登録・設定 |
| queryBuilder.ts | `src/vs/workbench/services/search/common/queryBuilder.ts` | ソース | 検索クエリ構築 |
| replaceService.ts | `src/vs/workbench/contrib/search/browser/replaceService.ts` | ソース | 置換処理サービス |
| searchview.css | `src/vs/workbench/contrib/search/browser/media/searchview.css` | スタイル | 検索ビューのスタイル定義 |
| constants.ts | `src/vs/workbench/contrib/search/common/constants.ts` | ソース | 検索機能の定数定義 |
