# 画面設計書 22-ソース管理ビュー

## 概要

本ドキュメントは、Visual Studio Codeのソース管理ビュー（Source Control View/SCM View）の画面設計を記載したものである。ソース管理ビューは、Git等のバージョン管理システムとの連携を提供するサイドバービューである。

### 本画面の処理概要

ソース管理ビューは、プロジェクトのバージョン管理操作を統合的に行える画面である。変更ファイルの一覧表示、ステージング、コミット、ブランチ操作など、日常的なソース管理ワークフローを効率化する。

**業務上の目的・背景**：ソフトウェア開発において、バージョン管理は必須の作業である。コマンドラインでのGit操作は習得コストが高く、視覚的なインターフェースでの操作ニーズが高い。本画面は、変更ファイルの状態を視覚的に把握し、直感的なステージング・コミット操作を可能にすることで、開発者の生産性向上に寄与する。複数リポジトリの同時管理にも対応し、モノレポや複数プロジェクト環境での開発をサポートする。

**画面へのアクセス方法**：
- アクティビティバーのソース管理アイコンをクリック
- キーボードショートカット `Ctrl+Shift+G`（Windows/Linux）または `Cmd+Shift+G`（macOS）
- コマンドパレットから「表示: ソース管理」を実行

**主要な操作・処理内容**：
1. 変更ファイルの一覧表示（変更、ステージ済み、マージコンフリクト等）
2. ファイルのステージング/アンステージング
3. コミットメッセージの入力とコミット実行
4. 変更の取り消し（Discard Changes）
5. ブランチの切り替え・作成
6. プッシュ/プル/フェッチ操作
7. 変更ファイルの差分表示
8. コミット履歴の表示

**画面遷移**：
- 変更ファイルクリック → 差分エディタ（変更前後の比較表示）
- コミット履歴選択 → テキストエディタ（該当コミットの内容表示）
- ファイル右クリック → コンテキストメニュー（各種Git操作）

**権限による表示制御**：特になし。すべてのユーザーが同一機能を利用可能。ただし、リポジトリへの書き込み権限がない場合、プッシュ等の操作は失敗する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | ソース管理 | 主機能 | 変更ファイル一覧、ステージング、コミット |
| 74 | Git統合 | 補助機能 | Gitリポジトリの操作 |

## 画面種別

一覧（変更ファイル一覧）+ 入力（コミットメッセージ）

## URL/ルーティング

- View ID: `workbench.scm`
- Pane ID: `workbench.scm`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| コミットメッセージ | commitMessage | 入力 | string | 必須（コミット時） | コミット時のメッセージ |
| 変更ファイル一覧 | changes | 出力 | ISCMResource[] | - | 変更されたファイルのリスト |
| ステージ済みファイル | staged | 出力 | ISCMResource[] | - | ステージングされたファイルのリスト |
| リポジトリ情報 | repository | 出力 | ISCMRepository | - | 現在のリポジトリ情報 |
| ブランチ名 | branch | 出力 | string | - | 現在のブランチ名 |

## 表示項目

| 項目名 | 説明 | 形式 |
|--------|------|------|
| リポジトリ名 | SCMリポジトリの名前 | テキスト |
| ブランチ名 | 現在チェックアウト中のブランチ | テキスト + アイコン |
| 変更件数バッジ | 変更ファイルの総数 | 数値バッジ |
| ファイル名 | 変更されたファイル名 | テキスト + アイコン |
| 変更状態アイコン | M(変更), A(追加), D(削除), U(マージ競合)等 | アイコン |
| コミットメッセージ入力欄 | コミットメッセージを入力するテキストエリア | マルチラインテキスト |
| アクションボタン | コミット、同期等のアクションボタン | ボタン |

## イベント仕様

### 1-ファイルステージング

- トリガー: ファイル行の「+」ボタンクリック、またはファイル右クリックから「変更をステージ」選択
- 処理:
  1. 対象ファイルをステージング
  2. ファイルを「変更」グループから「ステージ済み」グループへ移動
  3. UIの更新

### 2-コミット実行

- トリガー: コミットボタンクリック、または`Ctrl+Enter`
- 処理:
  1. コミットメッセージの検証（空でないこと）
  2. ステージ済みファイルに対してコミット実行
  3. コミット成功時、メッセージ入力欄をクリア
  4. 変更一覧の更新

### 3-ファイル差分表示

- トリガー: 変更ファイルをクリック
- 処理:
  1. 対象ファイルの変更前・変更後の内容を取得
  2. 差分エディタで表示

### 4-変更の取り消し

- トリガー: ファイル右クリックから「変更を破棄」選択
- 処理:
  1. 確認ダイアログ表示
  2. ユーザー確認後、ファイルをHEADの状態に戻す
  3. 変更一覧から削除

### 5-プッシュ/プル

- トリガー: 同期ボタンクリック、またはアクションメニューから選択
- 処理:
  1. リモートリポジトリとの同期処理
  2. プル時はマージ/リベース処理
  3. プッシュ時はコミットの送信
  4. 競合発生時はマージ画面への遷移

## データベース更新仕様

### 操作別データベース影響一覧

ソース管理ビューはデータベースへの直接的な更新は行わない。Gitリポジトリへの操作を行う。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|-----|---------|------|
| ステージング | .git/index | UPDATE | ステージングエリアへファイル追加 |
| コミット | .git/objects | INSERT | コミットオブジェクト作成 |
| プッシュ | リモートリポジトリ | UPDATE | ローカルコミットの送信 |

### テーブル別更新項目詳細

データベーステーブルは使用しない。Gitオブジェクトストアへの操作を行う。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG001 | 情報 | {n}件のコミットをプッシュしました | プッシュ成功時 |
| MSG002 | 情報 | {n}件のコミットをプルしました | プル成功時 |
| MSG003 | エラー | マージの競合が発生しました | コンフリクト発生時 |
| MSG004 | 警告 | コミットメッセージを入力してください | 空メッセージでコミット試行時 |
| MSG005 | 情報 | リポジトリがありません | Gitリポジトリ未初期化時 |

## 例外処理

| 例外状態 | 処理内容 | 表示 |
|---------|---------|------|
| リポジトリ未初期化 | 初期化を促すメッセージとボタンを表示 | 「リポジトリを初期化」ボタン |
| 認証エラー | 認証情報の再入力を促す | 認証ダイアログ |
| マージコンフリクト | コンフリクトファイルを強調表示 | 競合アイコン + マージエディタ |
| ネットワークエラー | エラーメッセージと再試行オプション | 通知バナー |

## 備考

- 複数リポジトリを同時に管理可能（モノレポ対応）
- Git以外のSCMプロバイダも拡張機能で対応可能
- コミットメッセージにはEmoji、Co-authored-by等の特殊構文をサポート
- AIによるコミットメッセージ生成機能との連携が可能（Copilot拡張機能）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

SCM機能のコアとなるインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | scm.ts | `src/vs/workbench/contrib/scm/common/scm.ts` | ISCMRepository、ISCMResource等のコアインターフェース |

**読解のコツ**: ISCMResourceGroupとISCMResourceの関係性を理解することが重要。

#### Step 2: エントリーポイントを理解する

ソース管理ビューの起点となるクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | scmViewPane.ts | `src/vs/workbench/contrib/scm/browser/scmViewPane.ts` | メインのビューペイン実装 |

**主要処理フロー**:
1. **116行目**: `TreeElement` 型定義 - リポジトリ、入力、ボタン、リソースグループ、リソース
2. **179行目**: `ActionButtonRenderer` - アクションボタンのレンダラー
3. **296行目**: `InputRenderer` - コミットメッセージ入力のレンダラー

#### Step 3: レンダラーを理解する

各UIコンポーネントのレンダリング実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | scmRepositoryRenderer.ts | `src/vs/workbench/contrib/scm/browser/scmRepositoryRenderer.ts` | リポジトリ項目のレンダラー |

**主要処理フロー**:
- RepositoryRendererクラスでリポジトリ名、ブランチ、アクション等を描画

#### Step 4: ユーティリティを理解する

ヘルパー関数とユーティリティ。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | util.ts | `src/vs/workbench/contrib/scm/browser/util.ts` | isSCMResource、isSCMRepository等の型ガード関数 |

### プログラム呼び出し階層図

```
SCMViewPane (scmViewPane.ts)
    │
    ├─ SCMInputWidget (scmViewPane.ts内)
    │      └─ CodeEditorWidget（コミットメッセージ入力）
    │
    ├─ WorkbenchCompressibleAsyncDataTree
    │      ├─ RepositoryRenderer
    │      ├─ InputRenderer
    │      ├─ ActionButtonRenderer
    │      ├─ ResourceGroupRenderer
    │      └─ ResourceRenderer
    │
    ├─ ISCMService
    │      └─ ISCMRepository[]
    │             ├─ ISCMResourceGroup（変更、ステージ済み等）
    │             │      └─ ISCMResource（個々のファイル）
    │             └─ ISCMInput（コミットメッセージ）
    │
    └─ SCMTreeDragAndDrop（ドラッグ&ドロップ処理）
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ファイル変更検知 ───▶ ISCMService.onDidChangeRepositories
                            │
                            ▼
                      SCMViewPane更新
                            │
                            ▼
                      TreeElement更新 ───▶ 変更ファイル一覧表示

コミットメッセージ入力 ───▶ ISCMInput.value
        │
        ▼
  コミットボタン押下 ───▶ ISCMRepository.commit()
        │
        ▼
  Git操作実行 ───▶ リポジトリ状態更新 ───▶ UI更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| scmViewPane.ts | `src/vs/workbench/contrib/scm/browser/scmViewPane.ts` | ソース | ソース管理ビューの本体実装 |
| scm.ts | `src/vs/workbench/contrib/scm/common/scm.ts` | ソース | SCMインターフェース定義 |
| scmRepositoryRenderer.ts | `src/vs/workbench/contrib/scm/browser/scmRepositoryRenderer.ts` | ソース | リポジトリレンダラー |
| scmViewService.ts | `src/vs/workbench/contrib/scm/browser/scmViewService.ts` | ソース | SCMビューサービス |
| util.ts | `src/vs/workbench/contrib/scm/browser/util.ts` | ソース | ユーティリティ関数 |
| scm.css | `src/vs/workbench/contrib/scm/browser/media/scm.css` | スタイル | SCMビューのスタイル |
| scmHistoryViewPane.ts | `src/vs/workbench/contrib/scm/browser/scmHistoryViewPane.ts` | ソース | 履歴ビュー |
