# 画面設計書 23-実行とデバッグビュー

## 概要

本ドキュメントは、Visual Studio Codeの実行とデバッグビュー（Run and Debug View）の画面設計を記載したものである。実行とデバッグビューは、デバッグセッションの管理と起動設定を提供するサイドバービューである。

### 本画面の処理概要

実行とデバッグビューは、プログラムのデバッグセッションを管理し、ブレークポイントの設定、変数の監視、コールスタックの確認など、デバッグに必要な情報を統合的に表示する画面である。

**業務上の目的・背景**：ソフトウェア開発において、デバッグは品質保証とバグ修正のために不可欠な作業である。本画面は、複雑なデバッグ操作を視覚的かつ直感的に行えるインターフェースを提供し、開発者がプログラムの動作を詳細に分析できるようにする。launch.json設定による柔軟なデバッグ構成、複数言語・ランタイムへの対応により、多様な開発環境をサポートする。

**画面へのアクセス方法**：
- アクティビティバーの実行とデバッグアイコンをクリック
- キーボードショートカット `Ctrl+Shift+D`（Windows/Linux）または `Cmd+Shift+D`（macOS）
- コマンドパレットから「表示: 実行とデバッグ」を実行

**主要な操作・処理内容**：
1. デバッグ構成の選択と起動
2. ブレークポイントの一覧表示と管理
3. 変数ビューでの変数値確認
4. ウォッチ式の登録と評価
5. コールスタックの表示とフレーム選択
6. デバッグコンソールでの式評価
7. ステップ実行（ステップイン、ステップオーバー、ステップアウト）
8. launch.json設定の編集

**画面遷移**：
- デバッグ開始 → デバッグコンソール（パネル表示）
- ブレークポイント選択 → テキストエディタ（該当行へ移動）
- 設定ボタン → launch.json（テキストエディタで開く）

**権限による表示制御**：特になし。すべてのユーザーが同一機能を利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | デバッグ | 主機能 | デバッグセッション管理、起動設定 |
| 65 | デバッグ | 補助機能 | 拡張機能用デバッグAPIの統合 |

## 画面種別

一覧（デバッグ情報一覧）+ 操作パネル

## URL/ルーティング

- View ID: `workbench.view.debug`
- Viewlet ID: `workbench.view.debug`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| デバッグ構成 | configuration | 入力 | ILaunch | 必須 | 使用するデバッグ構成 |
| ブレークポイント一覧 | breakpoints | 出力 | IBreakpoint[] | - | 設定されたブレークポイント |
| 変数一覧 | variables | 出力 | IVariable[] | - | 現在のスコープの変数 |
| コールスタック | callStack | 出力 | IStackFrame[] | - | コールスタック情報 |
| ウォッチ式 | watchExpressions | 入力/出力 | IExpression[] | - | 監視対象の式 |

## 表示項目

| 項目名 | 説明 | 形式 |
|--------|------|------|
| デバッグ構成ドロップダウン | 利用可能なデバッグ構成の選択 | ドロップダウン |
| 開始/停止ボタン | デバッグセッションの開始/停止 | ボタン |
| 変数セクション | スコープ別の変数一覧 | ツリービュー |
| ウォッチセクション | 登録されたウォッチ式と評価結果 | ツリービュー |
| コールスタックセクション | 現在のコールスタック | ツリービュー |
| ブレークポイントセクション | 設定されたブレークポイント一覧 | ツリービュー |

## イベント仕様

### 1-デバッグ開始

- トリガー: 開始ボタン（緑の再生ボタン）クリック、またはF5キー
- 処理:
  1. 選択されたデバッグ構成を取得
  2. デバッグアダプタの起動
  3. プログラムの実行開始
  4. デバッグツールバーの表示

### 2-ブレークポイント到達

- トリガー: プログラム実行がブレークポイントに到達
- 処理:
  1. 実行の一時停止
  2. 現在の変数、コールスタックの取得と表示
  3. エディタでブレークポイント行をハイライト

### 3-ステップ実行

- トリガー: ステップオーバー/ステップイン/ステップアウトボタン、またはF10/F11/Shift+F11
- 処理:
  1. 次の実行ポイントまで進行
  2. 変数、コールスタックの更新
  3. エディタの表示位置更新

### 4-変数値の編集

- トリガー: 変数ビューで変数をダブルクリック
- 処理:
  1. 編集用入力フィールド表示
  2. 新しい値の検証と設定
  3. 表示の更新

### 5-ウォッチ式追加

- トリガー: ウォッチセクションで「+」ボタンクリック
- 処理:
  1. 式入力フィールド表示
  2. 式の評価
  3. 結果の表示

## データベース更新仕様

### 操作別データベース影響一覧

デバッグビューはデータベースへの直接的な更新は行わない。設定ファイルへの操作を行う。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|-----|---------|------|
| デバッグ構成保存 | .vscode/launch.json | UPDATE | デバッグ構成の保存 |
| ブレークポイント保存 | ワークスペース設定 | UPDATE | ブレークポイント状態の永続化 |

### テーブル別更新項目詳細

データベーステーブルは使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG001 | 情報 | デバッグセッションを開始しました | デバッグ開始時 |
| MSG002 | 情報 | デバッグセッションが終了しました | デバッグ終了時 |
| MSG003 | エラー | デバッグアダプタの接続に失敗しました | 接続エラー時 |
| MSG004 | 警告 | ブレークポイントが無効です | 無効なブレークポイント設定時 |

## 例外処理

| 例外状態 | 処理内容 | 表示 |
|---------|---------|------|
| デバッガ未インストール | 拡張機能のインストールを促す | インストールリンク付きメッセージ |
| launch.json未設定 | 構成の自動生成を提案 | 「launch.jsonを作成」ボタン |
| デバッグアダプタエラー | エラー詳細をデバッグコンソールに表示 | エラー通知 |
| プログラムクラッシュ | クラッシュ位置とスタックトレースを表示 | デバッグコンソール |

## 備考

- Debug Adapter Protocol (DAP) に基づく拡張可能なアーキテクチャ
- 条件付きブレークポイント、ログポイント、ヒットカウントブレークポイントをサポート
- 複数のデバッグセッションを同時に実行可能（複合起動設定）
- デバッグツールバーは画面上部にフローティング表示（位置はカスタマイズ可能）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

デバッグ機能のコアとなるインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | IDebugService、IDebugSession、State等のコアインターフェース |

**読解のコツ**: State enumの各状態（Inactive、Initializing、Stopped、Running）を理解することが重要。

#### Step 2: エントリーポイントを理解する

デバッグビューレットの起点となるクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | debugViewlet.ts | `src/vs/workbench/contrib/debug/browser/debugViewlet.ts` | DebugViewPaneContainerクラス |

**主要処理フロー**:
1. **40行目**: `DebugViewPaneContainer` クラス定義開始
2. **66行目**: コンストラクタでVIEWLET_IDを使用
3. **69行目**: onDidChangeStateでデバッグ状態変更を監視
4. **127行目**: onDebugServiceStateChangeでプログレス表示制御

#### Step 3: 各サブビューを理解する

デバッグビュー内の各セクションの実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | variablesView.ts | `src/vs/workbench/contrib/debug/browser/variablesView.ts` | 変数ビューの実装 |
| 3-2 | watchExpressionsView.ts | `src/vs/workbench/contrib/debug/browser/watchExpressionsView.ts` | ウォッチビューの実装 |
| 3-3 | callStackView.ts | `src/vs/workbench/contrib/debug/browser/callStackView.ts` | コールスタックビューの実装 |
| 3-4 | breakpointsView.ts | `src/vs/workbench/contrib/debug/browser/breakpointsView.ts` | ブレークポイントビューの実装 |

### プログラム呼び出し階層図

```
DebugViewPaneContainer (debugViewlet.ts)
    │
    ├─ StartDebugActionViewItem
    │      └─ デバッグ構成選択ドロップダウン
    │
    ├─ ViewPane (各サブビュー)
    │      ├─ VariablesView
    │      ├─ WatchExpressionsView
    │      ├─ CallStackView
    │      └─ BreakpointsView
    │
    ├─ IDebugService
    │      ├─ IDebugSession
    │      │      ├─ IThread
    │      │      └─ IStackFrame
    │      └─ IDebugModel
    │             ├─ IBreakpoint
    │             └─ IExpression
    │
    └─ WelcomeView（デバッグ未設定時）
```

### データフロー図

```
[入力]                      [処理]                         [出力]

デバッグ開始 ───▶ IDebugService.startDebugging()
                        │
                        ▼
                  デバッグアダプタ起動
                        │
                        ▼
                  IDebugSession作成
                        │
                        ▼
                  ───▶ 各ビュー更新 ───▶ 変数/スタック表示

ブレークポイント ───▶ IDebugModel.addBreakpoint()
設定                    │
                        ▼
                  デバッガに送信 ───▶ 実行時に停止
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| debugViewlet.ts | `src/vs/workbench/contrib/debug/browser/debugViewlet.ts` | ソース | デバッグビューコンテナ |
| debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | ソース | デバッグインターフェース定義 |
| variablesView.ts | `src/vs/workbench/contrib/debug/browser/variablesView.ts` | ソース | 変数ビュー |
| watchExpressionsView.ts | `src/vs/workbench/contrib/debug/browser/watchExpressionsView.ts` | ソース | ウォッチビュー |
| callStackView.ts | `src/vs/workbench/contrib/debug/browser/callStackView.ts` | ソース | コールスタックビュー |
| breakpointsView.ts | `src/vs/workbench/contrib/debug/browser/breakpointsView.ts` | ソース | ブレークポイントビュー |
| debugToolBar.ts | `src/vs/workbench/contrib/debug/browser/debugToolBar.ts` | ソース | デバッグツールバー |
| repl.ts | `src/vs/workbench/contrib/debug/browser/repl.ts` | ソース | デバッグコンソール |
| debugViewlet.css | `src/vs/workbench/contrib/debug/browser/media/debugViewlet.css` | スタイル | デバッグビューのスタイル |
