# 画面設計書 24-拡張機能ビュー

## 概要

本ドキュメントは、Visual Studio Codeの拡張機能ビュー（Extensions View）の画面設計を記載したものである。拡張機能ビューは、VSCode拡張機能の検索、インストール、管理を行うサイドバービューである。

### 本画面の処理概要

拡張機能ビューは、Marketplaceからの拡張機能検索、インストール済み拡張機能の管理、更新の確認と適用を統合的に行える画面である。

**業務上の目的・背景**：VSCodeの拡張性は、開発者の生産性向上に不可欠な要素である。本画面は、数万点の拡張機能からニーズに合ったものを効率的に発見し、インストール・管理できるインターフェースを提供する。カテゴリ別検索、評価・ダウンロード数によるフィルタリング、インストール済み拡張機能の有効化/無効化管理など、拡張機能のライフサイクル全体をカバーする。

**画面へのアクセス方法**：
- アクティビティバーの拡張機能アイコンをクリック
- キーボードショートカット `Ctrl+Shift+X`（Windows/Linux）または `Cmd+Shift+X`（macOS）
- コマンドパレットから「表示: 拡張機能」を実行

**主要な操作・処理内容**：
1. Marketplaceでの拡張機能検索
2. 拡張機能のインストール/アンインストール
3. インストール済み拡張機能の有効化/無効化
4. 拡張機能の更新確認と適用
5. 拡張機能の詳細情報表示
6. 拡張機能の設定へのアクセス
7. 推奨拡張機能の表示
8. ワークスペース拡張機能の管理

**画面遷移**：
- 拡張機能選択 → 拡張機能詳細エディタ（エディタ領域に表示）
- 設定ボタン → 設定エディタ（該当拡張機能の設定セクション）
- 変更ログ → 変更ログビュー（エディタ領域）

**権限による表示制御**：
- 制限モード（Restricted Mode）では、一部の拡張機能が無効化される
- リモート環境では、ローカル/リモート拡張機能の区別表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 25 | 拡張機能管理 | 主機能 | 検索、インストール、管理 |
| 76 | カスタマイズ | 補助機能 | 拡張機能設定の変更 |

## 画面種別

一覧（拡張機能リスト）+ 検索

## URL/ルーティング

- View ID: `workbench.view.extensions`
- Viewlet ID: `workbench.view.extensions`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| 検索クエリ | query | 入力 | string | 任意 | 拡張機能の検索文字列 |
| カテゴリフィルタ | category | 入力 | string | 任意 | カテゴリによる絞り込み |
| ソート順 | sortBy | 入力 | enum | 任意 | 表示順序（人気、更新日等） |
| 拡張機能一覧 | extensions | 出力 | IExtension[] | - | 検索結果または一覧 |

## 表示項目

| 項目名 | 説明 | 形式 |
|--------|------|------|
| 検索入力欄 | 拡張機能検索用の入力フィールド | テキスト入力 |
| 拡張機能アイコン | 拡張機能のアイコン画像 | 画像 |
| 拡張機能名 | 拡張機能の表示名 | テキスト |
| 公開者名 | 拡張機能の公開者 | テキスト |
| 説明文 | 拡張機能の簡潔な説明 | テキスト |
| ダウンロード数 | インストール数 | 数値 |
| 評価 | ユーザー評価（5つ星） | 星評価 |
| インストールボタン | インストール/アンインストールボタン | ボタン |
| バージョン | 拡張機能のバージョン | テキスト |

## イベント仕様

### 1-拡張機能検索

- トリガー: 検索入力欄への入力
- 処理:
  1. 入力をデバウンス（300ms）
  2. Marketplace APIへクエリ送信
  3. 検索結果の表示
  4. 結果件数の更新

### 2-拡張機能インストール

- トリガー: インストールボタンクリック
- 処理:
  1. 拡張機能パッケージのダウンロード
  2. 拡張機能の検証と展開
  3. 拡張機能の有効化
  4. 必要に応じて再起動を促す通知

### 3-拡張機能無効化

- トリガー: コンテキストメニューから「無効にする」選択
- 処理:
  1. 拡張機能の無効化
  2. リストでの状態表示更新
  3. 再読み込みが必要な場合は通知

### 4-拡張機能更新

- トリガー: 更新ボタンクリック、または自動更新
- 処理:
  1. 新バージョンのダウンロード
  2. 旧バージョンの置換
  3. 再読み込みを促す通知

### 5-拡張機能詳細表示

- トリガー: 拡張機能リスト項目をクリック
- 処理:
  1. 拡張機能の詳細情報取得
  2. 拡張機能詳細エディタを開く
  3. README、変更履歴、依存関係等の表示

## データベース更新仕様

### 操作別データベース影響一覧

拡張機能ビューはローカルデータベースへの更新は行わないが、拡張機能のインストール状態はストレージに保存される。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|-----|---------|------|
| インストール | ~/.vscode/extensions | INSERT | 拡張機能パッケージの展開 |
| アンインストール | ~/.vscode/extensions | DELETE | 拡張機能パッケージの削除 |
| 有効化/無効化 | ユーザー設定 | UPDATE | 拡張機能状態の保存 |

### テーブル別更新項目詳細

データベーステーブルは使用しない。ファイルシステムと設定JSONへの操作を行う。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG001 | 情報 | '{name}'がインストールされました | インストール完了時 |
| MSG002 | 情報 | 再読み込みして拡張機能を有効化してください | 再読み込み必要時 |
| MSG003 | 警告 | この拡張機能は非推奨です | 非推奨拡張機能選択時 |
| MSG004 | エラー | インストールに失敗しました | インストールエラー時 |
| MSG005 | 情報 | {n}件の更新があります | 更新利用可能時 |

## 例外処理

| 例外状態 | 処理内容 | 表示 |
|---------|---------|------|
| ネットワークエラー | オフラインモードでインストール済み拡張機能のみ表示 | オフライン通知 |
| Marketplace接続失敗 | キャッシュされた結果を表示 | 接続エラーメッセージ |
| 拡張機能の競合 | 競合する拡張機能の警告表示 | 警告ダイアログ |
| ディスク容量不足 | インストール中止とエラー表示 | エラー通知 |

## 備考

- 拡張機能の自動更新は設定で制御可能
- ワークスペース推奨拡張機能は`.vscode/extensions.json`で定義
- VSIXファイルからの手動インストールも可能
- リモート開発環境では、拡張機能はホストとリモートで別々に管理される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

拡張機能管理のコアとなるインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | extensions.ts | `src/vs/workbench/contrib/extensions/common/extensions.ts` | IExtension、IExtensionsWorkbenchService等のコアインターフェース |

**読解のコツ**: VIEWLET_ID、各種コンテキストキーの定義を確認。

#### Step 2: エントリーポイントを理解する

拡張機能ビューレットの起点となるクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extensionsViewlet.ts | `src/vs/workbench/contrib/extensions/browser/extensionsViewlet.ts` | ExtensionsViewletViewsContribution、ExtensionsViewPaneContainer |

**主要処理フロー**:
1. **74行目**: ExtensionsSortByContext、SearchMarketplaceExtensionsContext等のコンテキスト定義
2. **99行目**: ExtensionsViewletViewsContribution - ビュー登録
3. **115行目**: registerViews - 各種ビューの登録

#### Step 3: 各ビューを理解する

拡張機能ビュー内の各サブビューの実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | extensionsViews.ts | `src/vs/workbench/contrib/extensions/browser/extensionsViews.ts` | ExtensionsListView、RecommendedExtensionsView等 |

**主要処理フロー**:
- ExtensionsListView - 拡張機能リストの基底クラス
- ServerInstalledExtensionsView - インストール済み拡張機能表示
- SearchMarketplaceExtensionsView - Marketplace検索結果表示

#### Step 4: アクションを理解する

拡張機能操作のアクション実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | extensionsActions.ts | `src/vs/workbench/contrib/extensions/browser/extensionsActions.ts` | InstallAction、UninstallAction等 |

### プログラム呼び出し階層図

```
ExtensionsViewPaneContainer
    │
    ├─ SuggestEnabledInput（検索入力）
    │
    ├─ ViewPane（各サブビュー）
    │      ├─ ServerInstalledExtensionsView（インストール済み）
    │      ├─ DefaultPopularExtensionsView（人気）
    │      ├─ DefaultRecommendedExtensionsView（推奨）
    │      ├─ SearchMarketplaceExtensionsView（検索結果）
    │      ├─ OutdatedExtensionsView（更新可能）
    │      ├─ EnabledExtensionsView（有効）
    │      └─ DisabledExtensionsView（無効）
    │
    ├─ IExtensionsWorkbenchService
    │      ├─ queryGallery()（Marketplace検索）
    │      ├─ queryLocal()（ローカル検索）
    │      └─ install/uninstall()
    │
    └─ IExtensionManagementService
           └─ 拡張機能のインストール/アンインストール処理
```

### データフロー図

```
[入力]                      [処理]                         [出力]

検索クエリ入力 ───▶ SuggestEnabledInput
                        │
                        ▼
                  Query.parse()
                        │
                        ▼
                  IExtensionsWorkbenchService.queryGallery()
                        │
                        ▼
                  Marketplace API呼び出し
                        │
                        ▼
                  ───▶ ExtensionsListView更新 ───▶ 拡張機能リスト表示

インストールボタン ───▶ IExtensionManagementService.installFromGallery()
        │
        ▼
  パッケージダウンロード ───▶ 展開・有効化 ───▶ UI更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extensionsViewlet.ts | `src/vs/workbench/contrib/extensions/browser/extensionsViewlet.ts` | ソース | 拡張機能ビューコンテナ |
| extensions.ts | `src/vs/workbench/contrib/extensions/common/extensions.ts` | ソース | インターフェース定義 |
| extensionsViews.ts | `src/vs/workbench/contrib/extensions/browser/extensionsViews.ts` | ソース | 各種ビュー実装 |
| extensionsActions.ts | `src/vs/workbench/contrib/extensions/browser/extensionsActions.ts` | ソース | アクション実装 |
| extensionQuery.ts | `src/vs/workbench/contrib/extensions/common/extensionQuery.ts` | ソース | クエリパーサー |
| extensionsViewlet.css | `src/vs/workbench/contrib/extensions/browser/media/extensionsViewlet.css` | スタイル | ビューのスタイル |
| extensionEditor.ts | `src/vs/workbench/contrib/extensions/browser/extensionEditor.ts` | ソース | 拡張機能詳細エディタ |
