# 画面設計書 25-テストビュー

## 概要

本ドキュメントは、Visual Studio Codeのテストビュー（Testing Explorer View）の画面設計を記載したものである。テストビューは、プロジェクト内のテストの発見、実行、結果表示を統合的に管理するサイドバービューである。

### 本画面の処理概要

テストビューは、テストフレームワーク（Jest、Mocha、pytest等）と連携し、テストの自動検出、実行、結果の可視化を提供する画面である。

**業務上の目的・背景**：テスト駆動開発（TDD）やCI/CDパイプラインの普及により、開発者がテストを頻繁に実行する機会が増加している。本画面は、IDE内でテストのライフサイクル全体を管理し、テスト結果をリアルタイムで確認できるインターフェースを提供する。継続的テスト実行（Continuous Run）機能により、コード変更時に自動でテストを実行することも可能。

**画面へのアクセス方法**：
- アクティビティバーのテストアイコンをクリック
- キーボードショートカット `Ctrl+;`（Windows/Linux）または `Cmd+;`（macOS）でテスト実行
- コマンドパレットから「テスト: テストビューにフォーカス」を実行

**主要な操作・処理内容**：
1. プロジェクト内のテストの自動検出
2. テストのツリー表示（階層構造）
3. 個別テスト/テストスイートの実行
4. すべてのテストの実行
5. テスト結果の表示（成功/失敗/スキップ）
6. 失敗テストの詳細とスタックトレース表示
7. テストの継続実行（ファイル保存時自動実行）
8. テストカバレッジの表示

**画面遷移**：
- テスト選択 → テキストエディタ（テストファイルの該当行へ移動）
- 失敗テスト選択 → テストピーク（エディタ内にインライン表示）
- カバレッジ表示 → カバレッジデコレーション（エディタ内）

**権限による表示制御**：特になし。すべてのユーザーが同一機能を利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | テスト | 主機能 | テスト検出、実行、結果表示 |
| 67 | テスト | 補助機能 | テストフレームワークとの統合 |

## 画面種別

一覧（テストツリー）+ 操作パネル

## URL/ルーティング

- View ID: `workbench.view.testing`
- View Pane ID: `workbench.view.testing`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| テストフィルタ | filter | 入力 | string | 任意 | テスト名によるフィルタリング |
| 表示モード | viewMode | 入力 | enum | 任意 | ツリー表示/リスト表示の切り替え |
| ソート順 | sortOrder | 入力 | enum | 任意 | テストの表示順序 |
| テストツリー | testTree | 出力 | TestItemTreeElement[] | - | テストの階層構造 |
| テスト結果 | testResults | 出力 | TestResultState[] | - | 各テストの実行結果 |

## 表示項目

| 項目名 | 説明 | 形式 |
|--------|------|------|
| フィルタ入力欄 | テスト名フィルタ用入力フィールド | テキスト入力 |
| 実行ボタン | すべてのテストを実行 | ボタン |
| デバッグボタン | テストをデバッグモードで実行 | ボタン |
| 継続実行トグル | 継続的テスト実行の有効化/無効化 | トグルボタン |
| テストツリー | テストスイート/テストケースの階層表示 | ツリービュー |
| 状態アイコン | テスト状態（成功/失敗/未実行等） | アイコン |
| 実行時間 | テストの実行時間 | 数値 |
| サマリー | テスト結果のサマリー（成功数/失敗数） | テキスト |

## イベント仕様

### 1-テスト検出

- トリガー: ワークスペースオープン時、ファイル変更時
- 処理:
  1. テストコントローラーへの検出要求
  2. テストファイルのスキャン
  3. テストツリーの構築
  4. UIの更新

### 2-テスト実行

- トリガー: 実行ボタンクリック、またはCtrl+; A
- 処理:
  1. 実行対象テストの特定
  2. テストランナーの起動
  3. 進捗状況のリアルタイム更新
  4. 結果の表示とステータスバー更新

### 3-テストデバッグ

- トリガー: デバッグボタンクリック、またはコンテキストメニューから選択
- 処理:
  1. デバッグ設定の生成
  2. デバッガの起動
  3. ブレークポイントでの停止
  4. デバッグビューとの連携

### 4-継続実行の有効化

- トリガー: 継続実行トグルをオン
- 処理:
  1. ファイル変更監視の開始
  2. 変更ファイルに関連するテストの特定
  3. 関連テストの自動実行

### 5-テスト結果の詳細表示

- トリガー: 失敗テストをクリック
- 処理:
  1. テストピークの表示
  2. エラーメッセージとスタックトレースの表示
  3. 期待値と実際値の差分表示

## データベース更新仕様

### 操作別データベース影響一覧

テストビューはデータベースへの直接的な更新は行わない。テスト結果はメモリ内で管理される。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|-----|---------|------|
| テスト結果保存 | テスト結果ストア | UPDATE | テスト実行結果の一時保存 |
| カバレッジ保存 | カバレッジストア | UPDATE | カバレッジ情報の一時保存 |

### テーブル別更新項目詳細

データベーステーブルは使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG001 | 情報 | {passed}件成功、{failed}件失敗 | テスト完了時 |
| MSG002 | 情報 | テストを検出中... | テスト検出中 |
| MSG003 | 警告 | テストが見つかりません | テスト未検出時 |
| MSG004 | エラー | テストの実行に失敗しました | 実行エラー時 |

## 例外処理

| 例外状態 | 処理内容 | 表示 |
|---------|---------|------|
| テストフレームワーク未インストール | 適切な拡張機能のインストールを促す | インストールリンク付きメッセージ |
| テスト検出エラー | エラー詳細を表示 | エラーアイコン付きメッセージ |
| テストタイムアウト | タイムアウト警告を表示 | 警告メッセージ |
| テストプロセスクラッシュ | クラッシュ情報を表示 | エラー通知 |

## 備考

- 複数のテストフレームワークを同時にサポート
- テスト結果はエディタ内にインラインデコレーションとして表示可能
- カバレッジ情報はエディタのガターに色分け表示
- テストタグによるフィルタリングをサポート

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テスト機能のコアとなるインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | testTypes.ts | `src/vs/workbench/contrib/testing/common/testTypes.ts` | InternalTestItem、TestResultState等のコアデータ構造 |
| 1-2 | testService.ts | `src/vs/workbench/contrib/testing/common/testService.ts` | ITestService、IMainThreadTestCollectionのインターフェース |

**読解のコツ**: TestResultState enumの各状態を理解することが重要。

#### Step 2: エントリーポイントを理解する

テストビューの起点となるクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | testingExplorerView.ts | `src/vs/workbench/contrib/testing/browser/testingExplorerView.ts` | TestingExplorerView クラス |

**主要処理フロー**:
1. **92行目**: `TestingExplorerView` クラス定義開始
2. **107行目**: コンストラクタでの依存サービス注入
3. **144行目**: shouldShowWelcome - ウェルカム画面表示条件
4. **163行目**: getTreeIncludeExclude - テスト実行対象の計算

#### Step 3: テストツリーを理解する

テストツリーの実装とレンダリング。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | testingExplorerFilter.ts | `src/vs/workbench/contrib/testing/browser/testingExplorerFilter.ts` | テストフィルタ機能 |
| 3-2 | treeProjection.ts | `src/vs/workbench/contrib/testing/browser/explorerProjections/treeProjection.ts` | ツリー投影の実装 |

### プログラム呼び出し階層図

```
TestingExplorerView (testingExplorerView.ts)
    │
    ├─ TestingExplorerFilter（フィルタ入力）
    │
    ├─ TestingExplorerViewModel
    │      ├─ TreeProjection / ListProjection
    │      └─ TestingObjectTree
    │
    ├─ ITestService
    │      ├─ IMainThreadTestCollection
    │      │      └─ InternalTestItem[]
    │      └─ runTests()
    │
    ├─ ITestResultService
    │      └─ LiveTestResult
    │
    └─ ITestingContinuousRunService
           └─ 継続実行の制御
```

### データフロー図

```
[入力]                      [処理]                         [出力]

テスト検出 ───▶ ITestService.collection
                    │
                    ▼
              TestExplorerTreeElement生成
                    │
                    ▼
              TreeProjection.getElementByTestId()
                    │
                    ▼
              ───▶ TestingObjectTree ───▶ テストツリー表示

テスト実行 ───▶ ITestService.runTests()
        │
        ▼
  テストランナー実行 ───▶ ITestResultService ───▶ 結果表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| testingExplorerView.ts | `src/vs/workbench/contrib/testing/browser/testingExplorerView.ts` | ソース | テストビュー本体 |
| testTypes.ts | `src/vs/workbench/contrib/testing/common/testTypes.ts` | ソース | テストデータ型定義 |
| testService.ts | `src/vs/workbench/contrib/testing/common/testService.ts` | ソース | テストサービスインターフェース |
| testResultService.ts | `src/vs/workbench/contrib/testing/common/testResultService.ts` | ソース | テスト結果サービス |
| testingExplorerFilter.ts | `src/vs/workbench/contrib/testing/browser/testingExplorerFilter.ts` | ソース | テストフィルタ |
| treeProjection.ts | `src/vs/workbench/contrib/testing/browser/explorerProjections/treeProjection.ts` | ソース | ツリー投影 |
| testing.css | `src/vs/workbench/contrib/testing/browser/media/testing.css` | スタイル | テストビューのスタイル |
| testingPeekOpener.ts | `src/vs/workbench/contrib/testing/common/testingPeekOpener.ts` | ソース | テストピーク表示 |
