# 画面設計書 26-タイムラインビュー

## 概要

本ドキュメントは、Visual Studio Codeのタイムラインビュー（Timeline View）の画面設計を記載したものである。タイムラインビューは、ファイルの変更履歴を時系列で表示するサイドバービューである。

### 本画面の処理概要

タイムラインビューは、アクティブなエディタのファイルに関連する履歴イベント（Git コミット、ローカル履歴、その他のプロバイダからのイベント）を時系列で表示する画面である。

**業務上の目的・背景**：ファイルの変更履歴を追跡することは、コードレビュー、バグ調査、変更理由の把握において重要である。本画面は、Git履歴とローカル編集履歴を統合的に表示し、特定のファイルがいつ、誰によって、どのように変更されたかを直感的に把握できるインターフェースを提供する。差分表示へのワンクリックアクセスにより、変更内容の詳細確認も容易。

**画面へのアクセス方法**：
- エクスプローラービュー下部の「タイムライン」セクションを展開
- コマンドパレットから「タイムライン: フォーカス」を実行

**主要な操作・処理内容**：
1. アクティブファイルの履歴表示
2. Git コミット履歴の表示
3. ローカルファイル履歴の表示
4. 履歴項目から差分表示
5. 履歴項目のフィルタリング
6. 履歴ソースの選択（Git、ローカル履歴等）
7. さらに古い履歴の読み込み

**画面遷移**：
- 履歴項目選択 → 差分エディタ（選択バージョンと現在バージョンの比較）
- 履歴項目右クリック → コンテキストメニュー（各種履歴操作）

**権限による表示制御**：特になし。すべてのユーザーが同一機能を利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 27 | タイムライン | 主機能 | ファイル履歴の表示 |
| 74 | Git統合 | 補助機能 | Gitコミット履歴の取得 |

## 画面種別

一覧（履歴一覧）

## URL/ルーティング

- View ID: `timeline`
- View Pane ID: `timeline`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| 対象ファイルURI | uri | 入力 | URI | 自動 | アクティブエディタのファイルURI |
| 除外ソース | excludedSources | 入力 | Set<string> | 任意 | 表示から除外するソース |
| タイムライン項目 | items | 出力 | TimelineItem[] | - | 履歴イベントの一覧 |

## 表示項目

| 項目名 | 説明 | 形式 |
|--------|------|------|
| 履歴項目ラベル | コミットメッセージやイベント説明 | テキスト |
| 相対時間 | 「3時間前」「昨日」等の相対表示 | テキスト |
| 履歴ソースアイコン | Git、ローカル履歴等のソース識別 | アイコン |
| 作成者 | コミット作成者名（Git履歴の場合） | テキスト |
| さらに読み込み | 追加履歴読み込みボタン | テキストリンク |

## イベント仕様

### 1-アクティブエディタ変更時

- トリガー: アクティブエディタの切り替え
- 処理:
  1. 新しいアクティブファイルのURIを取得
  2. 各タイムラインプロバイダに履歴要求
  3. 取得した履歴をマージしてソート
  4. タイムラインツリーの更新

### 2-履歴項目選択

- トリガー: タイムライン項目をクリック
- 処理:
  1. 選択された履歴バージョンの取得
  2. 差分エディタで現在バージョンとの比較表示
  3. または履歴項目に紐づくアクションの実行

### 3-さらに読み込み

- トリガー: 「Load more」リンクのクリック
- 処理:
  1. カーソル位置から追加履歴を要求
  2. 取得した履歴を既存リストに追加
  3. UIの更新

### 4-履歴ソースフィルタ

- トリガー: ビューメニューからソースの選択/解除
- 処理:
  1. 除外ソースの設定更新
  2. 表示履歴のフィルタリング
  3. UIの更新

### 5-フォローアクティブエディタ

- トリガー: 「フォローアクティブエディタ」トグル
- 処理:
  1. フォロー設定の切り替え
  2. オンの場合、エディタ変更に追従
  3. オフの場合、現在の表示を維持

## データベース更新仕様

### 操作別データベース影響一覧

タイムラインビューはデータベースへの直接的な更新は行わない。設定の永続化のみ。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|-----|---------|------|
| 除外ソース保存 | ユーザー設定 | UPDATE | フィルタ設定の永続化 |
| フォロー設定保存 | ユーザー設定 | UPDATE | フォロー状態の永続化 |

### テーブル別更新項目詳細

データベーステーブルは使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG001 | 情報 | タイムラインを読み込み中... | 履歴読み込み中 |
| MSG002 | 情報 | エディタがアクティブではありません | エディタ未選択時 |
| MSG003 | 情報 | このファイルのタイムラインはありません | 履歴がない場合 |

## 例外処理

| 例外状態 | 処理内容 | 表示 |
|---------|---------|------|
| プロバイダエラー | 該当プロバイダをスキップして他を表示 | エラーメッセージ |
| Git リポジトリ外 | Git履歴を表示せず、ローカル履歴のみ表示 | - |
| 大量履歴 | ページング表示で対応 | 「Load more」リンク |

## 備考

- 複数のタイムラインプロバイダを統合表示
- 拡張機能により独自のタイムラインプロバイダを追加可能
- ローカル履歴は自動保存により生成される
- Git履歴はリポジトリのコミットログから取得

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

タイムライン機能のコアとなるインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | timeline.ts | `src/vs/workbench/contrib/timeline/common/timeline.ts` | TimelineItem、TimelineProvider等のコアインターフェース |

**読解のコツ**: TimelineItemのプロパティ（handle、timestamp、source等）を理解する。

#### Step 2: エントリーポイントを理解する

タイムラインビューの起点となるクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | timelinePane.ts | `src/vs/workbench/contrib/timeline/browser/timelinePane.ts` | TimelinePane クラス |

**主要処理フロー**:
1. **61行目**: ItemHeight定数 - 項目の高さ
2. **91行目**: TimelineAggregate - 履歴のマージ処理
3. **233行目**: TimelineFollowActiveEditorContext - フォロー設定
4. **241行目**: TimelinePane - ビュー本体

#### Step 3: レンダラーを理解する

タイムライン項目のレンダリング実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | timelinePane.ts (内部クラス) | 同上 | TimelineTreeRenderer、TimelineIdentityProvider |

**主要処理フロー**:
- updateRelativeTime関数 - 相対時間表示の更新
- LoadMoreCommand - 「さらに読み込み」コマンド

### プログラム呼び出し階層図

```
TimelinePane (timelinePane.ts)
    │
    ├─ WorkbenchObjectTree
    │      └─ TimelineTreeRenderer
    │
    ├─ ITimelineService
    │      ├─ getTimeline()（履歴取得）
    │      └─ onDidChangeTimeline（履歴変更イベント）
    │
    ├─ TimelineAggregate
    │      └─ TimelineItem[]（マージされた履歴）
    │
    ├─ LoadMoreCommand
    │      └─ ページング制御
    │
    └─ TimelinePaneCommands
           └─ コンテキストメニューアクション
```

### データフロー図

```
[入力]                      [処理]                         [出力]

アクティブエディタ変更 ───▶ IEditorService.onDidActiveEditorChange
                                │
                                ▼
                          setUri()
                                │
                                ▼
                          ITimelineService.getTimeline()
                                │
                                ▼
                          TimelineAggregate.add()
                                │
                                ▼
                          ───▶ WorkbenchObjectTree ───▶ タイムライン表示

履歴項目クリック ───▶ onDidOpen
        │
        ▼
  コマンド実行 ───▶ 差分エディタ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| timelinePane.ts | `src/vs/workbench/contrib/timeline/browser/timelinePane.ts` | ソース | タイムラインビュー本体 |
| timeline.ts | `src/vs/workbench/contrib/timeline/common/timeline.ts` | ソース | インターフェース定義 |
| timelineService.ts | `src/vs/workbench/contrib/timeline/browser/timelineService.ts` | ソース | タイムラインサービス |
| timelinePane.css | `src/vs/workbench/contrib/timeline/browser/media/timelinePane.css` | スタイル | タイムラインのスタイル |
