# 画面設計書 27-アウトラインビュー

## 概要

本ドキュメントは、Visual Studio Codeのアウトラインビュー（Outline View）の画面設計を記載したものである。アウトラインビューは、アクティブなエディタのドキュメント構造（シンボル）をツリー形式で表示するサイドバービューである。

### 本画面の処理概要

アウトラインビューは、アクティブなエディタのファイルに含まれるシンボル（関数、クラス、変数、見出し等）を階層構造で表示し、コード内のナビゲーションを支援する画面である。

**業務上の目的・背景**：大規模なソースファイルや構造化されたドキュメントにおいて、コード構造を把握しナビゲートすることは生産性向上に不可欠である。本画面は、言語サービスが提供するシンボル情報を視覚的に表示し、クリック一つで該当箇所へジャンプできるインターフェースを提供する。フィルタリング機能により、特定のシンボルタイプのみを表示することも可能。

**画面へのアクセス方法**：
- エクスプローラービュー下部の「アウトライン」セクションを展開
- コマンドパレットから「アウトライン: フォーカス」を実行

**主要な操作・処理内容**：
1. ドキュメントシンボルの階層表示
2. シンボル選択によるエディタ内ナビゲーション
3. シンボルのフィルタリング（名前検索）
4. シンボルのソート（名前順、位置順、種類順）
5. ツリーの展開/折りたたみ
6. カーソル位置に対応するシンボルの追跡表示

**画面遷移**：
- シンボル選択 → テキストエディタ（該当シンボルの定義位置へ移動）

**権限による表示制御**：特になし。すべてのユーザーが同一機能を利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | アウトライン | 主機能 | ドキュメント構造の表示 |
| 64 | 言語サーバー | 補助機能 | シンボル情報の取得 |

## 画面種別

一覧（シンボルツリー）

## URL/ルーティング

- View ID: `outline`
- View Pane ID: `outline`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| ソート順 | sortBy | 入力 | OutlineSortOrder | 任意 | シンボルのソート順序 |
| フィルタモード | filterOnType | 入力 | boolean | 任意 | タイプフィルタの有効化 |
| カーソル追跡 | followCursor | 入力 | boolean | 任意 | カーソル位置追跡の有効化 |
| シンボルツリー | outline | 出力 | IOutline | - | ドキュメントシンボルの階層構造 |

## 表示項目

| 項目名 | 説明 | 形式 |
|--------|------|------|
| シンボルアイコン | シンボル種別を示すアイコン | アイコン |
| シンボル名 | シンボルの名前 | テキスト |
| シンボル詳細 | シンボルの追加情報（型など） | テキスト（サブ表示） |
| 展開/折りたたみ | ツリーノードの展開状態制御 | アイコン |

## イベント仕様

### 1-アクティブエディタ変更時

- トリガー: アクティブエディタの切り替え
- 処理:
  1. 新しいアクティブエディタの取得
  2. アウトラインサービスへのアウトライン要求
  3. シンボルツリーの構築と表示
  4. 前回の展開状態の復元

### 2-シンボル選択

- トリガー: アウトライン項目をクリック
- 処理:
  1. 対象シンボルの位置情報取得
  2. エディタでの該当位置への移動
  3. シンボル範囲の選択またはハイライト

### 3-ソート順変更

- トリガー: ビューメニューからソート順を選択
- 処理:
  1. ソート設定の更新
  2. ツリーの再ソート
  3. UIの更新

### 4-カーソル追跡

- トリガー: エディタでのカーソル移動
- 処理:
  1. カーソル位置に対応するシンボルを特定
  2. アウトラインツリーで該当項目を選択・表示

### 5-フィルタリング

- トリガー: キーボード入力開始（フィルタモード有効時）
- 処理:
  1. 入力文字列でシンボル名をフィルタ
  2. マッチしないシンボルを非表示
  3. マッチ箇所のハイライト

## データベース更新仕様

### 操作別データベース影響一覧

アウトラインビューはデータベースへの直接的な更新は行わない。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|-----|---------|------|
| 設定保存 | ユーザー設定 | UPDATE | ソート順、フィルタ設定の永続化 |
| ツリー状態保存 | ワークスペースストレージ | UPDATE | 展開状態のキャッシュ |

### テーブル別更新項目詳細

データベーステーブルは使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG001 | 情報 | '{filename}'のシンボルを読み込み中... | シンボル読み込み中 |
| MSG002 | 情報 | アクティブなエディタはアウトライン情報を提供できません | 非対応エディタ |
| MSG003 | 情報 | ドキュメント'{filename}'にシンボルが見つかりません | シンボルなし |

## 例外処理

| 例外状態 | 処理内容 | 表示 |
|---------|---------|------|
| 言語サービス未対応 | メッセージを表示してビューを空に | 非対応メッセージ |
| シンボル取得タイムアウト | タイムアウト後にメッセージ表示 | 読み込み中表示後メッセージ |
| エディタ未選択 | 空のビューを表示 | メッセージ |

## 備考

- 言語サービスがシンボル情報を提供する必要がある
- Markdown等のドキュメントでは見出し構造を表示
- 複数の言語拡張機能が同時にアウトライン情報を提供可能
- エディタ種別に応じて異なるアウトラインプロバイダを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アウトライン機能のコアとなるインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | outline.ts | `src/vs/workbench/contrib/outline/browser/outline.ts` | IOutlinePane、OutlineSortOrder等のインターフェース |
| 1-2 | outline.ts (service) | `src/vs/workbench/services/outline/browser/outline.ts` | IOutline、IOutlineService |

**読解のコツ**: OutlineSortOrder enumの各値（ByPosition、ByName、ByKind）を理解する。

#### Step 2: エントリーポイントを理解する

アウトラインビューの起点となるクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | outlinePane.ts | `src/vs/workbench/contrib/outline/browser/outlinePane.ts` | OutlinePane クラス |

**主要処理フロー**:
1. **40行目**: OutlineTreeSorter - ソート処理クラス
2. **58行目**: OutlinePane - ビュー本体クラス
3. **83行目**: コンストラクタでの依存サービス注入
4. **133行目**: renderBody - UI構築

#### Step 3: 状態管理を理解する

アウトラインの表示状態管理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | outlineViewState.ts | `src/vs/workbench/contrib/outline/browser/outlineViewState.ts` | OutlineViewState - 表示状態の管理 |

**主要処理フロー**:
- followCursor、filterOnType、sortBy の状態管理

### プログラム呼び出し階層図

```
OutlinePane (outlinePane.ts)
    │
    ├─ OutlineViewState（状態管理）
    │      ├─ followCursor
    │      ├─ filterOnType
    │      └─ sortBy
    │
    ├─ WorkbenchDataTree
    │      └─ OutlineTreeSorter
    │
    ├─ IOutlineService
    │      ├─ canCreateOutline()
    │      └─ createOutline()
    │             └─ IOutline
    │                    ├─ config（レンダラー設定）
    │                    ├─ isEmpty
    │                    └─ onDidChange
    │
    ├─ IEditorService
    │      └─ アクティブエディタの取得
    │
    └─ ProgressBar（読み込み進捗表示）
```

### データフロー図

```
[入力]                      [処理]                         [出力]

アクティブエディタ変更 ───▶ IEditorService.onDidActiveEditorChange
                                │
                                ▼
                          _handleEditorChanged()
                                │
                                ▼
                          IOutlineService.createOutline()
                                │
                                ▼
                          WorkbenchDataTree.setInput()
                                │
                                ▼
                          ───▶ アウトラインツリー表示

シンボルクリック ───▶ tree.onDidOpen
        │
        ▼
  IOutline.reveal() ───▶ エディタでシンボル位置へ移動
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| outlinePane.ts | `src/vs/workbench/contrib/outline/browser/outlinePane.ts` | ソース | アウトラインビュー本体 |
| outline.ts | `src/vs/workbench/contrib/outline/browser/outline.ts` | ソース | インターフェース定義 |
| outlineViewState.ts | `src/vs/workbench/contrib/outline/browser/outlineViewState.ts` | ソース | 状態管理 |
| outline.ts (service) | `src/vs/workbench/services/outline/browser/outline.ts` | ソース | アウトラインサービス |
| outlinePane.css | `src/vs/workbench/contrib/outline/browser/outlinePane.css` | スタイル | アウトラインのスタイル |
