# 画面設計書 28-ターミナルビュー

## 概要

本ドキュメントは、Visual Studio Codeのターミナルビュー（Terminal View）の画面設計を記載したものである。ターミナルビューは、統合ターミナル機能を提供するパネルビューである。

### 本画面の処理概要

ターミナルビューは、シェル（bash、PowerShell、cmd、zsh等）を統合したターミナルエミュレータを提供し、IDE内でコマンドライン操作を行える画面である。

**業務上の目的・背景**：開発作業では、ビルドコマンド、テスト実行、Git操作、パッケージマネージャなど、コマンドライン操作が頻繁に必要となる。本画面は、IDE内に統合されたターミナルを提供することで、外部ターミナルアプリケーションとの切り替え負荷を削減し、開発効率を向上させる。複数ターミナルの同時管理、プロファイル機能、シェル統合（コマンド検出）など、高度な機能を提供。

**画面へのアクセス方法**：
- メニューバーから「表示 > ターミナル」を選択
- キーボードショートカット `` Ctrl+` ``（Windows/Linux）または `` Cmd+` ``（macOS）
- コマンドパレットから「表示: ターミナルの切り替え」を実行

**主要な操作・処理内容**：
1. 新規ターミナルの作成
2. 複数ターミナルの管理（タブ/分割）
3. シェルコマンドの入力と実行
4. ターミナル出力の表示
5. テキストのコピー&ペースト
6. ターミナルのクリア
7. ターミナルプロファイルの選択
8. シェル統合機能（コマンド検出、装飾）
9. ターミナルの分割表示

**画面遷移**：
- コマンド出力のファイルパス → テキストエディタ（該当ファイルを開く）
- リンク検出 → デフォルトブラウザ（URL）またはエディタ（ファイル）

**権限による表示制御**：
- 制限モード（Restricted Mode）では、プロファイルの自動実行が制限される場合あり

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 29 | ターミナル | 主機能 | シェルセッション管理、コマンド実行 |
| 68 | ターミナル | 補助機能 | シェル統合、プロファイル |

## 画面種別

ターミナルエミュレータ

## URL/ルーティング

- View ID: `terminal`
- View Pane ID: `workbench.panel.terminal`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| コマンド入力 | command | 入力 | string | 任意 | シェルへの入力コマンド |
| ターミナルプロファイル | profile | 入力 | ITerminalProfile | 任意 | 使用するシェルプロファイル |
| ターミナル出力 | output | 出力 | string | - | シェルからの出力 |
| 終了コード | exitCode | 出力 | number | - | プロセスの終了コード |

## 表示項目

| 項目名 | 説明 | 形式 |
|--------|------|------|
| ターミナルタブ | アクティブなターミナルのリスト | タブ一覧 |
| ターミナル領域 | シェルの入出力表示領域 | ターミナルエミュレータ |
| プロファイルドロップダウン | 新規ターミナル作成時のプロファイル選択 | ドロップダウン |
| 分割ボタン | ターミナルを左右に分割 | ボタン |
| キルボタン | アクティブなターミナルを終了 | ボタン |
| コマンドデコレーション | シェル統合によるコマンドマーク | ガターアイコン |

## イベント仕様

### 1-新規ターミナル作成

- トリガー: 「+」ボタンクリック、または`Ctrl+Shift+`（バッククォート）
- 処理:
  1. デフォルトプロファイルの取得
  2. シェルプロセスの起動
  3. ターミナルインスタンスの作成
  4. タブへの追加と表示

### 2-コマンド入力

- トリガー: キーボード入力
- 処理:
  1. 入力のキャプチャ
  2. シェルプロセスへの送信
  3. 出力の受信と表示

### 3-ターミナル分割

- トリガー: 分割ボタンクリック
- 処理:
  1. 現在のターミナルグループに新規ターミナル追加
  2. レイアウトを左右分割に変更
  3. 新しいターミナルにフォーカス

### 4-ターミナル終了

- トリガー: `exit`コマンド、キルボタン、またはシェルプロセスの終了
- 処理:
  1. シェルプロセスの終了
  2. ターミナルインスタンスの破棄
  3. タブからの削除

### 5-リンク検出とアクティベート

- トリガー: Ctrl/Cmd + クリック
- 処理:
  1. クリック位置のテキストを解析
  2. URL/ファイルパスの判定
  3. 適切なアプリケーション/エディタで開く

## データベース更新仕様

### 操作別データベース影響一覧

ターミナルビューはデータベースへの直接的な更新は行わない。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|-----|---------|------|
| ターミナル状態保存 | ワークスペースストレージ | UPDATE | 再起動時のターミナル復元用 |
| 履歴保存 | シェル履歴ファイル | UPDATE | シェル固有の履歴保存 |

### テーブル別更新項目詳細

データベーステーブルは使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG001 | 情報 | ターミナルプロセスが終了しました (コード: {code}) | プロセス終了時 |
| MSG002 | 警告 | モノスペースフォントのみサポートされています | 非対応フォント設定時 |
| MSG003 | エラー | ターミナルの起動に失敗しました | 起動エラー時 |

## 例外処理

| 例外状態 | 処理内容 | 表示 |
|---------|---------|------|
| シェル未インストール | エラーメッセージと設定変更を促す | エラー通知 |
| プロセス起動失敗 | エラー詳細を表示 | ターミナル内にエラー表示 |
| 接続切断（リモート） | 再接続を試行し、失敗時はエラー表示 | 再接続通知 |
| メモリ不足 | スクロールバック削減を提案 | 警告通知 |

## 備考

- ターミナルセッションはワークスペース再起動時に復元可能（設定依存）
- シェル統合機能により、コマンドの実行状態をビジュアル表示
- GPUアクセラレーションによる高速レンダリング（設定で制御可能）
- ターミナルの出力はxterm.jsでレンダリング

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ターミナル機能のコアとなるインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | terminal.ts (common) | `src/vs/platform/terminal/common/terminal.ts` | ITerminalProfile、TerminalLocation等の共通定義 |
| 1-2 | terminal.ts (browser) | `src/vs/workbench/contrib/terminal/browser/terminal.ts` | ITerminalInstance、ITerminalService等のブラウザ固有定義 |

**読解のコツ**: ITerminalInstanceの主要メソッドとプロパティを理解することが重要。

#### Step 2: エントリーポイントを理解する

ターミナルビューの起点となるクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | terminalView.ts | `src/vs/workbench/contrib/terminal/browser/terminalView.ts` | TerminalViewPane クラス |

**主要処理フロー**:
1. **57行目**: TerminalViewPane - ビュー本体クラス
2. **74行目**: コンストラクタでの依存サービス注入
3. **144行目**: _initializeTerminal - ターミナル初期化
4. **189行目**: renderBody - UI構築

#### Step 3: タブビューを理解する

ターミナルのタブ管理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | terminalTabbedView.ts | `src/vs/workbench/contrib/terminal/browser/terminalTabbedView.ts` | タブビューの実装 |

### プログラム呼び出し階層図

```
TerminalViewPane (terminalView.ts)
    │
    ├─ TerminalTabbedView
    │      ├─ ターミナルタブの管理
    │      └─ 分割表示の制御
    │
    ├─ ITerminalService
    │      ├─ createTerminal()
    │      ├─ getInstanceHost()
    │      └─ instances[]
    │
    ├─ ITerminalGroupService
    │      ├─ groups[]
    │      └─ activeInstance
    │
    ├─ ITerminalProfileService
    │      ├─ availableProfiles
    │      └─ contributedProfiles
    │
    └─ DropdownWithPrimaryActionViewItem
           └─ プロファイル選択ドロップダウン
```

### データフロー図

```
[入力]                      [処理]                         [出力]

新規ターミナル作成 ───▶ ITerminalService.createTerminal()
                                │
                                ▼
                          ITerminalInstance作成
                                │
                                ▼
                          シェルプロセス起動
                                │
                                ▼
                          ───▶ TerminalTabbedView更新 ───▶ ターミナル表示

キー入力 ───▶ ITerminalInstance.sendText()
        │
        ▼
  シェルプロセス ───▶ 出力受信 ───▶ xterm.js描画
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| terminalView.ts | `src/vs/workbench/contrib/terminal/browser/terminalView.ts` | ソース | ターミナルビュー本体 |
| terminal.ts | `src/vs/workbench/contrib/terminal/browser/terminal.ts` | ソース | インターフェース定義 |
| terminalTabbedView.ts | `src/vs/workbench/contrib/terminal/browser/terminalTabbedView.ts` | ソース | タブビュー |
| terminalService.ts | `src/vs/workbench/contrib/terminal/browser/terminalService.ts` | ソース | ターミナルサービス |
| terminalInstance.ts | `src/vs/workbench/contrib/terminal/browser/terminalInstance.ts` | ソース | ターミナルインスタンス |
| terminalActions.ts | `src/vs/workbench/contrib/terminal/browser/terminalActions.ts` | ソース | ターミナルアクション |
| terminalContextKey.ts | `src/vs/workbench/contrib/terminal/common/terminalContextKey.ts` | ソース | コンテキストキー定義 |
