# 画面設計書 29-出力ビュー

## 概要

本ドキュメントは、Visual Studio Codeの出力ビュー（Output View）の画面設計を記載したものである。出力ビューは、拡張機能やVSCode内部プロセスからのログ出力を表示するパネルビューである。

### 本画面の処理概要

出力ビューは、VSCodeの各種サービス、拡張機能、タスク実行結果などのログ出力を統合的に表示する画面である。複数の出力チャンネルを切り替えて表示できる。

**業務上の目的・背景**：開発作業中、各種プロセスの動作状況やログを確認する必要がある。本画面は、Git操作ログ、拡張機能ログ、タスク実行ログ、言語サーバーログなど、複数のソースからの出力を一元管理し、トラブルシューティングや動作確認を支援する。ログレベルによるフィルタリング機能により、必要な情報を効率的に抽出できる。

**画面へのアクセス方法**：
- メニューバーから「表示 > 出力」を選択
- キーボードショートカット `Ctrl+Shift+U`（Windows/Linux）または `Cmd+Shift+U`（macOS）
- コマンドパレットから「表示: 出力を切り替え」を実行

**主要な操作・処理内容**：
1. 出力チャンネルの選択と表示
2. ログ出力のリアルタイム表示
3. ログレベルによるフィルタリング（Trace、Debug、Info、Warning、Error）
4. テキスト検索
5. 出力のクリア
6. スクロールロック/自動スクロール
7. 出力のコピー

**画面遷移**：
- 出力内のファイルパス → テキストエディタ（該当ファイルを開く）

**権限による表示制御**：特になし。すべてのユーザーが同一機能を利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 30 | 出力 | 主機能 | 出力チャンネル管理、ログ表示 |
| 78 | ログ | 補助機能 | ログ収集、フィルタリング |

## 画面種別

ログビューア

## URL/ルーティング

- View ID: `workbench.panel.output`
- Output View ID: `workbench.panel.output`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| チャンネル選択 | channel | 入力 | IOutputChannel | 必須 | 表示する出力チャンネル |
| フィルタテキスト | filter | 入力 | string | 任意 | ログのフィルタ文字列 |
| ログレベルフィルタ | logLevel | 入力 | LogLevel[] | 任意 | 表示するログレベル |
| 出力内容 | output | 出力 | string | - | 選択チャンネルの出力内容 |

## 表示項目

| 項目名 | 説明 | 形式 |
|--------|------|------|
| チャンネルドロップダウン | 利用可能な出力チャンネルの選択 | ドロップダウン |
| 出力領域 | ログ出力の表示領域 | テキストエディタ（読み取り専用） |
| フィルタ入力欄 | ログのフィルタリング | テキスト入力 |
| スクロールロックボタン | 自動スクロールの制御 | トグルボタン |
| クリアボタン | 出力のクリア | ボタン |
| ログレベルフィルタ | ログレベル選択ボタン | チェックボックス群 |

## イベント仕様

### 1-チャンネル切り替え

- トリガー: チャンネルドロップダウンから選択
- 処理:
  1. 選択されたチャンネルのIDを取得
  2. OutputServiceからチャンネル取得
  3. エディタへの入力設定
  4. 出力内容の表示

### 2-ログ出力追加

- トリガー: 拡張機能/サービスからの出力
- 処理:
  1. OutputServiceへのログ書き込み
  2. アクティブなチャンネルの場合、エディタへの追記
  3. スクロールロック状態に応じた自動スクロール

### 3-フィルタリング

- トリガー: フィルタ入力欄への入力、またはログレベルボタンのトグル
- 処理:
  1. フィルタ条件の適用
  2. 表示内容のフィルタリング
  3. フィルタ結果のハイライト

### 4-出力クリア

- トリガー: クリアボタンクリック
- 処理:
  1. 現在のチャンネルの出力をクリア
  2. エディタ内容のクリア

### 5-スクロールロック

- トリガー: スクロールロックボタンのトグル、または手動スクロール
- 処理:
  1. スクロールロック状態の切り替え
  2. 自動スクロール動作の有効化/無効化

## データベース更新仕様

### 操作別データベース影響一覧

出力ビューはデータベースへの直接的な更新は行わない。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|-----|---------|------|
| フィルタ設定保存 | ワークスペースストレージ | UPDATE | フィルタ設定の永続化 |

### テーブル別更新項目詳細

データベーステーブルは使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG001 | 情報 | 出力 | タイトル表示 |

## 例外処理

| 例外状態 | 処理内容 | 表示 |
|---------|---------|------|
| チャンネル未登録 | 空のビューを表示 | - |
| 大量出力 | バッファリングと間引き表示 | パフォーマンス維持 |

## 備考

- 出力チャンネルは拡張機能によって動的に追加される
- スマートスクロール機能により、ユーザーのスクロール位置を尊重
- 出力内容は読み取り専用のコードエディタで表示
- ログレベルによる色分け表示をサポート

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

出力機能のコアとなるインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | output.ts | `src/vs/workbench/services/output/common/output.ts` | IOutputChannel、IOutputService等のインターフェース |

**読解のコツ**: IOutputChannelのメソッド（append、clear、show等）を理解する。

#### Step 2: エントリーポイントを理解する

出力ビューの起点となるクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | outputView.ts | `src/vs/workbench/contrib/output/browser/outputView.ts` | OutputViewPane クラス |

**主要処理フロー**:
1. **63行目**: OutputViewPane - ビュー本体クラス
2. **76行目**: コンストラクタでの依存サービス注入
3. **115行目**: OutputEditor - 出力用エディタ
4. **146行目**: renderBody - UI構築

#### Step 3: 出力エディタを理解する

出力表示用のエディタ実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | outputView.ts (OutputEditor) | 同上 | AbstractTextResourceEditorを継承した出力エディタ |

**主要処理フロー**:
- getConfigurationOverrides - エディタ設定のオーバーライド（読み取り専用、行番号非表示等）

### プログラム呼び出し階層図

```
OutputViewPane (outputView.ts)
    │
    ├─ FilterViewPane（継承）
    │      └─ フィルタウィジェット
    │
    ├─ OutputEditor
    │      └─ AbstractTextResourceEditor（継承）
    │             └─ CodeEditorWidget
    │
    ├─ IOutputService
    │      ├─ channels[]
    │      ├─ activeChannel
    │      └─ filters（フィルタ設定）
    │
    ├─ scrollLockContextKey
    │      └─ スクロールロック状態管理
    │
    └─ Memento
           └─ フィルタ状態の永続化
```

### データフロー図

```
[入力]                      [処理]                         [出力]

チャンネル選択 ───▶ setInput()
                        │
                        ▼
                  createInput()
                        │
                        ▼
                  OutputEditor.setInput()
                        │
                        ▼
                  ───▶ CodeEditorWidget表示 ───▶ ログ出力表示

ログ追加 ───▶ IOutputChannel.append()
        │
        ▼
  モデル更新 ───▶ onDidChangeModelContent ───▶ 自動スクロール
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| outputView.ts | `src/vs/workbench/contrib/output/browser/outputView.ts` | ソース | 出力ビュー本体 |
| output.ts | `src/vs/workbench/services/output/common/output.ts` | ソース | インターフェース定義 |
| outputServices.ts | `src/vs/workbench/contrib/output/browser/outputServices.ts` | ソース | 出力サービス |
| output.css | `src/vs/workbench/contrib/output/browser/output.css` | スタイル | 出力ビューのスタイル |
| outputActions.ts | `src/vs/workbench/contrib/output/browser/outputActions.ts` | ソース | 出力アクション |
