# 画面設計書: サイドバー

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 3 |
| 画面名 | サイドバー |
| 画面パス | `src/vs/workbench/browser/parts/sidebar/sidebarPart.ts` |
| 概要 | ワークベンチの左側または右側に配置されるプライマリサイドバー。エクスプローラ、検索、ソース管理、デバッグ、拡張機能などのビューコンテナを表示する |

## 2. 画面構成

### 2.1 レイアウト概要

```
+-----------------------------------+
|     タイトル / アクション          |
+-----------------------------------+
|                                   |
|                                   |
|         ビューコンテナ             |
|         (ツリービュー等)           |
|                                   |
|                                   |
+-----------------------------------+
```

### 2.2 構成要素

| 要素名 | 説明 | 必須 | 可視性 |
|--------|------|------|--------|
| titleArea | タイトルエリア | はい | 常時 |
| titleLabel | ビューコンテナ名 | はい | 常時 |
| titleActionsContainer | アクションボタンエリア | はい | 常時 |
| content | コンテンツエリア | はい | 常時 |
| compositeBar | コンポジットバー（サイドバー上部配置時） | いいえ | 設定依存 |
| paneComposite | ビューコンテナの実体 | はい | 常時 |

## 3. 機能仕様

### 3.1 ビューコンテナ管理

- **PaneComposite**: ビューコンテナの基底クラス
- **複数ビュー**: 1つのコンテナに複数のビューを含む
- **折りたたみ**: 各ビューの折りたたみ/展開
- **ドラッグ&ドロップ**: ビューの並べ替え

### 3.2 組み込みビューコンテナ

| コンテナID | 名前 | 説明 |
|------------|------|------|
| `workbench.view.explorer` | エクスプローラ | ファイル/フォルダツリー |
| `workbench.view.search` | 検索 | 全文検索 |
| `workbench.view.scm` | ソース管理 | Git等のSCM操作 |
| `workbench.view.debug` | 実行とデバッグ | デバッグ機能 |
| `workbench.view.extensions` | 拡張機能 | 拡張機能管理 |

### 3.3 表示制御

- **位置**: 左(デフォルト)または右
- **表示/非表示**: 設定またはコマンドで切り替え
- **サイズ**: ドラッグで幅調整（最小幅制限あり）
- **フォーカス**: Ctrl+Shift+Eなどのショートカット

### 3.4 コンポジットバー

- **アクティビティバー代替**: アクティビティバーがサイドバー上部に配置される場合
- **アイコン表示**: 各ビューコンテナのアイコン
- **バッジ表示**: 通知バッジ（件数表示）

## 4. データフロー

```
[ユーザー操作: ビュー選択]
         |
         v
[PaneCompositeService.openPaneComposite()]
         |
         v
[SidebarPart.openComposite()]
         |
         v
[ビューコンテナの表示]
```

## 5. イベント

| イベント名 | トリガー | 処理内容 |
|------------|----------|----------|
| onDidPaneCompositeOpen | コンポジットが開いた | コンテナの表示処理 |
| onDidPaneCompositeClose | コンポジットが閉じた | コンテナの非表示処理 |
| onDidChangeVisibility | 表示状態変更 | レイアウト更新 |

## 6. 関連設定

| 設定キー | 説明 | デフォルト値 |
|----------|------|--------------|
| `workbench.sideBar.location` | サイドバーの位置 | `left` |
| `workbench.activityBar.location` | アクティビティバーの位置 | `default` |

## 7. コードリーディングガイド

### 7.1 読解の流れ

1. **エントリーポイント**: `sidebarPart.ts` の `SidebarPart` クラス
2. **基底クラス**: `AbstractPaneCompositePart` を継承
3. **サービス登録**: `IPaneCompositePartService` 経由でアクセス

### 7.2 プログラム呼び出し階層図

```
SidebarPart
  |
  +-- AbstractPaneCompositePart (extends)
  |     |
  |     +-- openComposite()
  |     +-- hideActiveComposite()
  |     |
  |     +-- PaneCompositeBar (optional)
  |           +-- アクティビティバー機能
  |
  +-- ViewContainerModel
  |     +-- ビューの管理
  |
  +-- PaneComposite (children)
        +-- ViewPane (multiple)
```

### 7.3 データフロー図

```
[ActivityBar/CompositeBar アイコンクリック]
         |
         v
[PaneCompositePartService.openPaneComposite]
         |
         v
[SidebarPart.openComposite]
         |
         v
[PaneComposite.setVisible(true)]
         |
         v
[ViewPane.render() for each view]
```

### 7.4 関連ファイル一覧

| ファイルパス | 説明 |
|--------------|------|
| `src/vs/workbench/browser/parts/sidebar/sidebarPart.ts` | サイドバーパーツ本体 |
| `src/vs/workbench/browser/parts/paneCompositePart.ts` | 基底クラス |
| `src/vs/workbench/browser/panecomposite.ts` | ビューコンテナ基底 |
| `src/vs/workbench/browser/parts/views/viewPane.ts` | ビューペイン |
| `src/vs/workbench/browser/parts/paneCompositeBar.ts` | コンポジットバー |
| `src/vs/workbench/services/panecomposite/browser/panecomposite.ts` | サービス定義 |

### 7.5 重要なコードスニペット

**SidebarPartクラスの構造（sidebarPart.ts）**
```typescript
export class SidebarPart extends AbstractPaneCompositePart {
  static readonly activeViewletSettingsKey = 'workbench.sidebar.activeviewletid';

  readonly minimumWidth: number = 170;
  readonly maximumWidth: number = Number.POSITIVE_INFINITY;
  readonly minimumHeight: number = 0;
  readonly maximumHeight: number = Number.POSITIVE_INFINITY;

  constructor(
    @INotificationService notificationService: INotificationService,
    @IStorageService storageService: IStorageService,
    // ... 他の依存関係
  ) {
    super(
      Parts.SIDEBAR_PART,
      { hasTitle: true, borderWidth: () => ... },
      // ...
    );
  }
}
```

**ビューコンテナの切り替え**
```typescript
async openComposite(id: string | undefined, focus?: boolean): Promise<IPaneComposite | undefined> {
  if (typeof id === 'string' && this.getComposite(id)) {
    return this.doOpenComposite(id, focus);
  }
  return undefined;
}
```

## 8. 画面遷移

### 8.1 遷移元

| 遷移元 | 条件 | 説明 |
|--------|------|------|
| アクティビティバー | アイコンクリック | ビューコンテナの切り替え |
| コマンドパレット | コマンド実行 | 表示/非表示の切り替え |
| キーボードショートカット | Ctrl+B等 | 表示/非表示の切り替え |

### 8.2 遷移先

| 遷移先 | 条件 | 説明 |
|--------|------|------|
| ファイルエディタ | ファイル選択 | エクスプローラからファイルを開く |
| 検索結果 | 検索実行 | 検索ビューでの結果表示 |

## 9. スタイリング

### 9.1 テーマカラー

| カラーID | 説明 |
|----------|------|
| `sideBar.background` | 背景色 |
| `sideBar.foreground` | 前景色 |
| `sideBar.border` | ボーダー色 |
| `sideBarTitle.foreground` | タイトル前景色 |
| `sideBarSectionHeader.background` | セクションヘッダー背景 |
| `sideBarSectionHeader.foreground` | セクションヘッダー前景 |
| `sideBarSectionHeader.border` | セクションヘッダーボーダー |

### 9.2 CSSクラス

| クラス名 | 説明 |
|----------|------|
| `.part.sidebar` | サイドバーコンテナ |
| `.composite.title` | タイトルエリア |
| `.content` | コンテンツエリア |
| `.pane-header` | ビューヘッダー |

## 10. アクセシビリティ

- **キーボードナビゲーション**: Tab/矢印キーでビュー間移動
- **フォーカス管理**: `workbench.action.focusSideBar`コマンド
- **ARIAロール**: tree, treeitemの適切な設定
- **スクリーンリーダー**: ビュー名とコンテンツの読み上げ

## 11. 拡張ポイント

### 11.1 カスタムビューコンテナ

拡張機能から`contributes.viewsContainers`でカスタムコンテナを追加可能

### 11.2 カスタムビュー

`contributes.views`でカスタムビューを追加可能

```json
{
  "contributes": {
    "views": {
      "explorer": [
        {
          "id": "myCustomView",
          "name": "My Custom View"
        }
      ]
    }
  }
}
```
