# 画面設計書 30-問題ビュー

## 概要

本ドキュメントは、Visual Studio Codeの問題ビュー（Problems View / Markers View）の画面設計を記載したものである。問題ビューは、コード内のエラー、警告、情報メッセージを一覧表示するパネルビューである。

### 本画面の処理概要

問題ビューは、リンター、コンパイラ、言語サービスなどが検出したコードの問題（エラー、警告、情報）を統合的に表示する画面である。ワークスペース全体の問題を一元管理し、効率的なコード品質改善を支援する。

**業務上の目的・背景**：コード品質の維持は、ソフトウェア開発において重要な課題である。本画面は、複数のソースからの診断情報を統合し、開発者が効率的に問題を特定・修正できるインターフェースを提供する。重大度別のフィルタリング、ファイル単位でのグルーピング、問題箇所へのワンクリックジャンプにより、大規模コードベースでも効果的な問題解決が可能。

**画面へのアクセス方法**：
- メニューバーから「表示 > 問題」を選択
- キーボードショートカット `Ctrl+Shift+M`（Windows/Linux）または `Cmd+Shift+M`（macOS）
- コマンドパレットから「表示: 問題を表示」を実行
- ステータスバーの問題カウンターをクリック

**主要な操作・処理内容**：
1. 問題の一覧表示（ファイル別グルーピング）
2. 問題の重大度別フィルタリング（エラー、警告、情報）
3. テキストによる問題の検索
4. 問題をクリックして該当箇所へジャンプ
5. クイックフィックスの適用
6. 問題のコピー
7. 表示モードの切り替え（ツリー/テーブル）
8. アクティブファイルのみの問題表示

**画面遷移**：
- 問題選択 → テキストエディタ（該当ファイルの該当行へ移動）
- クイックフィックス選択 → コード編集の適用

**権限による表示制御**：特になし。すべてのユーザーが同一機能を利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | 問題 | 主機能 | 問題一覧表示、フィルタリング |
| 79 | 診断 | 補助機能 | エラー/警告の収集、報告 |

## 画面種別

一覧（問題リスト）

## URL/ルーティング

- View ID: `workbench.panel.markers`
- Markers View ID: `workbench.panel.markers.view`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| フィルタテキスト | filter | 入力 | string | 任意 | 問題のフィルタ文字列 |
| エラー表示 | showErrors | 入力 | boolean | 任意 | エラーの表示/非表示 |
| 警告表示 | showWarnings | 入力 | boolean | 任意 | 警告の表示/非表示 |
| 情報表示 | showInfos | 入力 | boolean | 任意 | 情報の表示/非表示 |
| アクティブファイルのみ | activeFile | 入力 | boolean | 任意 | 現在のファイルのみ表示 |
| 問題一覧 | markers | 出力 | IMarker[] | - | 検出された問題のリスト |

## 表示項目

| 項目名 | 説明 | 形式 |
|--------|------|------|
| フィルタ入力欄 | 問題のテキストフィルタ | テキスト入力 |
| 重大度フィルタ | エラー/警告/情報のトグルボタン | ボタン群 |
| 問題ツリー/テーブル | 問題の一覧表示 | ツリービュー/テーブル |
| ファイル名 | 問題が存在するファイル | テキスト + アイコン |
| 問題メッセージ | 問題の説明テキスト | テキスト |
| 行番号/列番号 | 問題の位置 | 数値 |
| ソース | 問題を報告したソース（リンター名等） | テキスト |
| サマリー | 問題件数のサマリー | テキスト |

## イベント仕様

### 1-問題選択

- トリガー: 問題リスト項目をクリック
- 処理:
  1. 対象ファイルのURIと位置情報を取得
  2. エディタで該当ファイルを開く
  3. カーソルを該当位置に移動
  4. 問題箇所をハイライト表示

### 2-フィルタリング

- トリガー: フィルタ入力、または重大度ボタンのトグル
- 処理:
  1. フィルタ条件の適用
  2. 表示問題のフィルタリング
  3. フィルタ結果のハイライト
  4. サマリーの更新

### 3-クイックフィックス

- トリガー: 問題項目を右クリック → クイックフィックス選択
- 処理:
  1. 利用可能なクイックフィックスの取得
  2. コンテキストメニューに表示
  3. 選択されたフィックスの適用

### 4-問題のコピー

- トリガー: コンテキストメニューから「コピー」選択
- 処理:
  1. 選択された問題の情報を整形
  2. クリップボードにコピー

### 5-表示モード切り替え

- トリガー: ビューメニューからモード選択
- 処理:
  1. 表示モードの切り替え（ツリー/テーブル）
  2. UIコンポーネントの切り替え
  3. データの再表示

## データベース更新仕様

### 操作別データベース影響一覧

問題ビューはデータベースへの直接的な更新は行わない。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|-----|---------|------|
| フィルタ設定保存 | ワークスペースストレージ | UPDATE | フィルタ設定の永続化 |
| 表示モード保存 | ワークスペースストレージ | UPDATE | ビューモードの永続化 |

### テーブル別更新項目詳細

データベーステーブルは使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG001 | 情報 | 問題は検出されませんでした | 問題ゼロの場合 |
| MSG002 | 情報 | フィルタに一致する問題はありません | フィルタ結果ゼロの場合 |

## 例外処理

| 例外状態 | 処理内容 | 表示 |
|---------|---------|------|
| 大量の問題 | バッチ処理とバーチャルスクロール | パフォーマンス維持 |
| 問題ソースの削除 | 関連問題の自動削除 | リアルタイム更新 |

## 備考

- 問題はIMarkerServiceにより集約される
- 言語サービス、リンター、コンパイラなど複数のソースからの問題を統合
- ファイル保存やコード変更に応じてリアルタイムで更新
- ステータスバーに問題件数のサマリーを表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

問題管理のコアとなるインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | markers.ts | `src/vs/platform/markers/common/markers.ts` | IMarker、MarkerSeverity等のコアインターフェース |
| 1-2 | markers.ts (contrib) | `src/vs/workbench/contrib/markers/common/markers.ts` | MarkersContextKeys等のコンテキスト定義 |

**読解のコツ**: MarkerSeverityの各レベル（Error、Warning、Info、Hint）を理解する。

#### Step 2: エントリーポイントを理解する

問題ビューの起点となるクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | markersView.ts | `src/vs/workbench/contrib/markers/browser/markersView.ts` | MarkersView クラス |

**主要処理フロー**:
1. **109行目**: MarkersView - ビュー本体クラス
2. **140行目**: コンストラクタでの依存サービス注入
3. **220行目**: renderBody - UI構築
4. **300行目**: openFileAtElement - 問題箇所へのジャンプ

#### Step 3: データモデルを理解する

問題データのモデル実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | markersModel.ts | `src/vs/workbench/contrib/markers/browser/markersModel.ts` | MarkersModel、Marker、ResourceMarkers |

**主要処理フロー**:
- MarkersModel - 問題データの集約とイベント管理
- Marker - 個々の問題のラッパー
- ResourceMarkers - ファイル単位の問題グループ

### プログラム呼び出し階層図

```
MarkersView (markersView.ts)
    │
    ├─ FilterViewPane（継承）
    │      └─ MarkersFilters（フィルタ状態管理）
    │
    ├─ IProblemsWidget
    │      ├─ WorkbenchObjectTree（ツリービュー）
    │      └─ MarkersTable（テーブルビュー）
    │
    ├─ MarkersModel
    │      ├─ ResourceMarkers[]（ファイル別グループ）
    │      │      └─ Marker[]（問題）
    │      └─ onDidChange（変更イベント）
    │
    ├─ IMarkerService
    │      └─ read()（問題の取得）
    │
    └─ RangeHighlightDecorations
           └─ 問題箇所のハイライト
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ファイル診断 ───▶ IMarkerService.changeOne()
                        │
                        ▼
                  MarkersModel更新
                        │
                        ▼
                  IProblemsWidget.filterMarkers()
                        │
                        ▼
                  ───▶ ツリー/テーブル表示 ───▶ 問題一覧表示

問題クリック ───▶ openFileAtElement()
        │
        ▼
  IEditorService.openEditor() ───▶ エディタで問題箇所表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| markersView.ts | `src/vs/workbench/contrib/markers/browser/markersView.ts` | ソース | 問題ビュー本体 |
| markers.ts | `src/vs/platform/markers/common/markers.ts` | ソース | マーカーインターフェース |
| markersModel.ts | `src/vs/workbench/contrib/markers/browser/markersModel.ts` | ソース | 問題データモデル |
| markersTreeViewer.ts | `src/vs/workbench/contrib/markers/browser/markersTreeViewer.ts` | ソース | ツリービューアー |
| markersTable.ts | `src/vs/workbench/contrib/markers/browser/markersTable.ts` | ソース | テーブルビュー |
| markersViewActions.ts | `src/vs/workbench/contrib/markers/browser/markersViewActions.ts` | ソース | ビューアクション |
| markers.css | `src/vs/workbench/contrib/markers/browser/media/markers.css` | スタイル | 問題ビューのスタイル |
