# 画面設計書 31-デバッグコンソール

## 概要

本ドキュメントは、VS Codeのデバッグコンソール（Debug Console / REPL）画面の設計仕様を定義する。デバッグセッション中にプログラムとの対話、式の評価、変数の表示を行うためのインタラクティブなコンソールインターフェースである。

### 本画面の処理概要

デバッグコンソールは、開発者がデバッグセッション中にリアルタイムで式を評価し、プログラムの状態を調査するためのREPL（Read-Eval-Print Loop）環境を提供する。

**業務上の目的・背景**：デバッグ作業において、ブレークポイントで停止した際にプログラムの状態を詳細に調査する必要がある。変数の値を確認するだけでなく、任意の式を評価したり、オブジェクトのプロパティを探索したりすることで、バグの原因を特定し修正するための重要な情報を得ることができる。従来のprint文デバッグに比べ、コード変更なしでリアルタイムに値を確認できるため、デバッグ効率が大幅に向上する。

**画面へのアクセス方法**：
- メニュー「表示」→「デバッグコンソール」
- キーボードショートカット（Ctrl+Shift+Y / Cmd+Shift+Y）
- パネル領域のタブから「デバッグコンソール」を選択
- デバッグセッション開始時に自動的に表示

**主要な操作・処理内容**：
1. 式の入力と評価：入力欄に任意の式を入力しEnterで評価結果を表示
2. 履歴ナビゲーション：上下キーで過去の入力履歴を呼び出し
3. 出力のフィルタリング：フィルタ入力欄でログ出力をテキストフィルタ
4. 出力のコピー：コンテキストメニューからコピー、全コピー操作
5. コンソールのクリア：ツールバーボタンまたはキーボードショートカットでクリア
6. セッション切替：複数デバッグセッション時にセッションを選択
7. 検索：コンソール出力内をテキスト検索
8. 変数の展開：評価結果のオブジェクトをツリー形式で展開表示

**画面遷移**：
- 遷移元：デバッグビュー、パネル、メニュー、コマンドパレット
- 遷移先：ソースコードエディタ（出力内のソース参照リンクをクリック時）

**権限による表示制御**：デバッグセッションが非アクティブの場合、入力欄は読み取り専用となり「Please start a debug session to evaluate expressions」のプレースホルダが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | デバッグ | 主機能 | デバッグ時のREPLコンソール、式評価、変数表示 |
| 65 | デバッグ拡張API | API連携 | Debug Adapter Protocolを通じた式評価 |

## 画面種別

インタラクティブコンソール / REPLビュー

## URL/ルーティング

- ビューID: `workbench.panel.repl.view`
- URI: `debug:replinput`（入力モデル用）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| 式入力 | 入力 | string | - | 評価する式をテキスト入力 |
| フィルタ入力 | 入力 | string | - | 出力をフィルタするテキスト |
| 評価結果 | 出力 | any | - | 式評価の結果（プリミティブ、オブジェクト、エラー） |
| プログラム出力 | 出力 | string | - | console.log等のプログラム出力 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 評価入力 | ReplEvaluationInput | ユーザーが入力した式（>マーク付き） |
| 評価結果 | ReplEvaluationResult | 式評価の結果値 |
| 出力要素 | ReplOutputElement | プログラムからの出力（ログ、警告、エラー） |
| 変数 | ReplVariableElement | 展開可能な変数・オブジェクト |
| グループ | ReplGroup | 折りたたみ可能な出力グループ |
| Raw Object | RawObjectReplElement | 名前付きの生オブジェクト |
| ソース参照 | IReplElementSource | 出力元のソースコード位置 |
| 出力カウント | number | 同一出力の繰り返し回数バッジ |

## イベント仕様

### 1-式評価（Enter押下）

1. ユーザーが入力欄に式を入力
2. Enterキー押下でAcceptReplInputActionがトリガー
3. セッションのaddReplExpressionメソッドを呼び出し
4. Debug Adapter経由で式を評価
5. 結果をツリーに追加し、最下部にスクロール
6. 入力履歴に追加
7. 入力欄をクリア

### 2-履歴ナビゲーション（上下キー）

1. 上キー押下でshowPreviousValue実行
2. HistoryNavigatorから前の入力を取得
3. 入力欄に値を設定
4. カーソルを末尾に移動

### 3-コンソールクリア

1. クリアボタン押下またはCmd+K
2. clearReplメソッド実行
3. セッションのremoveReplExpressionsを呼び出し
4. 非アクティブセッションはsessionsToIgnoreに追加
5. 入力欄にフォーカス

### 4-フィルタリング

1. フィルタ入力欄にテキスト入力
2. ReplFilter.filterQueryを更新
3. ツリーをrefilter
4. 最下部にスクロール
5. フィルタバッジに件数表示

### 5-セッション切替

1. セッションドロップダウンから選択
2. selectSessionメソッド実行
3. replElementsChangeListenerを更新
4. ツリーの入力を新セッションに切替
5. 補完プロバイダを再登録

## データベース更新仕様

### 操作別データベース影響一覧

本画面はストレージに以下のキーで状態を保存する。

| 操作（イベント） | 対象キー | 操作種別 | 概要 |
|----------------|---------|---------|------|
| 式評価 | debug.repl.history | UPDATE | 入力履歴を保存（最大100件） |
| フィルタ変更 | debug.repl.filterHistory | UPDATE | フィルタ履歴を保存 |
| フィルタ変更 | debug.repl.filterValue | UPDATE | 現在のフィルタ値を保存 |

### テーブル別更新項目詳細

#### WorkspaceStorage（StorageScope.WORKSPACE）

| 操作 | キー | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | debug.repl.history | JSON配列（最大100件の入力文字列） | saveState時に保存 |
| UPDATE | debug.repl.filterHistory | JSON配列（フィルタ履歴） | saveState時に保存 |
| UPDATE | debug.repl.filterValue | 文字列（現在のフィルタテキスト） | saveState時に保存 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| startDebugFirst | 情報 | デバッグ非アクティブ時に入力欄フォーカス | Please start a debug session to evaluate expressions |
| showingFilteredLines | 情報 | フィルタ適用時 | Showing {0} of {1} |
| debugConsole | ラベル | アクセシビリティ | Debug Console |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| デバッグセッション非アクティブ | 入力欄を読み取り専用に設定、プレースホルダ表示 |
| 式評価エラー | エラーメッセージを赤色で出力に表示 |
| ツリー入力設定エラー | エラーをログに記録し、処理を継続 |

## 備考

- ANSIエスケープシーケンスの色付き出力をサポート
- ワードラップ設定（debug.console.wordWrap）による折り返し制御
- フォントサイズ、フォントファミリー、行の高さはdebug.console設定で制御
- サジェスション機能は補完をサポートするデバッガでのみ有効

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

デバッグコンソールのデータモデルと要素の種類を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | IReplElement, IReplOptions, IDebugSession等のインターフェース定義 |
| 1-2 | replModel.ts | `src/vs/workbench/contrib/debug/common/replModel.ts` | ReplEvaluationInput, ReplEvaluationResult, ReplOutputElement, ReplGroupなどのREPL要素クラス |

**読解のコツ**: IReplElementインターフェースが全てのREPL要素の基底となる。各要素タイプ（評価入力、評価結果、出力、グループ等）がどのように継承・実装されているかを追う。

#### Step 2: エントリーポイントを理解する

REPLビューの中核となるクラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repl.ts | `src/vs/workbench/contrib/debug/browser/repl.ts` | Replクラス（FilterViewPaneを継承） |

**主要処理フロー**:
1. **97行目**: `class Repl extends FilterViewPane` - FilterViewPaneを継承したREPLビュークラス
2. **127-170行目**: コンストラクタでの初期化、履歴、フィルタ、メニューの設定
3. **172-255行目**: `registerListeners` - セッション変更、テーマ変更等のイベントリスナー登録
4. **478-489行目**: `acceptReplInput` - 式評価の実行
5. **644-650行目**: `renderBody` - UI構築のエントリーポイント

#### Step 3: ツリービューのレンダリングを理解する

出力要素のレンダリング処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | replViewer.ts | `src/vs/workbench/contrib/debug/browser/replViewer.ts` | 各種レンダラークラス（ReplEvaluationInputsRenderer, ReplGroupRenderer等） |

**主要処理フロー**:
- **70-92行目**: ReplEvaluationInputsRenderer - 入力式のレンダリング
- **94-127行目**: ReplGroupRenderer - グループ要素のレンダリング
- **129-160行目**: ReplEvaluationResultsRenderer - 評価結果のレンダリング
- **162-229行目**: ReplOutputElementRenderer - 出力要素のレンダリング
- **231-270行目**: ReplVariablesRenderer - 変数要素のレンダリング

#### Step 4: 入力処理とコード補完を理解する

式入力と補完機能の処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | repl.ts | `src/vs/workbench/contrib/debug/browser/repl.ts` | createReplInputメソッド、補完プロバイダ登録 |

**主要処理フロー**:
- **724-764行目**: `createReplInput` - CodeEditorWidgetの作成と設定
- **261-323行目**: `onDidFocusSession`内の補完プロバイダ登録
- **911-931行目**: AcceptReplInputAction - Enterキー処理

#### Step 5: アクションとコマンドを理解する

デバッグコンソールで使用可能なアクション群を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | repl.ts | `src/vs/workbench/contrib/debug/browser/repl.ts` | 各種Action2/EditorAction登録 |

**主要処理フロー**:
- **911-931行目**: AcceptReplInputAction - 入力確定
- **933-952行目**: FilterReplAction - フィルタへフォーカス
- **955-985行目**: FindReplAction - 検索機能
- **987-1005行目**: ReplCopyAllAction - 全コピー
- **1059-1096行目**: clearReplAction - コンソールクリア

### プログラム呼び出し階層図

```
Repl (FilterViewPane)
    │
    ├─ renderBody()
    │      ├─ createReplInput() → CodeEditorWidget
    │      └─ createReplTree() → WorkbenchAsyncDataTree
    │             ├─ ReplDelegate
    │             ├─ ReplDataSource
    │             └─ Renderers
    │                    ├─ ReplEvaluationInputsRenderer
    │                    ├─ ReplGroupRenderer
    │                    ├─ ReplEvaluationResultsRenderer
    │                    ├─ ReplOutputElementRenderer
    │                    ├─ ReplVariablesRenderer
    │                    └─ ReplRawObjectsRenderer
    │
    ├─ acceptReplInput()
    │      └─ IDebugSession.addReplExpression()
    │             └─ Debug Adapter Protocol
    │
    ├─ selectSession()
    │      └─ WorkbenchAsyncDataTree.setInput()
    │
    └─ onDidFocusSession()
           └─ languageFeaturesService.completionProvider.register()
                  └─ IDebugSession.completions()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

式テキスト ────────▶ acceptReplInput() ────────▶ 評価結果表示
                          │
                          ▼
                    IDebugSession
                    .addReplExpression()
                          │
                          ▼
                    Debug Adapter
                    (evaluate request)
                          │
                          ▼
                    ReplEvaluationResult
                          │
                          ▼
                    ReplEvaluationResultsRenderer
                          │
                          ▼
                    ツリーUI更新

プログラム出力 ────▶ ReplOutputElement ────────▶ 出力行表示
(console.log等)           │
                          ▼
                    ReplOutputElementRenderer
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repl.ts | `src/vs/workbench/contrib/debug/browser/repl.ts` | ソース | メインのREPLビュークラス |
| replViewer.ts | `src/vs/workbench/contrib/debug/browser/replViewer.ts` | ソース | ツリー要素のレンダラー群 |
| replModel.ts | `src/vs/workbench/contrib/debug/common/replModel.ts` | ソース | REPL要素のデータモデル |
| replFilter.ts | `src/vs/workbench/contrib/debug/browser/replFilter.ts` | ソース | フィルタリングロジック |
| debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | ソース | デバッグ関連インターフェース定義 |
| debugModel.ts | `src/vs/workbench/contrib/debug/common/debugModel.ts` | ソース | Variable等のデバッグモデル |
| debugExpressionRenderer.ts | `src/vs/workbench/contrib/debug/browser/debugExpressionRenderer.ts` | ソース | 式・変数のレンダリングヘルパー |
| debugActionViewItems.ts | `src/vs/workbench/contrib/debug/browser/debugActionViewItems.ts` | ソース | セッション選択UIコンポーネント |
| debugCommands.ts | `src/vs/workbench/contrib/debug/browser/debugCommands.ts` | ソース | デバッグコマンド定義 |
| debugIcons.ts | `src/vs/workbench/contrib/debug/browser/debugIcons.ts` | ソース | アイコン定義（clearAll, evaluationPrompt等） |
| repl.css | `src/vs/workbench/contrib/debug/browser/media/repl.css` | スタイル | REPLのスタイル定義 |
| viewPane.ts | `src/vs/workbench/browser/parts/views/viewPane.ts` | ソース | FilterViewPaneベースクラス |
