# 画面設計書 32-コメントビュー

## 概要

本ドキュメントは、VS Codeのコメントビュー（Comments View）画面の設計仕様を定義する。ワークスペース内のコードコメント（レビューコメント、TODO等）を一覧表示し、管理するためのビューパネルである。

### 本画面の処理概要

コメントビューは、ワークスペース全体のコードコメントを集約表示し、効率的なコメント管理とナビゲーションを提供する。

**業務上の目的・背景**：コードレビューやチーム開発において、複数のファイルに散在するコメントを一元管理する必要がある。このビューにより、レビュアーは未解決のコメントを漏れなく確認でき、開発者はコメントへの対応状況を把握できる。GitHub Pull RequestやLive Share等の拡張機能と連携し、統合的なコメント管理を実現する。

**画面へのアクセス方法**：
- メニュー「表示」→「コメント」
- コマンドパレット「Comments: Focus on Comments View」
- アクティビティバーのコメントアイコン
- サイドバーまたはパネル領域のタブから選択

**主要な操作・処理内容**：
1. コメント一覧表示：ファイル別にグループ化されたコメントツリー表示
2. フィルタリング：テキスト、作成者によるコメントのフィルタ
3. 解決状態フィルタ：解決済み/未解決コメントの表示切替
4. ソート：リソース順/更新日時順でのソート
5. コメントへのジャンプ：コメントをクリックして該当箇所を開く
6. 折りたたみ/展開：コメントツリーの一括折りたたみ・展開
7. 次/前のコメントへ移動：キーボードナビゲーション

**画面遷移**：
- 遷移元：アクティビティバー、メニュー、コマンドパレット
- 遷移先：テキストエディタ（コメント箇所）、差分エディタ

**権限による表示制御**：コメントプロバイダ（拡張機能）の有無により表示内容が変化。コメントがない場合は空状態メッセージを表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 43 | コメント | 主機能 | コードコメントの一覧表示・管理 |

## 画面種別

一覧ビュー（ツリー形式）

## URL/ルーティング

- ビューID: `workbench.panel.comments`（定義場所による）
- コンテキストキー: `commentsView.hasComments`, `commentsView.someCommentsExpanded`, `commentsView.commentFocused`

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| フィルタテキスト | 入力 | string | - | コメント内容・作成者でフィルタ |
| 解決済み表示 | 入力 | boolean | - | 解決済みコメントの表示切替 |
| 未解決表示 | 入力 | boolean | - | 未解決コメントの表示切替 |
| ソート順 | 入力 | CommentsSortOrder | - | リソース順/更新日時順 |
| コメント一覧 | 出力 | CommentsTreeNode[] | - | フィルタ・ソート適用後のコメントツリー |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| リソースグループ | ResourceWithCommentThreads | ファイル単位のコメントグループ |
| コメントノード | CommentNode | 個別のコメント情報 |
| ユーザー名 | string | コメント作成者名 |
| コメント本文 | string/MarkdownString | コメントの内容 |
| 位置情報 | IRange | コメントの行番号・カラム |
| 返信数 | number | コメントへの返信件数 |
| 更新日時 | number | 最終更新タイムスタンプ |
| スレッド状態 | CommentThreadState | 解決済み/未解決 |
| 適用状態 | CommentThreadApplicability | 最新/古い |

## イベント仕様

### 1-コメント選択（クリック/Enter）

1. ユーザーがコメントノードを選択
2. onDidOpenイベントがトリガー
3. openFileメソッドでrevealCommentThread呼び出し
4. エディタでコメント箇所を開く
5. コメントスレッドをハイライト表示

### 2-フィルタ適用

1. フィルタテキスト入力またはフィルタオプション変更
2. updateFilterメソッド実行
3. FilterOptionsを新規作成
4. tree.filterComments()呼び出し
5. フィルタバッジ更新（件数表示）

### 3-ソート順変更

1. ソートオプション変更
2. filters.onDidChangeイベント発火
3. refreshメソッド実行
4. ツリーを再描画

### 4-折りたたみ/展開

1. collapseAll/expandAllメソッド呼び出し
2. tree.collapseAll/expandAll実行
3. 選択・フォーカスをクリア
4. 最初の要素にフォーカス
5. someCommentsExpandedコンテキストキー更新

### 5-コメント更新通知

1. commentService.onDidUpdateCommentThreadsイベント受信
2. onCommentsUpdatedメソッド実行
3. totalCommentsカウント更新
4. キャッシュクリア
5. refreshでツリー再描画

## データベース更新仕様

### 操作別データベース影響一覧

本画面はストレージにビュー状態を保存する。

| 操作（イベント） | 対象キー | 操作種別 | 概要 |
|----------------|---------|---------|------|
| 状態保存 | commentsViewState | UPDATE | フィルタ、履歴、表示オプションを保存 |

### テーブル別更新項目詳細

#### WorkspaceStorage（StorageScope.WORKSPACE）

| 操作 | キー | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | commentsViewState.filter | 文字列（現在のフィルタテキスト） | saveState時 |
| UPDATE | commentsViewState.filterHistory | 配列（フィルタ履歴） | saveState時 |
| UPDATE | commentsViewState.showResolved | boolean | 解決済み表示フラグ |
| UPDATE | commentsViewState.showUnresolved | boolean | 未解決表示フラグ |
| UPDATE | commentsViewState.sortBy | CommentsSortOrder | ソート順 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| showingFilteredResults | 情報 | フィルタ適用時 | Showing {0} of {1} |
| filterPlaceholder | プレースホルダ | 常時 | Filter (e.g. text, author) |
| rootCommentsLabel | アクセシビリティ | ルート要素 | Comments for current workspace |
| resourceWithCommentThreadsLabel | アクセシビリティ | リソース要素 | Comments in {0}, full path {1} |
| fileCommentLabel | アクセシビリティ | 位置なしコメント | in {0} |
| oneLineCommentLabel | アクセシビリティ | 単一行コメント | at line {0} column {1} in {2} |
| multiLineCommentLabel | アクセシビリティ | 複数行コメント | from line {0} to line {1} in {2} |
| resourceWithCommentLabelOutdated | アクセシビリティ | 古いコメント | Outdated from {0}: {1}... |
| replyCount | アクセシビリティ | 返信あり | {0} replies |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| コメントなし | メッセージボックスに空状態メッセージ表示、ツリーを非表示 |
| コメントプロバイダなし | コメントサービスからのメッセージを表示 |
| リソースが見つからない | ジャンプ操作をスキップ |

## 備考

- コメントプロバイダは拡張機能から提供される（GitHub PR、Live Share等）
- ツリーアイテムはファイルアイコンテーマに対応
- アクセシブルビュー対応でスクリーンリーダーへの詳細情報提供
- フィルタ統計はキャッシュされ、必要時に再計算

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コメントモデルとコメントスレッドの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | commentModel.ts | `src/vs/workbench/contrib/comments/common/commentModel.ts` | CommentNode, ResourceWithCommentThreads等のモデルクラス |
| 1-2 | commentsModel.ts | `src/vs/workbench/contrib/comments/browser/commentsModel.ts` | CommentsModel、ICommentsModelインターフェース |

**読解のコツ**: CommentNodeがコメントの基本単位、ResourceWithCommentThreadsがファイル単位のグループ、CommentsModelがワークスペース全体のモデルとなる階層構造を理解する。

#### Step 2: エントリーポイントを理解する

CommentsPanelクラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | commentsView.ts | `src/vs/workbench/contrib/comments/browser/commentsView.ts` | CommentsPanelクラス（FilterViewPaneを継承） |

**主要処理フロー**:
1. **75行目**: `class CommentsPanel extends FilterViewPane` - FilterViewPaneを継承
2. **146-197行目**: コンストラクタでのフィルタ、状態、イベントリスナー設定
3. **256-281行目**: `renderBody` - UI構築、イベント登録
4. **426-491行目**: `createTree` - CommentsListの作成とイベント設定

#### Step 3: ツリービューのレンダリングを理解する

コメントツリーの表示処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | commentsTreeViewer.ts | `src/vs/workbench/contrib/comments/browser/commentsTreeViewer.ts` | CommentsList、Filter、各種レンダラー |

**主要処理フロー**:
- CommentsListクラスのツリー構築
- ResourceWithCommentThreadsとCommentNodeのレンダリング
- Filterクラスによるフィルタリング処理

#### Step 4: フィルタとソートを理解する

フィルタリングとソート処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | commentsViewActions.ts | `src/vs/workbench/contrib/comments/browser/commentsViewActions.ts` | CommentsFilters、CommentsSortOrder |
| 4-2 | commentsFilterOptions.ts | `src/vs/workbench/contrib/comments/browser/commentsFilterOptions.ts` | FilterOptions |

**主要処理フロー**:
- **commentsView.ts 246-254行目**: updateFilterメソッド
- **commentsView.ts 432-453行目**: ソート処理（sorter.compare）

#### Step 5: コメントサービスを理解する

コメントデータの取得と更新を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | commentService.ts | `src/vs/workbench/contrib/comments/browser/commentService.ts` | ICommentService実装 |

**主要処理フロー**:
- **commentsView.ts 270-272行目**: サービスイベント購読
- **commentsView.ts 525-559行目**: コメント変更ハンドラー

### プログラム呼び出し階層図

```
CommentsPanel (FilterViewPane)
    │
    ├─ renderBody()
    │      ├─ createTree() → CommentsList
    │      │      ├─ ResourceLabels
    │      │      ├─ Filter
    │      │      └─ Sorter
    │      │
    │      └─ createMessageBox()
    │
    ├─ ICommentService イベント購読
    │      ├─ onDidSetAllCommentThreads → onAllCommentsChanged
    │      ├─ onDidUpdateCommentThreads → onCommentsUpdated
    │      └─ onDidDeleteDataProvider → onDataProviderDeleted
    │
    ├─ openFile()
    │      └─ revealCommentThread()
    │             └─ IEditorService.openEditor()
    │
    └─ updateFilter()
           ├─ FilterOptions 更新
           ├─ tree.filterComments()
           └─ filterWidget.updateBadge()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

拡張機能 ─────────▶ ICommentService ─────────▶ CommentsModel
(コメントプロバイダ)        │                          │
                          ▼                          ▼
                    commentsModel            resourceCommentThreads
                    .hasCommentThreads()           │
                          │                        ▼
                          ▼                 createResourceCommentsIterator
                    renderComments()               │
                          │                        ▼
                          ▼                  tree.setChildren()
                    renderMessage()               │
                                                  ▼
                                           CommentsList表示

フィルタ入力 ──────▶ updateFilter() ──────▶ フィルタ済みツリー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| commentsView.ts | `src/vs/workbench/contrib/comments/browser/commentsView.ts` | ソース | メインのCommentsPanelクラス |
| commentsTreeViewer.ts | `src/vs/workbench/contrib/comments/browser/commentsTreeViewer.ts` | ソース | ツリービューとレンダラー |
| commentsModel.ts | `src/vs/workbench/contrib/comments/browser/commentsModel.ts` | ソース | ワークスペースコメントモデル |
| commentModel.ts | `src/vs/workbench/contrib/comments/common/commentModel.ts` | ソース | CommentNode等のデータモデル |
| commentService.ts | `src/vs/workbench/contrib/comments/browser/commentService.ts` | ソース | コメントサービス実装 |
| commentsViewActions.ts | `src/vs/workbench/contrib/comments/browser/commentsViewActions.ts` | ソース | フィルタとアクション |
| commentsFilterOptions.ts | `src/vs/workbench/contrib/comments/browser/commentsFilterOptions.ts` | ソース | フィルタオプション |
| commentsController.ts | `src/vs/workbench/contrib/comments/browser/commentsController.ts` | ソース | revealCommentThread等 |
| comments.ts | `src/vs/workbench/contrib/comments/browser/comments.ts` | ソース | ICommentsViewインターフェース |
| panel.css | `src/vs/workbench/contrib/comments/browser/media/panel.css` | スタイル | パネルのスタイル定義 |
| viewPane.ts | `src/vs/workbench/browser/parts/views/viewPane.ts` | ソース | FilterViewPaneベースクラス |
