# 画面設計書 33-テスト結果ビュー

## 概要

本ドキュメントは、VS Codeのテスト結果ビュー（Test Results View）画面の設計仕様を定義する。テスト実行結果の詳細を表示し、失敗したテストのエラー情報やスタックトレースを調査するためのビューである。

### 本画面の処理概要

テスト結果ビューは、テスト実行後の結果を詳細に表示し、テストの成功・失敗・スキップ状況、エラーメッセージ、差分表示、スタックトレースなどを提供する。

**業務上の目的・背景**：テスト駆動開発やCI/CD環境において、テスト結果の迅速な確認と問題箇所の特定が重要である。このビューにより、開発者は失敗したテストの原因を素早く把握し、期待値と実際の値の差分を視覚的に確認できる。コールスタック表示により、エラーの発生箇所へ直接ジャンプすることも可能。

**画面へのアクセス方法**：
- テストエクスプローラーからテスト結果をクリック
- テストデコレーションのピークビューから表示
- コマンドパレット「Testing: Focus on Test Results View」
- パネル領域のタブから選択

**主要な操作・処理内容**：
1. テスト結果のツリー表示：テストラン、テストケース、メッセージの階層表示
2. 差分表示：期待値と実際の値の差分をエディタ形式で表示
3. スタックトレース表示：エラー発生時のコールスタックを展開表示
4. テスト再実行：結果ビューから直接テストを再実行またはデバッグ
5. エラー箇所へのジャンプ：スタックフレームをクリックしてソースコードを開く
6. 出力の展開/折りたたみ：詳細情報の表示切替
7. 履歴表示：過去のテスト結果の参照

**画面遷移**：
- 遷移元：テストエクスプローラー、テストピークビュー、エディタデコレーション
- 遷移先：テキストエディタ（エラー箇所）、差分エディタ

**権限による表示制御**：テストプロファイルの能力（実行可能/デバッグ可能）に応じてアクションボタンの表示を制御。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | テスト | 主機能 | テスト実行結果の詳細表示 |

## 画面種別

詳細ビュー（スプリット形式）

## URL/ルーティング

- ビューID: テストコントリビューション内で定義
- コンテキストキー: `testMessageContext`, `testResultOutdated`

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| 履歴表示切替 | 入力 | boolean | - | 過去の結果一覧の表示/非表示 |
| テスト結果 | 出力 | InspectSubject | - | 検査対象のテスト結果 |
| メッセージ内容 | 出力 | string/Markdown | - | テストメッセージの内容 |
| スタックフレーム | 出力 | ITestMessageStackFrame[] | - | エラースタックトレース |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| メッセージフレーム | MessageStackFrame | テストメッセージを表示するスタックフレーム |
| コールスタック | CallStackFrame[] | エラー発生時のスタックトレース |
| 差分コンテンツ | DiffContentProvider | 期待値と実際の値の差分 |
| Markdown出力 | MarkdownTestMessagePeek | Markdown形式のメッセージ |
| ターミナル出力 | TerminalMessagePeek | ターミナル形式の出力 |
| プレーンテキスト | PlainTextMessagePeek | プレーンテキストメッセージ |
| 結果ツリー | OutputPeekTree | テスト結果の階層ツリー |

## イベント仕様

### 1-テスト結果の表示（reveal）

1. テスト項目を選択または結果をクリック
2. reveal()メソッド呼び出し
3. コンテンツプロバイダの更新をキューに追加（Limiter使用）
4. getCallFramesでスタックフレーム取得
5. prepareTopFrameでMessageStackFrame作成
6. setCallStackFramesでCallStackWidgetに設定
7. フォローアップアクションウィジェット表示

### 2-スタックフレームクリック

1. CallStackWidget内のフレームをクリック
2. フレームのURIと位置情報を取得
3. エディタでソースコードを開く
4. 該当行にカーソル移動

### 3-テスト再実行

1. ツールバーの再実行ボタンクリック
2. runInLast()関数呼び出し
3. TestRunProfileBitset.Runでテスト実行
4. ITestServiceのrunTests呼び出し

### 4-テストデバッグ

1. ツールバーのデバッグボタンクリック
2. runInLast()関数呼び出し
3. TestRunProfileBitset.Debugでデバッグ実行
4. デバッグセッション開始

### 5-レイアウト変更

1. configurationService設定変更検知
2. TestingResultsViewLayout設定確認
3. swapViews()でビュー位置を入れ替え
4. 分割位置の再計算

## データベース更新仕様

### 操作別データベース影響一覧

本画面は直接的なデータベース更新を行わない。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| 分割位置変更 | 静的変数 | UPDATE | lastSplitWidthに保存 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| testingCallStackRun | ボタン | 実行可能テスト | Rerun Test |
| testingCallStackDebug | ボタン | デバッグ可能テスト | Debug Test |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| スタックフレームなし | メッセージのみ表示、スタック非表示 |
| 差分データなし | プレーンテキストまたはMarkdown表示にフォールバック |
| テストが見つからない | 再実行アクションをスキップ |

## 備考

- コンテンツプロバイダは優先度順に評価（Diff > Markdown > Terminal > PlainText）
- SplitViewを使用したリサイズ可能なレイアウト
- ピークビュー内とパネル内の両方で表示可能
- フォローアップアクション（修正提案）のサポート

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テスト結果のサブジェクト（検査対象）の種類を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | testResultsSubject.ts | `src/vs/workbench/contrib/testing/browser/testResultsView/testResultsSubject.ts` | InspectSubject, MessageSubject, TaskSubject, TestOutputSubject |

**読解のコツ**: InspectSubjectが検査対象の基本型、MessageSubjectが個別メッセージ、TaskSubjectがタスク全体、TestOutputSubjectがテスト出力を表す。

#### Step 2: エントリーポイントを理解する

TestResultsViewContentクラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | testResultsViewContent.ts | `src/vs/workbench/contrib/testing/browser/testResultsView/testResultsViewContent.ts` | TestResultsViewContentクラス |

**主要処理フロー**:
1. **171行目**: `class TestResultsViewContent extends Disposable` - メインクラス
2. **251-340行目**: `fillBody` - UI構築、SplitView設定
3. **346-366行目**: `reveal` - 結果表示処理
4. **368-375行目**: `setCallStackFrames` - スタック設定

#### Step 3: 出力レンダラーを理解する

各種メッセージ形式のレンダリングを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | testResultsOutput.ts | `src/vs/workbench/contrib/testing/browser/testResultsView/testResultsOutput.ts` | DiffContentProvider, MarkdownTestMessagePeek, TerminalMessagePeek, PlainTextMessagePeek |

**主要処理フロー**:
- 各IPeekOutputRendererの実装
- コンテンツの優先度判定
- エディタまたは専用ウィジェットでの表示

#### Step 4: 結果ツリーを理解する

テスト結果の階層表示を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | testResultsTree.ts | `src/vs/workbench/contrib/testing/browser/testResultsView/testResultsTree.ts` | OutputPeekTree |

### プログラム呼び出し階層図

```
TestResultsViewContent (Disposable)
    │
    ├─ fillBody()
    │      ├─ SplitView 作成
    │      │      ├─ stackContainer (CallStackWidget)
    │      │      └─ treeContainer (OutputPeekTree)
    │      │
    │      ├─ CallStackWidget 作成
    │      └─ ContentProviders 作成
    │             ├─ DiffContentProvider
    │             ├─ MarkdownTestMessagePeek
    │             ├─ TerminalMessagePeek
    │             └─ PlainTextMessagePeek
    │
    ├─ reveal()
    │      ├─ getCallFrames()
    │      ├─ prepareTopFrame() → MessageStackFrame
    │      └─ setCallStackFrames()
    │
    └─ MessageStackFrame
           ├─ render() → メッセージコンテンツ表示
           └─ renderActions() → ツールバー表示
                  └─ MenuWorkbenchToolBar (MenuId.TestCallStack)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

テスト選択 ─────────▶ reveal() ─────────────────▶ CallStackWidget
                          │                              │
                          ▼                              ▼
                    getCallFrames()              MessageStackFrame
                          │                      + CallStackFrame[]
                          ▼
                    prepareTopFrame()
                          │
                          ▼
                    ContentProvider選択
                          │
                          ├─ DiffContentProvider ────▶ 差分エディタ
                          ├─ MarkdownTestMessagePeek ▶ Markdownレンダリング
                          ├─ TerminalMessagePeek ───▶ ターミナル出力
                          └─ PlainTextMessagePeek ──▶ プレーンテキスト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| testResultsViewContent.ts | `src/vs/workbench/contrib/testing/browser/testResultsView/testResultsViewContent.ts` | ソース | メインのビューコンテンツクラス |
| testResultsSubject.ts | `src/vs/workbench/contrib/testing/browser/testResultsView/testResultsSubject.ts` | ソース | 検査対象のデータモデル |
| testResultsTree.ts | `src/vs/workbench/contrib/testing/browser/testResultsView/testResultsTree.ts` | ソース | 結果ツリービュー |
| testResultsOutput.ts | `src/vs/workbench/contrib/testing/browser/testResultsView/testResultsOutput.ts` | ソース | 出力レンダラー群 |
| callStackWidget.ts | `src/vs/workbench/contrib/debug/browser/callStackWidget.ts` | ソース | コールスタックウィジェット |
| testResultsViewContent.css | `src/vs/workbench/contrib/testing/browser/testResultsView/testResultsViewContent.css` | スタイル | ビューのスタイル |
| icons.ts | `src/vs/workbench/contrib/testing/browser/icons.ts` | ソース | テストアイコン定義 |
| testingContextKeys.ts | `src/vs/workbench/contrib/testing/common/testingContextKeys.ts` | ソース | コンテキストキー定義 |
| configuration.ts | `src/vs/workbench/contrib/testing/common/configuration.ts` | ソース | テスト設定（レイアウト等） |
