# 画面設計書 34-変数ビュー

## 概要

本ドキュメントは、VS Codeの変数ビュー（Variables View）画面の設計仕様を定義する。デバッグセッション中にローカル変数、パラメータ、グローバル変数などのスコープ別変数を階層的に表示・編集するためのビューである。

### 本画面の処理概要

変数ビューは、デバッグ中の現在のスタックフレームにおける変数の値をスコープ別にツリー形式で表示し、変数の値を確認・編集できる機能を提供する。

**業務上の目的・背景**：デバッグ作業において、プログラムの状態を把握することは問題解決の基本である。このビューにより、開発者は現在実行中のコンテキストにおけるすべての変数（ローカル変数、引数、クロージャ変数、グローバル変数など）を確認し、必要に応じて値を変更してプログラムの動作を検証できる。

**画面へのアクセス方法**：
- デバッグビューのサイドバー内「変数」セクション
- デバッグセッション開始時に自動的に表示
- コマンドパレット「Debug: Focus on Variables View」

**主要な操作・処理内容**：
1. 変数の階層表示：スコープ > 変数 > 子プロパティの階層ツリー
2. 変数値の表示：型、名前、値の表示
3. 変数値の編集：ダブルクリックで値を変更
4. 変数のコピー：値、評価パス、名前のコピー
5. ウォッチへの追加：変数をウォッチ式に追加
6. データブレークポイント設定：変数値変更時のブレーク設定
7. メモリビュー：変数のメモリアドレスを16進エディタで表示
8. ビジュアライザ：変数の視覚化表示

**画面遷移**：
- 遷移元：デバッグセッション開始、スタックフレーム選択
- 遷移先：16進エディタ（メモリビュー時）

**権限による表示制御**：デバッガの能力（supportsSetVariable, supportsDataBreakpoints等）に応じて編集やブレークポイント設定の可否が変化。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | デバッグ | 主機能 | デバッグ時の変数表示・編集 |
| 65 | デバッグ拡張API | API連携 | Debug Adapter経由の変数取得・設定 |

## 画面種別

ツリービュー

## URL/ルーティング

- ビューID: `workbench.debug.variablesView`
- コンテキストキー: `CONTEXT_VARIABLES_FOCUSED`

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| スタックフレーム | 入力 | IStackFrame | - | 表示対象のスタックフレーム |
| 変数値入力 | 入力 | string | - | 変数編集時の新しい値 |
| スコープ一覧 | 出力 | IScope[] | - | スコープ別の変数グループ |
| 変数一覧 | 出力 | IExpression[] | - | 変数とその値 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| スコープ | Scope | 変数のスコープ（Local, Global, Closure等） |
| スコープエラー | ErrorScope | スコープ取得エラー |
| 変数 | Variable | 変数の名前、型、値 |
| ビジュアライズ変数 | VisualizedExpression | ビジュアライザで表示される変数 |
| アクションバー | ActionBar | コンテキストアクション |

## イベント仕様

### 1-スタックフレーム変更

1. debugService.getViewModel().onDidFocusStackFrame発火
2. updateTreeScheduler.schedule()呼び出し
3. 現在のツリー状態を保存（savedViewState）
4. 新しいスタックフレームの入力をツリーに設定
5. 最初の非expensiveスコープを自動展開

### 2-変数値編集（ダブルクリック）

1. ユーザーがVariable要素をダブルクリック
2. onMouseDblClickハンドラでcanSetExpressionValue確認
3. setSelectedExpression呼び出し
4. 入力ボックス表示
5. 値入力後、variable.setVariable呼び出し
6. updateViews()で画面更新

### 3-コンテキストメニュー

1. 変数を右クリック
2. onContextMenuハンドラ実行
3. getContextForVariableMenuWithDataAccessでコンテキスト取得
4. MenuId.DebugVariablesContextのメニュー表示
5. コピー、ウォッチ追加、データブレークポイント等のアクション

### 4-メモリビュー

1. View Memoryコマンド実行
2. HEX_EDITOR拡張のインストール確認
3. 必要に応じて拡張をインストール
4. getUriForDebugMemoryでURIを生成
5. 16進エディタでメモリ内容を表示

### 5-ビジュアライザ適用

1. visualization.getApplicableForで利用可能なビジュアライザ取得
2. ビジュアライザボタン表示
3. ユーザーがビジュアライザ選択
4. setVisualizedExpressionで適用
5. ツリーを更新してビジュアライズ表示

## データベース更新仕様

### 操作別データベース影響一覧

本画面は直接的なストレージ更新を行わない。変数編集はデバッグアダプタ経由でターゲットプロセスに反映される。

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| variablesAriaTreeLabel | アクセシビリティ | 常時 | Debug Variables |
| variableScopeAriaLabel | アクセシビリティ | スコープ要素 | Scope {0} |
| variableAriaLabel | アクセシビリティ | 変数要素 | {0}, value {1} |
| variableValueAriaLabel | アクセシビリティ | 値入力時 | Type new variable value |
| viewMemoryPrompt | 情報 | HEXエディタ未インストール | Inspecting binary data requires this extension. |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| スタックフレームなし | ツリーにnullを設定、空表示 |
| スコープ取得エラー | ErrorScopeとして表示 |
| 変数設定エラー | エラーメッセージを表示、値は元に戻る |
| HEXエディタインストール失敗 | エラー通知を表示 |

## 備考

- 変数の行の高さは22ピクセル固定
- 変数値の変更時は自動的にビューを更新
- Lazy評価の変数は展開時に値を取得
- readOnly属性を持つ変数は編集不可
- forgetScopesフラグでスコープのキャッシュ制御

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

変数とスコープのデータモデルを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | IExpression, IScope, IVariable等のインターフェース |
| 1-2 | debugModel.ts | `src/vs/workbench/contrib/debug/common/debugModel.ts` | Variable, Scope, ErrorScope, VisualizedExpressionクラス |

**読解のコツ**: IExpressionが式・変数の基本インターフェース、IScopeがスコープ、Variableが具体的な変数クラスとなる。

#### Step 2: エントリーポイントを理解する

VariablesViewクラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | variablesView.ts | `src/vs/workbench/contrib/debug/browser/variablesView.ts` | VariablesViewクラス（ViewPaneを継承） |

**主要処理フロー**:
1. **64行目**: `class VariablesView extends ViewPane` - ViewPaneを継承
2. **93-119行目**: updateTreeSchedulerでのツリー更新処理
3. **122-201行目**: `renderBody` - UI構築、イベント登録
4. **217-238行目**: onMouseDblClickとcanSetExpressionValue

#### Step 3: レンダラーを理解する

変数とスコープのレンダリングを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | variablesView.ts | `src/vs/workbench/contrib/debug/browser/variablesView.ts` | VariablesRenderer, ScopesRenderer, ScopeErrorRenderer, VisualizedVariableRenderer |

**主要処理フロー**:
- **368-389行目**: VariablesDelegate - テンプレートID決定
- **391-413行目**: ScopesRenderer - スコープ表示
- **419-440行目**: ScopeErrorRenderer - エラースコープ表示
- **540-650行目**: VariablesRenderer - 変数表示と編集

#### Step 4: コンテキストメニューとアクションを理解する

変数操作のアクション群を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | variablesView.ts | `src/vs/workbench/contrib/debug/browser/variablesView.ts` | openContextMenuForVariableTreeElement, コマンド登録 |
| 4-2 | debugCommands.ts | `src/vs/workbench/contrib/debug/browser/debugCommands.ts` | COPY_VALUE_ID, ADD_TO_WATCH_ID等 |

**主要処理フロー**:
- **268-283行目**: openContextMenuForVariableTreeElement
- **670-677行目**: SET_VARIABLE_IDコマンド
- **679-732行目**: COPY_VALUE_IDコマンド
- **806-819行目**: COPY_EVALUATE_PATH_IDコマンド
- **821-830行目**: ADD_TO_WATCH_IDコマンド

### プログラム呼び出し階層図

```
VariablesView (ViewPane)
    │
    ├─ renderBody()
    │      ├─ renderViewTree() → treeContainer
    │      └─ WorkbenchAsyncDataTree 作成
    │             ├─ VariablesDelegate
    │             ├─ VariablesDataSource
    │             └─ Renderers
    │                    ├─ VariablesRenderer
    │                    ├─ VisualizedVariableRenderer
    │                    ├─ ScopesRenderer
    │                    └─ ScopeErrorRenderer
    │
    ├─ updateTreeScheduler
    │      ├─ getViewModel().focusedStackFrame
    │      ├─ savedViewState.set()
    │      ├─ tree.setInput(stackFrame)
    │      └─ stackFrame.getScopes() → 自動展開
    │
    ├─ onMouseDblClick()
    │      └─ setSelectedExpression()
    │             └─ 入力ボックス表示
    │
    └─ onContextMenu()
           └─ openContextMenuForVariableTreeElement()
                  ├─ getContextForVariableMenuWithDataAccess()
                  └─ contextMenuService.showContextMenu()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

スタックフレーム ────▶ updateTreeScheduler ────▶ ツリー表示
選択変更                    │
                          ▼
                    stackFrame.getScopes()
                          │
                          ▼
                    scope.getChildren()
                          │
                          ▼
                    Variable取得
                          │
                          ▼
                    VariablesRenderer
                          │
                          ▼
                    変数ツリー表示

変数編集 ─────────▶ setSelectedExpression() ─▶ 入力ボックス
                          │
                          ▼
                    variable.setVariable()
                          │
                          ▼
                    Debug Adapter
                          │
                          ▼
                    updateViews() → ツリー更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| variablesView.ts | `src/vs/workbench/contrib/debug/browser/variablesView.ts` | ソース | メインのVariablesViewクラス |
| debugModel.ts | `src/vs/workbench/contrib/debug/common/debugModel.ts` | ソース | Variable, Scopeモデル |
| debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | ソース | インターフェース定義 |
| baseDebugView.ts | `src/vs/workbench/contrib/debug/browser/baseDebugView.ts` | ソース | AbstractExpressionsRenderer |
| debugExpressionRenderer.ts | `src/vs/workbench/contrib/debug/browser/debugExpressionRenderer.ts` | ソース | 変数値レンダリング |
| debugCommands.ts | `src/vs/workbench/contrib/debug/browser/debugCommands.ts` | ソース | コピー、ウォッチ追加コマンド |
| debugContext.ts | `src/vs/workbench/contrib/debug/common/debugContext.ts` | ソース | 変数コンテキスト生成 |
| debugVisualizers.ts | `src/vs/workbench/contrib/debug/common/debugVisualizers.ts` | ソース | ビジュアライザサービス |
| viewPane.ts | `src/vs/workbench/browser/parts/views/viewPane.ts` | ソース | ViewPaneベースクラス |
