# 画面設計書 36-コールスタックビュー

## 概要

本ドキュメントは、VS Codeのコールスタックビュー（Call Stack View）画面の設計仕様を定義する。デバッグセッション中の関数呼び出し階層（コールスタック）を表示し、スタックフレーム間のナビゲーションを提供するためのビューである。

### 本画面の処理概要

コールスタックビューは、デバッグ停止時の関数呼び出し階層をセッション > スレッド > スタックフレームの階層で表示し、任意のフレームに移動して変数の状態を確認できる機能を提供する。

**業務上の目的・背景**：デバッグ時に現在の実行位置だけでなく、そこに至るまでの関数呼び出しの経路を把握することは、問題の原因を特定するために不可欠である。このビューにより、開発者はコールチェーンを遡って各フレームでの変数の状態を確認し、問題の発生箇所を特定できる。

**画面へのアクセス方法**：
- デバッグビューのサイドバー内「コールスタック」セクション
- デバッグセッション開始時に自動的に表示
- コマンドパレット「Debug: Focus on Call Stack View」

**主要な操作・処理内容**：
1. スタックフレームの選択：フレームをクリックしてソースコードを表示
2. スレッドの切り替え：マルチスレッドデバッグ時にスレッドを切り替え
3. セッションの切り替え：マルチセッション時にセッションを切り替え
4. フレームの再起動：選択したスタックフレームから再実行
5. 追加フレームの読み込み：長いスタックの追加読み込み
6. 非強調フレームの表示：通常は非表示のフレームを表示

**画面遷移**：
- 遷移元：デバッグセッション開始、ブレークポイント到達
- 遷移先：ソースコードエディタ（フレーム選択時）

**権限による表示制御**：スレッドやフレームの状態（停止中/実行中）に応じて選択可能性が変化。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | デバッグ | 主機能 | デバッグ時のコールスタック表示 |
| 65 | デバッグ拡張API | API連携 | Debug Adapter経由のスタック取得 |

## 画面種別

圧縮可能ツリービュー

## URL/ルーティング

- ビューID: `workbench.debug.callStackView`（CALLSTACK_VIEW_ID）
- コンテキストキー: `CONTEXT_CALLSTACK_FOCUSED`, `CONTEXT_CALLSTACK_ITEM_TYPE`

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| デバッグモデル | 入力 | IDebugModel | 必須 | ツリーの入力データ |
| セッション一覧 | 出力 | IDebugSession[] | - | デバッグセッション |
| スレッド一覧 | 出力 | IThread[] | - | セッション内のスレッド |
| スタックフレーム | 出力 | IStackFrame[] | - | スレッドのコールスタック |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| セッション | IDebugSession | デバッグセッション（名前、状態） |
| スレッド | IThread | スレッド（名前、状態、停止理由） |
| スタックフレーム | IStackFrame | フレーム（関数名、ソース、行番号） |
| 追加読み込み | ThreadAndSessionIds | 追加フレーム読み込みボタン |
| Show More | IStackFrame[] | 非強調フレーム表示ボタン |
| 状態メッセージ | string | 停止理由やRunning状態の表示 |

## イベント仕様

### 1-スタックフレーム選択

1. ユーザーがフレームをクリック
2. tree.onDidOpenイベントハンドラ
3. focusStackFrame()呼び出し
4. 対応するソースファイルをエディタで開く
5. 変数ビュー、ウォッチビューが更新

### 2-スレッド切り替え

1. ユーザーがスレッドをクリック
2. focusStackFrame(undefined, thread, session)呼び出し
3. スレッドの状態に応じてフォーカス
4. 子スタックフレームを取得・表示

### 3-追加フレーム読み込み

1. 「Load More Stack Frames」をクリック
2. ThreadAndSessionIdsオブジェクト検出
3. thread.fetchCallStack()で残りのフレームを取得
4. ツリーを更新

### 4-フレーム再起動

1. フレームを右クリック → Restart Frame
2. CONTEXT_STACK_FRAME_SUPPORTS_RESTARTコンテキスト確認
3. restartFrame API呼び出し
4. デバッグセッションが指定フレームから再開

### 5-コールスタック変更

1. debugService.getModel().onDidChangeCallStackイベント
2. onCallStackChangeScheduler.schedule()
3. 状態メッセージ更新（停止理由など）
4. ツリー更新、セッション自動展開

## データベース更新仕様

### 操作別データベース影響一覧

本画面は直接的なストレージ更新を行わない。

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| running | 状態 | セッション実行中 | Running |
| paused | 状態 | 例外発生 | Paused on {0} |
| pausedOnBreakpoint | 状態 | ブレークポイント | Paused |
| pausedOnException | 状態 | 例外 | Exception: {0} |
| showMoreStackFrames | ラベル | 非強調フレームあり | Show More Stack Frames |
| loadMore | ラベル | 追加フレームあり | Load More Stack Frames |
| callstackAriaLabel | アクセシビリティ | ツリー | Debug Call Stack |
| thread | アクセシビリティ | スレッド | Thread {0} |
| session | アクセシビリティ | セッション | Session {0} |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| セッションなし | 自動展開セットをクリア |
| ツリー展開エラー | エラーを無視して処理継続 |
| フレーム取得エラー | エラーフレームとして表示 |

## 備考

- 圧縮表示により、単一子セッションは親と一緒に表示
- 50ms遅延でツリー更新（不要なちらつき防止）
- スレッドが1つの場合、セッションレベルでstoppedDetailsを表示
- expandOnlyOnTwistieClick設定で展開動作を制御
- deemphasizedフレームは通常非表示、明示的に表示可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

セッション、スレッド、スタックフレームの階層を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | IDebugSession, IThread, IStackFrame |
| 1-2 | debugModel.ts | `src/vs/workbench/contrib/debug/common/debugModel.ts` | Thread, StackFrame, ThreadAndSessionIds |

#### Step 2: エントリーポイントを理解する

CallStackViewクラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | callStackView.ts | `src/vs/workbench/contrib/debug/browser/callStackView.ts` | CallStackViewクラス（ViewPaneを継承） |

**主要処理フロー**:
1. **147行目**: `class CallStackView extends ViewPane` - ViewPaneを継承
2. **177-224行目**: onCallStackChangeSchedulerの処理
3. **236-400行目**: `renderBody` - UI構築、ツリー設定、イベント登録
4. **299-343行目**: tree.onDidOpenハンドラ

#### Step 3: レンダラーを理解する

各要素タイプのレンダリングを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | callStackView.ts | `src/vs/workbench/contrib/debug/browser/callStackView.ts` | SessionsRenderer, ThreadsRenderer, StackFramesRenderer, ErrorsRenderer, LoadMoreRenderer, ShowMoreRenderer |

**主要処理フロー**:
- CallStackDelegate: テンプレートID決定
- CallStackCompressionDelegate: 圧縮判定
- CallStackDataSource: 子要素取得

### プログラム呼び出し階層図

```
CallStackView (ViewPane)
    │
    ├─ renderHeaderTitle()
    │      └─ stateMessage表示
    │
    ├─ renderBody()
    │      ├─ renderViewTree() → treeContainer
    │      └─ WorkbenchCompressibleAsyncDataTree 作成
    │             ├─ CallStackDelegate
    │             ├─ CallStackCompressionDelegate
    │             ├─ CallStackDataSource
    │             └─ Renderers
    │                    ├─ SessionsRenderer
    │                    ├─ ThreadsRenderer
    │                    ├─ StackFramesRenderer
    │                    ├─ ErrorsRenderer
    │                    ├─ LoadMoreRenderer
    │                    └─ ShowMoreRenderer
    │
    ├─ onCallStackChangeScheduler
    │      ├─ stateMessage更新
    │      ├─ tree.updateChildren()
    │      └─ セッション自動展開
    │
    └─ tree.onDidOpen()
           └─ focusStackFrame()
                  └─ debugService.focusStackFrame()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

デバッグセッション ───▶ CallStackDataSource ────▶ ツリー表示
    │                        │
    ▼                        ▼
IDebugModel           getChildren()
    │                        │
    ▼                        ├─ sessions
debugService               │
.getModel()               ├─ threads
                          │
                          └─ stackFrames

フレーム選択 ─────────▶ focusStackFrame() ────▶ エディタ表示
                              │                     │
                              ▼                     ▼
                    debugService              変数ビュー更新
                    .focusStackFrame()         ウォッチビュー更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| callStackView.ts | `src/vs/workbench/contrib/debug/browser/callStackView.ts` | ソース | メインのCallStackViewクラス |
| debugModel.ts | `src/vs/workbench/contrib/debug/common/debugModel.ts` | ソース | Thread, StackFrameモデル |
| debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | ソース | インターフェース定義 |
| baseDebugView.ts | `src/vs/workbench/contrib/debug/browser/baseDebugView.ts` | ソース | renderViewTree |
| debugCommands.ts | `src/vs/workbench/contrib/debug/browser/debugCommands.ts` | ソース | CONTINUE_ID, STEP_INTO_ID等 |
| debugIcons.ts | `src/vs/workbench/contrib/debug/browser/debugIcons.ts` | ソース | アイコン定義 |
| debugToolBar.ts | `src/vs/workbench/contrib/debug/browser/debugToolBar.ts` | ソース | createDisconnectMenuItemAction |
| viewPane.ts | `src/vs/workbench/browser/parts/views/viewPane.ts` | ソース | ViewPaneベースクラス |
