# 画面設計書 37-ブレークポイントビュー

## 概要

本ドキュメントは、VS Codeのブレークポイントビュー（Breakpoints View）画面の設計仕様を定義する。プロジェクト内のすべてのブレークポイントを一覧表示し、管理するためのビューである。

### 本画面の処理概要

ブレークポイントビューは、ソースブレークポイント、関数ブレークポイント、データブレークポイント、例外ブレークポイント、命令ブレークポイントなど、すべての種類のブレークポイントを統合的に表示・管理する。

**業務上の目的・背景**：デバッグ作業において、ブレークポイントの管理は重要な要素である。このビューにより、開発者は設定済みのすべてのブレークポイントを一覧で確認し、有効/無効の切り替え、条件の設定、ヒット回数の設定などを効率的に行える。

**画面へのアクセス方法**：
- デバッグビューのサイドバー内「ブレークポイント」セクション
- デバッグセッション開始時に表示
- コマンドパレット「Debug: Focus on Breakpoints View」

**主要な操作・処理内容**：
1. ブレークポイント一覧表示：ファイル別グループまたはフラット表示
2. 有効/無効切り替え：チェックボックスで個別またはグループ単位
3. 条件設定：ブレークポイントの条件式を設定
4. ヒット回数設定：指定回数到達時にのみ停止
5. ログメッセージ設定：停止せずにログ出力
6. ブレークポイント削除：中クリックまたはコンテキストメニュー
7. ソース位置へジャンプ：ダブルクリックでエディタを開く
8. モード切替：ブレークポイントのモードを変更

**画面遷移**：
- 遷移元：デバッグセッション開始、エディタからのブレークポイント設定
- 遷移先：ソースコードエディタ、逆アセンブリビュー

**権限による表示制御**：デバッガの能力（supportsConditionalBreakpoints, supportsDataBreakpoints等）に応じて設定可能なオプションが変化。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | デバッグ | 主機能 | ブレークポイントの設定・管理 |
| 65 | デバッグ拡張API | API連携 | Debug Adapter経由のブレークポイント操作 |

## 画面種別

圧縮可能ツリービュー / リストビュー

## URL/ルーティング

- ビューID: `workbench.debug.breakpointsView`（BREAKPOINTS_VIEW_ID）
- コンテキストキー: `CONTEXT_BREAKPOINTS_FOCUSED`, `CONTEXT_BREAKPOINT_ITEM_TYPE`

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| 条件入力 | 入力 | string | - | ブレークポイント条件式 |
| ヒット回数 | 入力 | string | - | 停止するまでのヒット回数 |
| ログメッセージ | 入力 | string | - | 出力するログメッセージ |
| ブレークポイント一覧 | 出力 | BreakpointItem[] | - | 全ブレークポイント |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ブレークポイントフォルダ | BreakpointsFolderItem | ファイル別グループ |
| ソースブレークポイント | Breakpoint | 行ブレークポイント |
| 関数ブレークポイント | FunctionBreakpoint | 関数名ブレークポイント |
| データブレークポイント | DataBreakpoint | メモリアクセスブレークポイント |
| 例外ブレークポイント | ExceptionBreakpoint | 例外発生時ブレークポイント |
| 命令ブレークポイント | InstructionBreakpoint | 命令アドレスブレークポイント |
| 警告ヒント | IconLabel | 未検証ブレークポイントの警告 |

## イベント仕様

### 1-ブレークポイント選択（ダブルクリック）

1. ユーザーがブレークポイントをダブルクリック
2. tree.onDidOpenイベントハンドラ
3. openBreakpointSource()でソースファイルを開く
4. InstructionBreakpointの場合は逆アセンブリビューを開く

### 2-有効/無効切り替え

1. チェックボックスをクリック
2. enableOrDisableBreakpointアクション実行
3. debugService.enableOrDisableBreakpoint()呼び出し
4. ブレークポイント状態更新

### 3-条件入力

1. 「Edit Condition」を選択
2. renderInputBox()で入力ボックス表示
3. 入力確定後、updateBreakpoints/updateFunctionBreakpoints等呼び出し
4. ブレークポイント更新

### 4-中クリック削除

1. 要素を中クリック
2. tree.onMouseMiddleClickハンドラ
3. debugService.removeBreakpoints/removeFunctionBreakpoints等呼び出し
4. ブレークポイント削除

### 5-表示形式切替

1. debug.breakpointsView.presentation設定変更
2. onDidChangeConfigurationイベント検知
3. tree.updateOptions({ compressionEnabled })
4. onBreakpointsChange()でツリー再構築

## データベース更新仕様

### 操作別データベース影響一覧

ブレークポイントはワークスペース設定として永続化される。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| 有効/無効 | DebugModel | UPDATE | enabled状態を変更 |
| 条件設定 | DebugModel | UPDATE | condition/hitCondition/logMessageを設定 |
| 削除 | DebugModel | DELETE | ブレークポイントを削除 |
| 全削除 | DebugModel | DELETE | すべてのブレークポイントを削除 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| breakpointAriaLabel | アクセシビリティ | ブレークポイント | Breakpoint |
| functionBreakpointAriaLabel | アクセシビリティ | 関数ブレークポイント | Function breakpoint |
| dataBreakpointAriaLabel | アクセシビリティ | データブレークポイント | Data breakpoint |
| exceptionBreakpointAriaLabel | アクセシビリティ | 例外ブレークポイント | Exception breakpoint |
| instructionBreakpointAriaLabel | アクセシビリティ | 命令ブレークポイント | Instruction breakpoint |
| unverifiedBreakpoints | 警告 | 未検証ブレークポイントあり | デバッガ定義のメッセージ |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ブレークポイント検証失敗 | 未検証状態で表示、警告アイコン表示 |
| 条件式エラー | エラーメッセージをツールチップで表示 |

## 備考

- MAX_VISIBLE_BREAKPOINTS = 9（最大表示数）
- 各行の高さは22ピクセル
- tree/list表示はdebug.breakpointsView.presentation設定で切替
- hintDelayerで未検証ブレークポイントの警告を4秒後に表示
- collapsedStateでフォルダの展開状態を保持

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

各種ブレークポイントのモデルを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | IBreakpoint, IFunctionBreakpoint, IDataBreakpoint, IExceptionBreakpoint |
| 1-2 | debugModel.ts | `src/vs/workbench/contrib/debug/common/debugModel.ts` | Breakpoint, FunctionBreakpoint, DataBreakpoint, ExceptionBreakpoint, InstructionBreakpoint |

#### Step 2: エントリーポイントを理解する

BreakpointsViewクラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | breakpointsView.ts | `src/vs/workbench/contrib/debug/browser/breakpointsView.ts` | BreakpointsViewクラス（ViewPaneを継承） |

**主要処理フロー**:
1. **117行目**: `class BreakpointsView extends ViewPane` - ViewPaneを継承
2. **173-321行目**: `renderBody` - UI構築、ツリー設定
3. **440-451行目**: onBreakpointsChange - ブレークポイント変更時の更新
4. **488-491行目**: setTreeInput - ツリーデータ設定

#### Step 3: レンダラーを理解する

各ブレークポイント種類のレンダリングを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | breakpointsView.ts | `src/vs/workbench/contrib/debug/browser/breakpointsView.ts` | BreakpointsFolderRenderer, BreakpointsRenderer, FunctionBreakpointsRenderer, DataBreakpointsRenderer, ExceptionBreakpointsRenderer, InstructionBreakpointsRenderer |

**主要処理フロー**:
- **185行目**: BreakpointsFolderRenderer - フォルダ表示
- **186行目**: BreakpointsRenderer - ソースブレークポイント
- **187行目**: ExceptionBreakpointsRenderer - 例外ブレークポイント
- **189行目**: FunctionBreakpointsRenderer - 関数ブレークポイント
- **191行目**: DataBreakpointsRenderer - データブレークポイント
- **193行目**: InstructionBreakpointsRenderer - 命令ブレークポイント

### プログラム呼び出し階層図

```
BreakpointsView (ViewPane)
    │
    ├─ renderBody()
    │      └─ WorkbenchCompressibleObjectTree 作成
    │             ├─ BreakpointsDelegate
    │             └─ Renderers
    │                    ├─ BreakpointsFolderRenderer
    │                    ├─ BreakpointsRenderer
    │                    ├─ ExceptionBreakpointsRenderer
    │                    ├─ ExceptionBreakpointInputRenderer
    │                    ├─ FunctionBreakpointsRenderer
    │                    ├─ FunctionBreakpointInputRenderer
    │                    ├─ DataBreakpointsRenderer
    │                    ├─ DataBreakpointInputRenderer
    │                    └─ InstructionBreakpointsRenderer
    │
    ├─ onBreakpointsChange()
    │      ├─ setTreeInput()
    │      ├─ updateBreakpointsHint()
    │      └─ updateSize()
    │
    ├─ onStateChange()
    │      └─ ヒットしたブレークポイントをフォーカス
    │
    └─ onTreeContextMenu()
           └─ contextMenuService.showContextMenu()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ブレークポイント追加 ──▶ onDidChangeBreakpoints ──▶ ツリー更新
                              │
                              ▼
                    setTreeInput()
                              │
                              ▼
                    getTreeElements()
                              │
                              ▼
                    tree.setChildren()

チェックボックス ─────▶ enableOrDisableBreakpoint ▶ 状態更新
                              │
                              ▼
                    debugService
                    .enableOrDisableBreakpoint()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| breakpointsView.ts | `src/vs/workbench/contrib/debug/browser/breakpointsView.ts` | ソース | メインのBreakpointsViewクラス |
| debugModel.ts | `src/vs/workbench/contrib/debug/common/debugModel.ts` | ソース | ブレークポイントモデル |
| debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | ソース | インターフェース定義 |
| debugIcons.ts | `src/vs/workbench/contrib/debug/browser/debugIcons.ts` | ソース | アイコン定義 |
| disassemblyView.ts | `src/vs/workbench/contrib/debug/browser/disassemblyView.ts` | ソース | 命令ブレークポイント表示先 |
| viewPane.ts | `src/vs/workbench/browser/parts/views/viewPane.ts` | ソース | ViewPaneベースクラス |
