# 画面設計書 38-ロードされたスクリプトビュー

## 概要

本ドキュメントは、VS Codeのロードされたスクリプトビュー（Loaded Scripts View）画面の設計仕様を定義する。デバッグセッション中にロードされたスクリプトファイルを階層的に表示し、ナビゲーションを提供するためのビューである。

### 本画面の処理概要

ロードされたスクリプトビューは、デバッグ中にターゲットプロセスにロードされたすべてのスクリプト/ソースファイルをツリー形式で表示し、ファイルを開く機能を提供する。

**業務上の目的・背景**：動的にロードされるスクリプト（Node.jsのrequire、ブラウザのスクリプトタグ等）をデバッグする際、どのファイルがロードされているかを把握することが重要である。このビューにより、開発者は実行時にロードされたすべてのファイルを確認し、必要に応じてブレークポイントを設定できる。

**画面へのアクセス方法**：
- デバッグビューのサイドバー内「ロードされたスクリプト」セクション
- デバッグセッション開始後に表示
- コマンドパレット「Debug: Focus on Loaded Scripts View」

**主要な操作・処理内容**：
1. スクリプト一覧表示：セッション > フォルダ > ファイルの階層表示
2. スクリプトを開く：ダブルクリックでエディタを開く
3. フィルタ/検索：ファイル名でフィルタリング
4. ソースの追加：インメモリソースの表示

**画面遷移**：
- 遷移元：デバッグセッション開始
- 遷移先：ソースコードエディタ（デバッグスキーマ）

**権限による表示制御**：セッションが終了するとそのセッションのスクリプトは非表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | デバッグ | 主機能 | ロードされたスクリプトの一覧表示 |
| 65 | デバッグ拡張API | API連携 | Debug Adapter経由のソース情報取得 |

## 画面種別

圧縮可能ツリービュー

## URL/ルーティング

- ビューID: `workbench.debug.loadedScriptsView`（LOADED_SCRIPTS_VIEW_ID）
- コンテキストキー: `CONTEXT_LOADED_SCRIPTS_ITEM_TYPE`

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| フィルタ文字列 | 入力 | string | - | スクリプト名のフィルタ |
| スクリプト一覧 | 出力 | LoadedScriptsItem[] | - | ロードされたスクリプト |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ルート | RootTreeItem | ツリーのルート |
| セッション | SessionTreeItem | デバッグセッション |
| フォルダ | RootFolderTreeItem | ワークスペースフォルダ |
| ベースアイテム | BaseTreeItem | パス要素またはソースファイル |
| ソース | Source | デバッグソース |

## イベント仕様

### 1-スクリプト選択（ダブルクリック）

1. ユーザーがスクリプトをダブルクリック
2. tree.onDidOpenイベントハンドラ
3. Source.openInEditorでエディタを開く
4. DEBUG_SCHEMEのURIで表示

### 2-セッション変更

1. debugService.onDidNewSession / onDidEndSessionイベント
2. addSession / removeSessionメソッド呼び出し
3. ツリーを更新

### 3-ソース追加

1. デバッガからloadedSourceイベント
2. セッション内のSourceオブジェクトを取得
3. パス解析してツリー構造に追加
4. ツリーを更新

### 4-フィルタ適用

1. フィルタ入力欄にテキスト入力
2. LoadedScriptsFilterでフィルタ処理
3. ツリーを再描画

## データベース更新仕様

### 操作別データベース影響一覧

本画面は直接的なストレージ更新を行わない。

## メッセージ仕様

| メッージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| loadedScriptsAriaLabel | アクセシビリティ | ツリー | Loaded Scripts |
| loadedScriptItemAriaLabel | アクセシビリティ | アイテム | {0} loaded script |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| セッション終了 | そのセッションのツリーを削除 |
| ソースが見つからない | エラーを無視 |

## 備考

- NEW_STYLE_COMPRESS = trueで新しい圧縮スタイルを使用
- 単一子ノードは圧縮して表示
- URI_SCHEMA_PATTERNでURIスキーマを判定
- ワークスペースフォルダ別にグループ化

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ツリーアイテムの階層構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | loadedScriptsView.ts | `src/vs/workbench/contrib/debug/browser/loadedScriptsView.ts` | BaseTreeItem, RootTreeItem, SessionTreeItem, RootFolderTreeItem |

**読解のコツ**: BaseTreeItemが基本単位、oneChild()メソッドで単一子の圧縮表示を制御。

#### Step 2: エントリーポイントを理解する

LoadedScriptsViewクラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | loadedScriptsView.ts | `src/vs/workbench/contrib/debug/browser/loadedScriptsView.ts` | LoadedScriptsViewクラス（ViewPaneを継承） |

**主要処理フロー**:
- BaseTreeItemクラス（53-239行目）: ツリーノードの基本実装
- RootFolderTreeItem（241-246行目）: ワークスペースフォルダ
- RootTreeItem（248-261行目）: ルートノード
- SessionTreeItem（263-300行目）: セッションノード

### プログラム呼び出し階層図

```
LoadedScriptsView (ViewPane)
    │
    ├─ WorkbenchCompressibleObjectTree 作成
    │      ├─ LoadedScriptsDelegate
    │      ├─ LoadedScriptsFilter
    │      ├─ LoadedScriptsDataSource
    │      └─ LoadedScriptsRenderer
    │
    ├─ RootTreeItem
    │      └─ SessionTreeItem
    │             ├─ RootFolderTreeItem
    │             │      └─ BaseTreeItem (パス/ファイル)
    │             └─ BaseTreeItem (直接)
    │
    ├─ debugService.onDidNewSession()
    │      └─ addSession()
    │
    └─ debugService.onDidEndSession()
           └─ removeSession()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

デバッグセッション開始 ▶ onDidNewSession ──────▶ SessionTreeItem追加
                              │
                              ▼
                    root.add(session)
                              │
                              ▼
                    tree.updateChildren()

ソースロード ─────────▶ addPath() ────────────▶ ツリーノード追加
                              │
                              ▼
                    createIfNeeded()
                              │
                              ▼
                    setSource()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| loadedScriptsView.ts | `src/vs/workbench/contrib/debug/browser/loadedScriptsView.ts` | ソース | メインのLoadedScriptsViewクラス |
| debugSource.ts | `src/vs/workbench/contrib/debug/common/debugSource.ts` | ソース | Sourceクラス |
| debugContentProvider.ts | `src/vs/workbench/contrib/debug/common/debugContentProvider.ts` | ソース | DEBUG_SCHEMEコンテンツプロバイダ |
| debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | ソース | LOADED_SCRIPTS_VIEW_ID等 |
| viewPane.ts | `src/vs/workbench/browser/parts/views/viewPane.ts` | ソース | ViewPaneベースクラス |
