# 画面設計書 39-デバッグツールバー

## 概要

本ドキュメントは、VS Codeのデバッグツールバー（Debug Toolbar）画面の設計仕様を定義する。デバッグセッション中に表示されるフローティングツールバーで、主要なデバッグ操作を提供する。

### 本画面の処理概要

デバッグツールバーは、デバッグセッションがアクティブな場合に画面上部に表示されるフローティングウィジェットで、続行、一時停止、ステップ操作、停止などの主要なデバッグアクションを提供する。

**業務上の目的・背景**：デバッグ作業において、ステップ実行や続行などの操作を素早く行う必要がある。このツールバーにより、開発者はキーボードショートカットやメニューを使わずに、マウスで直接デバッグ操作を実行できる。

**画面へのアクセス方法**：
- デバッグセッション開始時に自動的に表示
- debug.toolBarLocation設定が「floating」の場合のみ表示

**主要な操作・処理内容**：
1. 続行/一時停止：実行の続行または一時停止
2. ステップオーバー：次の行まで実行
3. ステップイン：関数内に入る
4. ステップアウト：関数から抜ける
5. 再起動：デバッグセッションを再起動
6. 停止/切断：デバッグセッションを終了
7. セッション切り替え：マルチセッション時にフォーカスセッションを変更
8. ドラッグ移動：ツールバーの位置を変更

**画面遷移**：
- 遷移元：デバッグセッション開始
- 遷移先：なし（フローティングウィジェット）

**権限による表示制御**：セッションのsuppressDebugToolbar設定により非表示にできる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | デバッグ | 主機能 | デバッグ操作の実行 |

## 画面種別

フローティングウィジェット

## URL/ルーティング

- メニューID: `MenuId.DebugToolBar`
- ストレージキー: `DEBUG_TOOLBAR_POSITION_KEY`, `DEBUG_TOOLBAR_Y_KEY`

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| X位置 | 入力/出力 | number | - | ツールバーの水平位置（0-1の割合） |
| Y位置 | 入力/出力 | number | - | ツールバーの垂直位置（ピクセル） |
| アクション | 入力 | IAction[] | - | 表示するアクションボタン |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ドラッグ領域 | HTMLElement | ツールバーのドラッグハンドル |
| アクションバー | ActionBar | アクションボタンコンテナ |
| 続行ボタン | MenuItemAction | 続行アクション |
| 一時停止ボタン | MenuItemAction | 一時停止アクション |
| ステップオーバー | MenuItemAction | ステップオーバーアクション |
| ステップイン | MenuItemAction | ステップインアクション |
| ステップアウト | MenuItemAction | ステップアウトアクション |
| 再起動 | MenuItemAction | 再起動アクション |
| 停止/切断 | DropdownWithPrimaryActionViewItem | 停止/切断アクション（ドロップダウン付き） |
| セッション選択 | FocusSessionActionViewItem | セッション選択ドロップダウン |

## イベント仕様

### 1-ツールバー表示

1. debugService.onDidChangeStateイベント
2. updateScheduler.schedule()呼び出し
3. 状態がInactive以外かつtoolBarLocation === 'floating'を確認
4. show()でツールバーを表示
5. setCoordinates()で位置を設定

### 2-ドラッグ移動

1. dragAreaでmousedownイベント
2. mousemoveリスナーを登録
3. setCoordinates()で新しい位置を計算
4. mouseupでstorePosition()を呼び出し
5. ストレージに位置を保存

### 3-ダブルクリックでリセット

1. dragAreaでdblclickイベント
2. setCoordinates(0.5, yDefault)で中央にリセット
3. storePosition()で保存

### 4-アクション実行

1. アクションボタンをクリック
2. actionBar.actionRunner.onDidRunイベント
3. エラーがあれば通知
4. テレメトリにログ

### 5-設定変更

1. configurationService.onDidChangeConfigurationイベント
2. debug.toolBarLocationの変更を検知
3. updateScheduler.schedule()で更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象キー | 操作種別 | 概要 |
|----------------|---------|---------|------|
| 位置移動 | debug.actionswidgetposition | UPDATE | X位置（割合）を保存 |
| 位置移動 | debug.actionswidgety | UPDATE | Y位置（ピクセル）を保存 |

### テーブル別更新項目詳細

#### ProfileStorage（StorageScope.PROFILE, StorageTarget.MACHINE）

| 操作 | キー | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | debug.actionswidgetposition | 0-1の数値（X位置割合） | メインウィンドウのみ |
| UPDATE | debug.actionswidgety | 数値（Y位置ピクセル） | メインウィンドウのみ |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| moreRunActionsLabel | ツールチップ | 停止ドロップダウン | More... |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| アクション実行エラー | notificationService.warnでユーザーに通知 |

## 備考

- Themableクラスを継承してテーマ対応
- CSS変数（--x-position, --y-position）で位置を制御
- ウィンドウコントロールとの干渉を避けるため、min/max計算を使用
- 補助ウィンドウではWeakMapで位置を管理
- ピクセル比変更時に位置を再計算

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: クラス構造を理解する

DebugToolBarクラスの継承関係と役割を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | debugToolBar.ts | `src/vs/workbench/contrib/debug/browser/debugToolBar.ts` | DebugToolBarクラス（Themable継承、IWorkbenchContribution実装） |

**読解のコツ**: ThemableでテーマスタイルをサポートしIWorkbenchContributionでワークベンチ貢献として登録。

#### Step 2: 初期化とレイアウトを理解する

UIの構築と位置計算を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | debugToolBar.ts | `src/vs/workbench/contrib/debug/browser/debugToolBar.ts` | コンストラクタ、$el、dragArea、actionBar |

**主要処理フロー**:
1. **48行目**: `class DebugToolBar extends Themable` - Themableを継承
2. **80-95行目**: CSS transform設定（位置計算）
3. **97-119行目**: ActionBarの作成とactionViewItemProvider
4. **121-141行目**: updateSchedulerでの表示/非表示切替

#### Step 3: イベント処理を理解する

ドラッグとアクション実行を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | debugToolBar.ts | `src/vs/workbench/contrib/debug/browser/debugToolBar.ts` | registerListeners、ドラッグ処理 |

**主要処理フロー**:
- **148-158行目**: onDidChangeStateとonDidChangeConfigurationの購読
- **170-177行目**: ダブルクリックで中央リセット
- **179-204行目**: ドラッグ&ドロップ処理

### プログラム呼び出し階層図

```
DebugToolBar (Themable, IWorkbenchContribution)
    │
    ├─ constructor()
    │      ├─ $el (div.debug-toolbar)
    │      ├─ dragArea (ドラッグハンドル)
    │      └─ ActionBar 作成
    │             └─ actionViewItemProvider
    │                    ├─ FocusSessionActionViewItem
    │                    └─ createDisconnectMenuItemAction
    │
    ├─ registerListeners()
    │      ├─ debugService.onDidChangeState
    │      ├─ configurationService.onDidChangeConfiguration
    │      ├─ debugToolBarMenu.onDidChange
    │      ├─ actionBar.actionRunner.onDidRun
    │      ├─ dragArea mouseup (ダブルクリック)
    │      └─ dragArea mousedown (ドラッグ開始)
    │
    ├─ updateScheduler
    │      ├─ 状態確認 (Inactive / floating / suppressDebugToolbar)
    │      └─ show() / hide()
    │
    ├─ setCoordinates()
    │      └─ CSS変数設定 (--x-position, --y-position)
    │
    └─ storePosition()
           └─ storageService.store()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

デバッグ状態変更 ────▶ updateScheduler ─────────▶ show() / hide()
                              │
                              ▼
                    debugToolBarMenu
                    .getActions()
                              │
                              ▼
                    actionBar.push(actions)

ドラッグ操作 ─────────▶ setCoordinates() ────────▶ 位置更新
                              │                     │
                              ▼                     ▼
                    storePosition()           CSS変数更新
                              │
                              ▼
                    storageService.store()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| debugToolBar.ts | `src/vs/workbench/contrib/debug/browser/debugToolBar.ts` | ソース | メインのDebugToolBarクラス |
| debugCommands.ts | `src/vs/workbench/contrib/debug/browser/debugCommands.ts` | ソース | CONTINUE_ID, STOP_ID等のコマンド定義 |
| debugActionViewItems.ts | `src/vs/workbench/contrib/debug/browser/debugActionViewItems.ts` | ソース | FocusSessionActionViewItem |
| debugColors.ts | `src/vs/workbench/contrib/debug/browser/debugColors.ts` | ソース | debugToolBarBackground, debugToolBarBorder |
| debugIcons.ts | `src/vs/workbench/contrib/debug/browser/debugIcons.ts` | ソース | debugGripperアイコン |
| debugToolBar.css | `src/vs/workbench/contrib/debug/browser/media/debugToolBar.css` | スタイル | ツールバーのスタイル |
| themeService.ts | `src/vs/platform/theme/common/themeService.ts` | ソース | Themableベースクラス |
